FILE: 'Alan Kay.md'
---
exported: 2026-02-07T15:52:11.126Z
source: NotebookLM
type: chat
title: Alan Kay on 💬How To Guides
tags:
  - Alan-Kay
  - How-To
author: Alan Kay
---
Based on the investigative philosophy and methodologies of Alan Kay described in the sources, here is a "How-To" guide for conducting a deep investigation. Kay’s approach emphasizes "problem finding" over "problem solving" and shifting context to gain leverage over complexity.

### Phase 1: Problem Finding (The "WIAN" Analysis)

Before attempting to solve a problem, you must determine if you are solving the _right_ problem. Kay argues that most people rush to fix the immediate issue rather than understanding the underlying need.

• **Identify "What Is Actually Needed" (WIAN):** Do not settle for making an existing thing "better." Incremental improvement often leads to "inverse vandalism"—making things better that shouldn't exist at all\[1\]\[2\].

• **Avoid the "Better Old Thing" Trap:** Ask if your investigation is simply repainting an "unfortunate old thing" (like standard operating systems or the Web) rather than inventing a necessary new context\[3\].

• **Establish the Threshold:** Determine if the solution requires a qualitative change (a change in _type_) rather than a quantitative change (a change in _degree_). Incremental progress is usually asymptotic to WIAN, meaning it will never actually reach the goal\[4\].

### Phase 2: Context and Perspective

Kay famously states that "Point of view is worth 80 IQ points"\[5\]\[6\]. Your investigation must explicitly manipulate the context in which the problem is viewed.

• **Shift the Context:** Recognize that you are currently in a specific context (a story or map of reality) that limits your thinking. To solve a hard problem, you usually need to invent a new context\[5\]\[7\].

• **Look for "Power":** Search for "powerful ideas"—concepts that provide leverage. For example, moving from "math thinking" to "science thinking" involves demanding special kinds of evidence and creating models that can be negotiated with phenomena\[8\].

• **Suspicion of Symbols:** Do not confuse the map with the territory. As Kay learned from the "vacuum cleaner" example, understanding the label (e.g., "it uses a vacuum") is not the same as understanding the mechanism (how a fan creates low pressure)\[11\].

### Phase 3: The Investigation Heuristics

Kay utilizes specific cognitive strategies to break down complex problems during the design and research phase.

• **The "10 and 20" Method:** When approaching a major new system or problem:

    1. Write down **10 things** about it (characteristics, principles, or rules).    2. Write down **20 examples** of it in action (ranging from simple things that must be simple, to difficult things that must be possible)\[12\]\[13\].
• **Create with Love, Debug with Disdain:** During the generative phase, be enthusiastic. Once you have a hypothesis or design, become your own harshest critic. Strike out phrases or ideas you "particularly love" to ensure they aren't blinding you\[14\].

• **Use "Explanatory Fictions":** Utilize Daniel Kahneman’s concept of "System 1" (fast, intuitive) and "System 2" (slow, deliberative). Train your intuition (System 1) by laboriously working through problems (System 2) until the new patterns become automatic\[15\].

### Phase 4: Modeling and Simulation

Kay advocates for a "biological" approach to investigation and design, focusing on systems and interactions rather than static data.

• **Biological Decomposition:** Don't just take a clockwork view (gears and levers). View the system as a collection of independent, encapsulated "cells" that communicate via messages. This allows for complex systems that are resistant to crashing\[18\]\[19\].

• **Simulation as Investigation:** Don't just argue or write specs; build a simulation. Whether it is children simulating gravity or researchers simulating a network, the computer allows you to "debug the ideas" by seeing them run\[20\]\[21\].

• **CAD -> SIM -> FAB:** Follow the engineering cycle: Design (CAD), Simulate the design to find errors (SIM), and only then Build/Fabricate (FAB). In software and investigation, we often skip the simulation phase, which leads to weak results\[22\].

### The Questionnaire: What to Ask

When conducting your investigation, Kay’s philosophy suggests asking these specific questions to stress-test your thinking:

**The "Sperry" Questions (borrowed by Kay):**

1\. **What are you doing?** (The easy answer)\[23\].

2\. **Why are you doing it?** (The harder answer)\[24\].

3\. **Why is it important?** (The question that reveals if you are working on WIAN)\[24\].

**The Contextual Questions:**

• **"Is this intrinsic complexity or just complication?"** Is the difficulty part of the problem's nature, or is it a mess created by poor human design (like a "clockwork" instead of a "biological" system)?\[25\].

• **"What is the 'blindness' here?"** In what ways are our senses or cultural stories preventing us from seeing the reality? (e.g., Seeing the world as flat, or thinking "better" is enough)\[26\].

• **"What is the invisible part?"** How can we make the invisible dynamics of this system visible (through charts, simulations, or new sensors)?\[26\]\[27\].

**The Critical Questions:**

• **"Does this scale?"** A good idea in the small often fails in the large. If you build it for 1 user, will it work for 100? If it works for 100, will it work for a billion?\[28\]\[29\].

• **"Are we inventing the future or just preventing it?"** Are we using aphorisms and standard procedures to rationalize the status quo, or are we actively creating the context required for the solution?\[30\].

• **"Why?"** (The recursive question). Do not accept "how" or "what" as answers. Keep asking "Why?" until you reach the foundational principles\[31\].

---
> [!info]- References
> [1] Alan Kay - Quora 2023-11.pdf
> [2] Alan Kay - Quora 2023-11.pdf
> [3] Alan Kay - Quora 2023-11.pdf
> [4] Alan Kay - Quora 2023-11.pdf
> [5] Alan Kay - Quora 2023-11.pdf
> [6] [Book] AlanKay - 70th Points of View.pdf
> [7] Alan Kay - Quora 2023-11.pdf
> [8] Alan Kay - Quora 2023-11.pdf
> [11] Alan Kay - The Center of Why.pdf
> [12] Alan Kay - Quora 2023-11.pdf
> [13] Alan Kay - Quora 2023-11.pdf
> [14] Alan Kay - Quora 2023-11.pdf
> [15] Alan Kay - Quora 2023-11.pdf
> [18] IsSoftwareEngineeringAnOxymoron.pdf
> [19] OOP in a Nutshell From Clockwork to Biology.pdf
> [20] Alan Kay - The Center of Why.pdf
> [21] Kay - The Real Computer revolution hasn't Happened Yet.pdf
> [22] Alan Kay - Quora 2023-11.pdf
> [23] [Book] AlanKay - 70th Points of View.pdf
> [24] [Book] AlanKay - 70th Points of View.pdf
> [25] Alan Kay - Quora 2023-11.pdf
> [26] Alan Kay - Our human condition from space.pdf
> [27] Kay - The Real Computer revolution hasn't Happened Yet.pdf
> [28] Alan Kay - Quora 2023-11.pdf
> [29] Alan Kay - Quora 2023-11.pdf
> [30] Alan Kay - Quora 2023-11.pdf
> [31] Alan Kay - Quora 2023-11.pdf


FILE: 'Alicia Juarrero.md'
---
exported: '2026-02-01T16:08:01.156Z'
source: NotebookLM
type: chat
title: Alicia Juarrero on 💬How To Guides
tags:
  - Alicia-Juarrero
  - How-To
  - Methodology
aliases:
  - Constraints Investigation
author: Alicia Juarrero
---
Based on the frameworks of Alicia Juarrero and Lila Gatlin found in the sources, a **Constraints Investigation** shifts the analytical focus from "what force caused this event?" to "how was the probability of this specific outcome shaped by the restriction of alternatives?"

Here is a how-to guide for conducting an investigation into the constraints of a complex system (biological, social, or mechanical), organized by the hierarchy of constraint types defined in the texts.

### **Phase 1: Map the Possibility Space**

Before analyzing specific constraints, you must define the landscape in which the system operates. In this framework, the "environment" is not a passive container but an active source of gradients and limitations\[1\].

• **Objective:** Determine the system's "prior probability"—what would happen if elements were random and independent?

• **Key Concept:****Equiprobability.** A state of maximum entropy where any arrangement is as likely as any other\[2\],\[3\].

**Questions to Ask:**

1\. **What is the system's "Phase Space"?** If there were no rules or history, what are all the theoretically possible states this system could occupy?\[4\].

2\. **What is the default distribution?** Without intervention, are all outcomes equally likely (randomness), or is there a natural bias?\[5\].

3\. **What are the external boundaries?** What defines the edges of the system versus its environment? (Note: In complex systems, boundaries are often functional interfaces, not just physical walls)\[6\].

\--------------------------------------------------------------------------------

### **Phase 2: Identify Context-Independent Constraints (The "Canvas")**

These are constraints that take the system away from randomness (equiprobability) but do not yet create complex organization. They act as the "boundary conditions" or gradients that allow work to happen\[2\],\[5\],\[7\].

• **Objective:** Identify the fixed limitations and gradients that drive the system away from equilibrium.

• **Key Concept:****Gradients.** Differences (e.g., temperature, resource availability) that drive energy flow\[8\],\[9\].

**Questions to Ask:**

1\. **Where are the gradients?** Is there a source of energy, information, or resources that creates a slope or tendency for movement in one direction? (e.g., thermal gradients, economic inequality)\[10\],\[11\].

2\. **What are the "walls"?** Are there physical or structural barriers that prevent certain states from ever happening regardless of what the parts do? (e.g., the walls of a container, the number of letters in an alphabet)\[3\],\[12\].

3\. **Is there redundancy?** Are there elements repeating (e.g., "more-making") that reduce variety but increase reliability?\[13\],\[14\].

\--------------------------------------------------------------------------------

### **Phase 3: Identify Context-Dependent Constraints (The "Weaving")**

This is the core of complexity. These constraints take the system away from _independence_. They correlate the parts so that the behavior of Part A depends on Part B\[15\],\[16\],\[17\].

• **Objective:** Determine how the components are linked to create a coherent whole.

• **Key Concept:****Conditional Probability.** The probability of _x_ occurring given that _y_ has already occurred\[15\],\[18\].

**Questions to Ask:**

1\. **Where is the interdependence?** Does the behavior of one component alter the probability of the behavior of another? (e.g., "If Q happens, U must follow")\[18\],\[19\].

2\. **Are there Catalysts?** Are there elements that speed up or facilitate connections between other elements without being consumed themselves?\[20\],\[21\],\[22\].

3\. **Are there Feedback Loops?**

    ◦ _Positive Feedback:_ Is there a process amplifying deviation, pushing the system toward a threshold or phase transition?\[23\],\[22\].    ◦ _Negative Feedback:_ Is there a process damping fluctuations to maintain stability?\[23\].
4\. **Is there Constraint Closure?** Do the constraints fold back on themselves so that the system produces the conditions necessary for its own maintenance? (e.g., an autocatalytic cycle)\[24\],\[25\].

\--------------------------------------------------------------------------------

### **Phase 4: Analyze Hierarchical & Mereological Control**

Investigate how the "whole" influences the "parts." This framework argues that once a system self-organizes, the emergent whole acts as a constraint on its components\[26\],\[27\].

• **Objective:** Identify Top-Down (Governing) vs. Bottom-Up (Enabling) constraints.

• **Key Concept:****Interlevel Causality.** The parts create the whole (bottom-up), but the whole regulates the parts (top-down)\[2\],\[26\].

**Questions to Ask:**

1\. **What are the Enabling Constraints (Bottom-Up)?** What interactions between the parts allowed the higher-level system to emerge?\[26\],\[28\].

2\. **What are the Governing Constraints (Top-Down)?** Does the system-level organization restrict the degrees of freedom of the lower-level components? (e.g., Being part of a choir constrains the individual singer's timing and volume)\[29\],\[26\],\[30\].

3\. **Is there "Slaving" or Entrainment?** Have the components synchronized their behavior (rates, cycles) to the rhythm of the whole?\[31\],\[32\].

\--------------------------------------------------------------------------------

### **Phase 5: Investigate History and Time (The "Trajectory")**

Complex systems are path-dependent; they "carry their history on their backs." You cannot explain the current state without the history of constraints\[33\],\[34\].

• **Objective:** Understand how past constraints have sedimented into current structure.

• **Key Concept:****Hysteresis/Path Dependence.** The current state depends on the sequence of previous states\[35\],\[36\].

**Questions to Ask:**

1\. **What is the history of the trajectory?** How did previous choices or events restrict the current possibility space? (e.g., "Why did the agent do X rather than Y?")\[37\].

2\. **Are there Sedimented or Entrenched Constraints?** Are there habits, structures, or rules that formed in the past and are now hard to reverse, acting as fixed context-independent constraints for the present?\[38\],\[39\].

3\. **Is there Generative Entrenchment?** Are there fundamental constraints established early in development (or history) that, if changed, would cause the whole system to collapse?\[40\],\[41\].

\--------------------------------------------------------------------------------

### **Phase 6: Analyze Meaning and Intentionality (If Human/Agent-Based)**

If the system involves agents, constraints explain "meaning" not as a mystical force but as a specific topology of the possibility space\[42\],\[43\].

• **Objective:** Map the semantic space.

• **Key Concept:****Semantic Attractors.** Mental states act as attractors that pull behavior toward a specific outcome\[44\],\[43\].

**Questions to Ask:**

1\. **What is the "Contrast Space"?** What alternatives were actively excluded by the agent's intention? (e.g., "I intended to rob the bank _rather than_ the gas station")\[42\],\[45\].

2\. **Is there Equivocation?** Did the information generated by the intention flow successfully into the behavior, or was it interrupted by "noise" (spasms, slips, external interference)?\[46\],\[47\].

3\. **Are there "Virtual Governors"?** Are there internalized values or norms acting as second-order constraints that regulate the agent's choices top-down?\[48\],\[49\].

### **Summary Checklist for the Analyst**

| Investigation Step | Key Theory Check |
| --- | --- |
| 1. Define Space | Are you looking at the system as a dynamic probability distribution rather than a static object?[4],[5] |
| 2. CI Constraints | Have you identified what keeps the system away from pure randomness (gradients/walls)?[2] |
| 3. CD Constraints | Have you mapped the dependencies? (If A changes, does the probability of B change?)[15] |
| 4. Hierarchy | Are you distinguishing between the influence of the parts on the whole and the whole on the parts?[26] |
| 5. Time | Are you accounting for the sequence of events (history) that locked the system into its current mode?[33] |

---
> [!info]- References
> [1] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [2] Juarrero - The self organization of intentional action.pdf
> [3] Juarrero - intentions as complex dynamical attractors.pdf
> [4] Juarrero - The self organization of intentional action.pdf
> [5] Juarrero - intentions as complex dynamical attractors.pdf
> [6] Juarrero - intentions as complex dynamical attractors.pdf
> [7] [Book] Jarrero - Context Changes Everything.pdf
> [8] Juarrero - precursors and prototypes.pdf
> [9] [Book] Jarrero - Context Changes Everything.pdf
> [10] [Book] Jarrero - Context Changes Everything.pdf
> [11] [Book] Jarrero - Context Changes Everything.pdf
> [12] [Book] Jarrero - Context Changes Everything.pdf
> [13] [Book] Jarrero - Context Changes Everything.pdf
> [14] [Book] Jarrero - Context Changes Everything.pdf
> [15] Juarrero - The self organization of intentional action.pdf
> [16] Juarrero - intentions as complex dynamical attractors.pdf
> [17] [Book] Jarrero - Context Changes Everything.pdf
> [18] Juarrero - intentions as complex dynamical attractors.pdf
> [19] [Book] Jarrero - Context Changes Everything.pdf
> [20] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [21] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [22] Juarrero - The self organization of intentional action.pdf
> [23] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [24] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [25] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [26] Juarrero - The self organization of intentional action.pdf
> [27] Juarrero - intentions as complex dynamical attractors.pdf
> [28] [Book] Jarrero - Context Changes Everything.pdf
> [29] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [30] [Book] Jarrero - Context Changes Everything.pdf
> [31] Juarrero - intentions as complex dynamical attractors.pdf
> [32] [Book] Juarerro - Dynamics in Action.pdf
> [33] Juarrero - intentions as complex dynamical attractors.pdf
> [34] [Book] Juarerro - Dynamics in Action.pdf
> [35] [Book] Jarrero - Context Changes Everything.pdf
> [36] [Book] Jarrero - Context Changes Everything.pdf
> [37] [Book] Juarerro - Dynamics in Action.pdf
> [38] [Book] Jarrero - Context Changes Everything.pdf
> [39] [Book] Jarrero - Context Changes Everything.pdf
> [40] [Book] Jarrero - Context Changes Everything.pdf
> [41] [Book] Jarrero - Context Changes Everything.pdf
> [42] Juarrero - The self organization of intentional action.pdf
> [43] [Book] Juarerro - Dynamics in Action.pdf
> [44] Juarrero - intentions as complex dynamical attractors.pdf
> [45] [Book] Juarerro - Dynamics in Action.pdf
> [46] Juarrero - The self organization of intentional action.pdf
> [47] [Book] Juarerro - Dynamics in Action.pdf
> [48] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [49] [Book] Jarrero - Context Changes Everything.pdf


FILE: 'Barry Richmond.md'
---
exported: '2026-02-01T15:52:08.691Z'
source: NotebookLM
type: chat
title: Barry Richmond on 💬How To Guides
tags:
  - Barry-Richmond
  - How-To
  - Methodology
aliases:
  - Systems Dynamics
author: Barry Richmond
---
Based on the provided sources, particularly the works of Barry Richmond, Derek Hitchins, and the guides from Pegasus Communications, here is a comprehensive "How-To" guide for conducting a study using systems thinking.

This guide moves beyond static analysis ("laundry list thinking") to understanding the dynamic, circular relationships that drive behavior over time.

### **Phase 1: Define the Issue and Scope**

Before analyzing causes, you must rigorously define the problem dynamically. A common mistake is focusing on isolated events rather than patterns.

**Key Concepts:**

• **Dynamic Thinking:** Frame the problem as a pattern of behavior over time, not a one-time event\[1\].

• **Reference Behavior Pattern (RBP):** Create a graph showing how the key variable (e.g., sales, morale, pollution) has changed historically and how you fear or hope it will change in the future\[2\].

• **System-as-Cause:** Assume the structure of the system itself involves the cause of the problem, rather than blaming external forces\[3\]\[4\].

**Questions to Ask:**

• **What is the precise dynamic phenomenon we are trying to understand?** (Avoid static statements like "sales are low." Instead, ask "Why have sales oscillated for the past two years?")\[5\].

• **How has this variable changed over time?** Can we graph the history ("As Is") and the desired future ("To Be")?\[2\].

• **"How can we...?"** (Use this phrasing to elicit perceived barriers to improvement rather than just listing complaints)\[6\].

• **Are we looking at the problem as a "laundry list" of factors?** (If you are listing independent factors like "poor motivation, bad weather, market downturn," you are not yet thinking systemically)\[7\]\[8\].

\--------------------------------------------------------------------------------

### **Phase 2: Hypothesize the Structure (Mapping)**

Once the behavior is defined, you must map the system's "infrastructure" (stocks and flows) and "feedback" (loops) that generate that behavior.

**Key Concepts:**

• **Operational Thinking:** Identify the **Stocks** (accumulations like knowledge, cash, or population) and **Flows** (activities like learning, spending, or birthing) that physically change the system\[9\]\[10\].

• **Closed-Loop Thinking:** Look for circular causality where A causes B, and B eventually feeds back to influence A\[11\].

• **Implicit Systems:** If you identify a symptom (e.g., inefficiency), identify the implicit system responsible for that function (e.g., "The system for work allocation")\[12\].

**Steps and Tools:**

1\. **Identify Key Actors:** Who or what are the main players, and what conditions do they monitor?\[13\].

2\. **Draw the "Main Chain":** Map the sequence of stocks and flows that represent the physical backbone of the process (e.g., Trainees → Junior Staff → Senior Staff)\[14\].

3\. **Close the Loops:** Connect the stocks back to the flows. For example, as the stock of "Inventory" rises, how does it affect the flow of "Production"?\[15\].

**Questions to Ask:**

• **What is accumulating?** (Identify the "bathtubs" or stocks in the system, such as stress, inventory, or trust)\[16\]\[17\].

• **What are the inflows and outflows?** (What activities increase or decrease these stocks?)\[18\].

• **Is the flow stock-generated or flow-generated?** (Does the stock generate the activity, like a population generating births, or does one activity drive another, like reading driving learning?)\[19\]\[20\].

• **Are there significant delays?** (Is there a gap between taking an action and seeing the result? Delays often cause instability)\[21\]\[22\].

\--------------------------------------------------------------------------------

### **Phase 3: Diagnose Using Archetypes**

To accelerate insight, compare your map against known "Systems Archetypes"—common generic structures that recur in organizations.

**Key Concepts:**

• **Fixes That Fail:** A short-term fix relieves a symptom but creates unintended long-term consequences that worsen the problem\[23\].

• **Shifting the Burden:** Reliance on a symptomatic solution (e.g., consultants) erodes the internal capacity to solve the problem (e.g., employee skills)\[24\].

• **Limits to Success:** Initial growth slows down due to a limiting constraint (e.g., capacity, management expertise)\[25\].

**Questions to Ask (Diagnostic):**

• **For "Fixes That Fail":** What are the unintended consequences of our current "quick fixes"? Do these consequences eventually exacerbate the original problem?\[26\].

• **For "Drifting Goals":** Have our goals been lowered over time to match poor performance? What are the standard procedures for correcting gaps between goals and reality?\[27\]\[28\].

• **For "Limits to Success":** What is the "engine" driving our growth? What constraints (physical, personnel, or mental models) will eventually stop this growth?\[25\].

• **For "Tragedy of the Commons":** What common resource are we sharing? What are the incentives for individuals to overuse this resource to the detriment of the group?\[29\]\[30\].

\--------------------------------------------------------------------------------

### **Phase 4: Simulation and Testing**

If possible, move from mapping to simulation (using software like STELLA or iThink) to rigorously test your mental models. Humans are generally poor at mentally simulating complex, non-linear interactions\[1\]\[31\].

**Key Concepts:**

• **Robustness Testing:** "Ping" the model with extreme conditions (shocks) to see if it behaves plausibly. Does the system collapse? Does it return to equilibrium?\[32\]\[33\].

• **Scientific Thinking:** Change one variable at a time to understand its specific impact on the whole\[34\]\[35\].

**Questions to Ask:**

• **Under what conditions does this model stop making sense?** (Challenge the boundaries of your understanding)\[36\].

• **If we change X, what do we** **expect** **to happen?** (Make a prediction before simulating to test your intuition)\[37\].

• **Does the model replicate the Reference Behavior Pattern?** (Can it reproduce the historical data or the dynamic problem defined in Phase 1?)\[35\].

\--------------------------------------------------------------------------------

### **Phase 5: Intervention and Learning**

The goal is not just to model the system but to find "leverage points"—places where small changes produce significant, lasting improvements.

**Key Concepts:**

• **High-Leverage Points:** often found in non-physical variables (like commitment or morale) rather than physical ones (like budget), because non-physical variables do not operate on a zero-sum basis\[38\].

• **Strategic Adaptive Management:** Management should be iterative. Implement a strategy, monitor the feedbacks, and adapt\[39\]\[40\].

**Questions to Ask:**

• **Where are the "high-leverage" interventions?** Can we add a link, break a link, or shorten a delay?\[41\]\[42\].

• **Are we treating the symptom or the fundamental cause?**\[41\].

• **What are the potential side effects of this intervention?** (Map these out in advance to avoid future "Fixes That Fail" scenarios)\[43\].

• **How will we monitor the feedback loops?** (What indicators will tell us if the system is self-organizing in the desired direction?)\[40\]\[44\].

### **Summary Checklist for Your Study**

1\. **Draft a Purpose Statement:** Explicitly state the dynamic phenomenon you wish to understand\[5\].

2\. **Draw the Behavior Over Time:** Sketch the history and projected future of the problem variable\[45\].

3\. **Map the Structure:** Use stocks, flows, and feedback loops to explain _how_ the system generates the behavior\[3\].

4\. **Identify Archetypes:** Does the story fit a classic pattern like "Escalation" or "Growth and Underinvestment"?\[46\].

5\. **Test and Refine:** Challenge your assumptions. Does the structure explain the behavior?\[47\].

6\. **Plan the Intervention:** Focus on changing the structure (rules, information flows, goals) rather than just pushing harder on existing processes\[48\].

---
> [!info]- References
> [1] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [2] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [3] Richmond 1994 systems thinking lets just get on with it.pdf
> [4] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [5] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [6] hierarchical issue method revisited.pdf
> [7] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [8] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [9] Richmond 1994 systems thinking lets just get on with it.pdf
> [10] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [11] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [12] hierarchical issue method revisited.pdf
> [13] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [14] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [15] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [16] Systems-Thinking-Tools-TRST01E.pdf
> [17] Systems-Thinking-Tools-TRST01E.pdf
> [18] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [19] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [20] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [21] Systems-Thinking-Tools-TRST01E.pdf
> [22] Systems-Thinking-Tools-TRST01E.pdf
> [23] Systems Archetypes II.pdf
> [24] Systems Archetypes II.pdf
> [25] Systems Archetypes II.pdf
> [26] Systems Archetypes II.pdf
> [27] Systems Archetypes II.pdf
> [28] Systems Archetypes II.pdf
> [29] Systems Archetypes II.pdf
> [30] Systems Archetypes II.pdf
> [31] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [32] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [33] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [34] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [35] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [36] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [37] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [38] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [39] KV 277.pdf
> [40] KV 277.pdf
> [41] Systems Archetypes II.pdf
> [42] Systems-Thinking-Tools-TRST01E.pdf
> [43] Systems Archetypes II.pdf
> [44] KV 277.pdf
> [45] Systems Archetypes II.pdf
> [46] Systems Archetypes II.pdf
> [47] Richmond - Systems Thinking four key questions.pdf
> [48] Systems-Thinking-Tools-TRST01E.pdf


FILE: 'Bob Williams.md'
---
exported: '2026-02-01T15:55:09.234Z'
source: NotebookLM
type: chat
title: Bob Williams on 💬How To Guides
aliases:
  - IPB
tags:
  - Bob-Williams
  - How-To
  - Methodology
author: Bob Williams
---
Based on the provided sources, here is a "how-to" guide for designing and conducting a systems-based evaluation study. This approach shifts the focus from linear cause-and-effect to understanding complexity through **inter-relationships**, **perspectives**, and **boundaries**\[1\].

### **Phase 1: Getting Started – Defining the "Mess"**

Before defining precise objectives, you must explore the situation in its full complexity. Systems thinking views a project not as an isolated machine, but as part of a wider "mess" or problematic situation\[2\]\[3\].

• **Step 1: Pause and Deliberate.** Do not rush to define the problem or the solution. Where you start determines where you end up\[2\].

• **Step 2: Draw a "Rich Picture".** instead of writing a report, draw the situation. Include structures, processes, conflicts, people, and the emotional climate. This helps capture the "mess" visually before narrowing your focus\[4\]\[5\].

• **Key Question:** What is the general situation of interest, the specific problem, or the solution currently being proposed?\[6\].

\--------------------------------------------------------------------------------

### **Phase 2: Mapping Inter-relationships (The Reality)**

This phase asks: "What is the reality we are dealing with?"\[7\]. You are looking for how things connect, feedback loops, and delays, rather than just simple A-leads-to-B logic\[8\]\[9\].

• **Step 1: Analyze Structure and Process.** Identify the components of the system (stocks) and how things move between them (flows). Look for "feedback loops" where an action feeds back to influence the original cause (e.g., more training leads to better work, which leads to more demand for training)\[8\]\[10\].

• **Step 2: Identify Non-linearity.** Look for effects that are disproportionate to their causes or separated by time (delays)\[9\].

• **Questions to Ask:**

    ◦ What is the nature and structure of the inter-relationships within the situation?\[11\]    ◦ What patterns emerge from these processes, and with what consequences for whom?\[11\]    ◦ How does the system behavior change over time?\[12\]    ◦ Are there circular relationships (feedback loops) where X affects Y, and Y feeds back to affect X?\[13\]\[14\]
\--------------------------------------------------------------------------------

### **Phase 3: Engaging with Perspectives (The Interpretation)**

This phase asks: "How do different people interpret that reality?"\[7\]. A system does not exist objectively; it is defined by how people perceive it\[15\].

• **Step 1: Stakeholder Analysis.** Identify who is involved and who is affected. Remember that stakeholders can have multiple roles\[16\].

• **Step 2: Apply "CATWOE".** To understand a specific perspective (or "holon"), define the system from that viewpoint using this checklist\[17\]\[18\]:

    ◦ **C**ustomers: Who benefits?    ◦ **A**ctors: Who does the work?    ◦ **T**ransformation: What input is transformed into what output?    ◦ **W**orldview (_Weltanschauung_): What makes this meaningful?    ◦ **O**wner: Who can stop it?    ◦ **E**nvironment: What constraints are outside the system's control?
• **Questions to Ask:**

    ◦ What are the different ways this situation can be understood?\[19\]    ◦ How do these interpretations affect how people judge success?\[19\]    ◦ Who are the winners and losers in this scenario?\[20\]
\--------------------------------------------------------------------------------

### **Phase 4: Setting Boundaries (The Judgment)**

This phase asks: "How do we decide what is relevant?"\[21\]. Every evaluation must draw a line between what is included (valued) and what is excluded (marginalized)\[22\]\[23\].

• **Step 1: Boundary Critique.** Use **Critical Systems Heuristics (CSH)** to interrogate the value judgments built into the intervention. You must ask what the situation _is_ versus what it _ought_ to be\[24\].

• **Step 2: Assess the "Client".** Consider the intervention itself as the "client" rather than the funding agency. This allows you to judge merit and worth independently of a single stakeholder's interests\[25\]\[26\].

• **The 12 Critical Questions (The CSH Toolbox):** Ask these in both "is" and "ought" modes\[27\]:

    1. **Beneficiary:** Who ought to be the beneficiary?    2. **Purpose:** What ought to be the purpose?    3. **Measure of Success:** What ought to be the measure of success?    4. **Decision Maker:** Who ought to control the resources?    5. **Resources:** What resources ought to be controlled by the decision-maker?    6. **Environment:** What conditions ought to be outside the decision-maker's control?    7. **Expert:** Who ought to provide the necessary expertise?    8. **Expertise:** What kind of knowledge/expertise is required?    9. **Guarantee:** What provides the guarantee of success (and avoids false guarantees)?    10. **Witness:** Who ought to represent the interests of those affected but not involved?    11. **Emancipation:** To what degree ought the affected be free from the system's effects?    12. **Worldview:** What worldview ought to underlie the system?
\--------------------------------------------------------------------------------

### **Phase 5: Evaluation Design and Feasibility**

Once you have analyzed the system, design the evaluation study itself.

• **Step 1: Determine Purpose.** Is the evaluation for **Demonstration** (proving worth), **Improvement** (making changes), or **Learning** (generating new insights)?\[31\]\[32\].

• **Step 2: Define Scope vs. Focus.** The "scope" is the broad context (the bowl of soup); the "focus" is the specific intervention (the dumpling in the soup). The evaluation often needs to look at the scope to understand the focus\[33\].

• **Step 3: Assess Viability.** Ensure the evaluation design itself is feasible regarding methods, resources, and politics\[34\].

• **Questions to Ask:**

    ◦ What are the criteria for success? (e.g., Efficiency, Efficacy, Effectiveness, Sustainability)\[35\]\[36\].    ◦ Can the consequences of the evaluation be supported administratively, politically, and ethically?\[34\].    ◦ What are the "simple rules" that might guide the system's evolution?\[37\].
### **Summary of Key Shifts in Thinking**

To follow this guide effectively, the evaluator must shift their mental model:

• From "linear cause-and-effect" → to **Circular feedback loops**\[38\].

• From "objective reality" → to **Multiple perspectives**\[39\].

• From "measuring targets" → to **Understanding boundaries and values**\[40\].

• From "blaming individuals" → to **Analyzing systemic failure**\[41\].

---
> [!info]- References
> [1] Evaluation-2011-Hummelbrunner-395-403.pdf
> [2] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [3] Bob Williams - SSM.pdf
> [4] Bob Williams - SSM.pdf
> [5] Systems thinking for evaluation.pdf
> [6] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [7] Libro-Bob-Williams.pdf
> [8] [Book] Williams - Systems concepts in evaluation.pdf
> [9] thinking systemically.pdf
> [10] Systems thinking for evaluation.pdf
> [11] CAP0901_37_ENG_DEF_LR Small.pdf
> [12] Systems thinking for evaluation.pdf
> [13] Systems thinking for evaluation.pdf
> [14] [Book] Williams - Systems concepts in evaluation.pdf
> [15] Systems thinking for evaluation.pdf
> [16] Libro-Bob-Williams.pdf
> [17] Soft Systems Methodology.pdf
> [18] Systems thinking for evaluation.pdf
> [19] CAP0901_37_ENG_DEF_LR Small.pdf
> [20] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [21] Libro-Bob-Williams.pdf
> [22] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [23] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [24] Systems thinking for evaluation.pdf
> [25] Libro-Bob-Williams.pdf
> [26] Libro-Bob-Williams.pdf
> [27] [Book] Williams - Systems concepts in evaluation.pdf
> [31] Libro-Bob-Williams.pdf
> [32] Libro-Bob-Williams.pdf
> [33] Libro-Bob-Williams.pdf
> [34] Libro-Bob-Williams.pdf
> [35] Libro-Bob-Williams.pdf
> [36] Libro-Bob-Williams.pdf
> [37] Systems thinking for evaluation.pdf
> [38] Evaluation-2011-Hummelbrunner-395-403.pdf
> [39] Evaluation-2011-Hummelbrunner-395-403.pdf
> [40] CAP0901_37_ENG_DEF_LR Small.pdf
> [41] Systems thinking for evaluation.pdf


FILE: 'C. West Churchman.md'
---
exported: '2026-02-02T06:03:03.344Z'
source: NotebookLM
type: chat
title: C. West Churchman on 💬How To Guides
tags:
  - How-To
  - NoMethodology
  - West-Churchman
author: C. West Churchman
---
Based on the sources provided, C. West Churchman and his colleagues (such as Harold Nelson and Werner Ulrich) developed a comprehensive framework for investigating complex, "messy" systems—what you are referring to as a **chaordic investigation**. While Churchman typically used terms like "wicked problems" or "messes" rather than "chaordic," his methodology is specifically designed to navigate the tension between rational order (systems) and the chaotic, non-rational forces (politics, morality, religion, aesthetics) that influence them.

Here is a guide to conducting such an investigation, structured around Churchman’s "Anatomy of System Teleology" and his method of "Unfolding."

### Phase 1: Preparation (The Mindset)

Before asking specific questions, the investigator must adopt a specific philosophical stance. A systems investigation is not merely about fixing a mechanical defect; it is a continuous process of learning and reframing.

• **Acknowledge the "Mess":** Accept that the problem is not isolated. It is a "mess" where every problem interacts with other problems\[1\].

• **Adopt the Deception-Perception Principle:** Recognize that your view of the system is restricted. The investigation begins "when first you see the world through the eyes of another"\[2\],\[3\].

• **Prepare for "Sweeping In":** Be ready to expand the boundaries of the investigation to include variables (ethical, political, environmental) that a traditional analysis might exclude as "irrelevant"\[4\],\[5\].

### Phase 2: The Nine Teleological Questions (Mapping the System)

To investigate the structure of the system, you must identify its nine necessary conditions. This is often done by distinguishing between **"What Is"** (descriptive analysis) and **"What Ought to Be"** (normative critique)\[6\],\[7\].

Ask the following nine questions to stakeholders, decision-makers, and yourself:

**1\. Who is the Client?**

• _Question:_ Who is the beneficiary of the system? Whose interests are served?\[8\],\[9\].

• _Chaordic nuance:_ Are there "victims" or "enemies" of the system who are affected but not considered clients?\[10\],\[9\].

**2\. What is the Purpose?**

• _Question:_ What are the goals of the system?\[8\].

• _Chaordic nuance:_ Do the stated goals match the actual outcomes? If the system produces pollution or poverty, are those its unintended "purposes"?\[9\].

**3\. What is the Measure of Performance?**

• _Question:_ How do we know if the system is succeeding?\[8\].

• _Chaordic nuance:_ Is the measure purely economic (e.g., profit), or does it include "quality of life" or "justice"?\[11\],\[12\].

**4\. Who is the Decision Maker?**

• _Question:_ Who has the power to change the measure of performance via resources?\[8\],\[9\].

• _Chaordic nuance:_ Is the decision-making body a "mess" with no recognizable head, jumping unpredictably?\[13\].

**5\. What are the Components?**

• _Question:_ What parts of the system can the decision maker control?\[14\].

• _Chaordic nuance:_ Are we treating people as mere components (means) rather than ends in themselves?\[15\].

**6\. What is the Environment?**

• _Question:_ What factors influence the system but are _not_ controlled by the decision maker?\[8\],\[14\].

• _Chaordic nuance:_ Should we challenge the boundary? Should a factor currently viewed as "fixed environment" actually be brought under control to solve the problem?\[14\].

**7\. Who is the Planner/Designer?**

• _Question:_ Who conceptualizes the system and its changes?\[8\],\[16\].

• _Chaordic nuance:_ Does the designer understand their own value system and biases?\[17\].

**8\. How is the Plan Implemented?**

• _Question:_ How are conceptual plans transported into action?\[16\].

• _Chaordic nuance:_ Does the implementation consider resistance and the political reality of the "polis"?\[18\].

**9\. What is the Guarantor?**

• _Question:_ What guarantees that the designer’s intention will actually be realized and that the system will be "good"?\[19\],\[16\].

• _Chaordic nuance:_ Since there is no absolute guarantor (like God or pure logic), where do we find hope or consensus to proceed?\[20\],\[21\].

### Phase 3: The Dialectical "Unfolding" (Navigating the Chaos)

A chaordic investigation assumes that rational models will inevitably conflict with human realities. You must engage the "Enemies of the Systems Approach"\[10\]. Do not dismiss them; use them to challenge your findings.

• **The Political Check:** Ask how the system concentrates power. Is there a "polis" or group ideology that blinds stakeholders to certain facts?\[18\].

• **The Moral Check:** Ask if the system treats people as means to an end. Does the efficiency of the system create inequity or immorality?\[15\],\[22\].

• **The Religious/Spiritual Check:** Ask what is considered sacred or untouchable within the system. What drives the "spirit" or enthusiasm of the participants beyond mere utility?\[23\].

• **The Aesthetic Check:** Ask if the system is ugly or beautiful. Does it destroy the quality of life or the environment in the pursuit of efficiency?\[24\].

### Phase 4: Synthesis and Redesign

The investigation concludes not with a final answer, but with a design for continuous inquiry (a "Singerian" approach).

• **Identify the Gap:** Compare your answers for "What Is" (Analysis) against "What Ought to Be" (Critique). This gap is the "problematic situation"\[6\],\[25\].

• **Seek Accommodation:** Since consensus on "wicked problems" is rare, seek an accommodation—a version of the situation that conflicting interests can live with\[26\].

• **Design for Feedback:** Ensure the system can learn. If the measure of performance drops, the system should be able to trigger a new investigation\[27\].

**Summary Checklist for the Investigator:**

1\. Have I identified the **Whole System** and its environment?\[2\].

2\. Have I distinguished between **"Is"** and **"Ought"** for all 9 categories?\[6\].

3\. Have I swept in the **"Enemies"** (Politics, Morality, Religion, Aesthetics)?\[10\].

4\. Have I identified the **Victims** (those affected but not involved)?\[28\].

5\. Is the process **Iterative** (never-ending)?\[26\].

---
> [!info]- References
> [1] Mason 2014 - Churchman Interview with Mason and Mitroff.pdf
> [2] Assad 2011 C West Churchman.pdf
> [3] Gigch - 2006 - WISDOM , KNOWLEDGE , AND MANAGEMENT A Critique and Analysis of Churchman's Systems Approach - Unknown.pdf
> [4] Assad 2011 C West Churchman.pdf
> [5] [Book] Churchman - The Design of Inquiring Systems.pdf
> [6] Nelson 2003 - The Legacy of C West Churchman.pdf
> [7] Nelson 2003 - The Legacy of C West Churchman.pdf
> [8] Checkland 1988 - Churchmans Anatomy of System Teleology revisited.pdf
> [9] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [10] Assad 2011 C West Churchman.pdf
> [11] Assad 2011 C West Churchman.pdf
> [12] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [13] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [14] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [15] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [16] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [17] Assad 2011 C West Churchman.pdf
> [18] The systems approach and its enemies - Churchman - abstarcts.pdf
> [19] Checkland 1988 - Churchmans Anatomy of System Teleology revisited.pdf
> [20] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [21] The systems approach and its enemies - Churchman - abstarcts.pdf
> [22] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [23] The systems approach and its enemies - Churchman - abstarcts.pdf
> [24] Churchman - Value Distribution Assessment of Geothermal Development.pdf
> [25] Nelson 2003 - The Legacy of C West Churchman.pdf
> [26] Stowell - The Art of Systems Inquiry - retracing the footsteps of Churchman and Checkland.pdf
> [27] Checkland 1988 - Churchmans Anatomy of System Teleology revisited.pdf
> [28] Retmolds - Churchman and Maturana enriching the notion of self organization for social design.pdf


FILE: 'Christopher Alexander.md'
---
exported: 2026-02-09T23:40:39.345Z
source: NotebookLM
type: chat
title: To conduct an investigation based on Christopher A...
tags:
  - Christopher-Alexander
  - How-To
---
To conduct an investigation based on Christopher Alexander’s principles, you must shift your focus from abstract master planning to the identification of **misfits**, **latent centers**, and the **objective feeling of life** within an environment\[1\]. This approach treats design as a process of "healing" rather than "fabrication"\[4\]\[5\].

Here is a how-to guide for conducting an investigation, including the essential questions to ask at each stage.

### **Phase 1: Observing the Wholeness**

The goal is to understand the "ensemble"—the combined state of the existing environment (context) and the people within it\[6\]\[7\].

• **Action:** Conduct "walkabouts" and deep observations to sense the global order of the site\[1\]\[8\].

• **Questions to Ask:**

    ◦ What are the **natural centers** already present in the land (e.g., high spots, ridges, natural entry points)?\[9\]    ◦ What are the **"hopes and dreams"** and the deep-seated feelings of the people who will inhabit this space?\[10\]\[11\]    ◦ What are the existing **tendencies** (human behaviors or physical forces) that need to be allowed to run free?\[12\]
### **Phase 2: Identifying Misfits (Problem Definition)**

Instead of creating a list of positive requirements, identify specific points of failure. It is easier to define what does _not_ fit than what does\[13\]\[14\].

• **Action:** Scan the environment for "irritants," "incongruities," or "stress" points where the context and form are at war\[15\].

• **Questions to Ask:**

    ◦ "Wherever an instance of **misfit** occurs... what specifically fails, and can it be described?"\[13\]    ◦ Which relations between the environment and its users "obtrude most strongly" or "demand attention"?\[14\]    ◦ What are the specific **forces** (social, economic, or psychological) that are currently in conflict and need resolution?\[18\]\[19\]
### **Phase 3: Decomposing the Complexity**

To manage a complex problem, you must break it down into relatively independent subsystems\[20\]\[21\].

• **Action:** Map the relationships between different misfits to see which ones are "pairwise dependent"\[22\].

• **Questions to Ask:**

    ◦ Which misfits **cohere** functionally and suggest a single physical component of the solution?\[23\]\[24\]    ◦ Can the problem be divided into subsystems where the **information transfer** between them is minimized?\[22\]\[25\]    ◦ What is the **"internal logic"** of the problem that emerges when looking at these clustered forces?\[26\]
### **Phase 4: Seeking Latent Centers**

Look for the potential for order that is not yet fully realized.

• **Action:** Identify parts of the structure that are "dimly present in a weak form" but could contribute to the life of the whole if strengthened\[2\]\[27\].

• **Questions to Ask:**

    ◦ Which **latent center**, if elaborated and developed, would most help the larger whole to become coherent?\[28\]\[29\]    ◦ How can we add new centers to reinforce the existing ones rather than destroying them?\[30\]\[31\]
### **Phase 5: Empirical Testing via Feeling**

Alexander argues that the "life" of a structure is a measurable, objective fact accessible through human feeling\[32\]\[33\].

• **Action:** Use "subjective self-examination" to evaluate the degree of wholeness in a proposed solution or existing structure\[34\].

• **Questions to Ask:**

    ◦ "To what degree does this certain system, or thing, or event, **enhance \[my\] own wholeness**?"\[34\]    ◦ Which of these two options more closely mirrors or expands my "inner self"?\[35\]    ◦ Is this the **simplest differentiation** possible that resolves the conflicting forces?\[36\]
### **Phase 6: Iterative Synthesis**

Apply "structure-preserving transformations" to strengthen the whole, then repeat the process\[30\]\[37\].

• **Action:** Select one latent center and apply one of the **15 geometric properties** (e.g., Boundaries, Strong Centers, Positive Space) to differentiate it\[2\]\[37\].

• **Questions to Ask:**

    ◦ Does this intervention "heal," "sustain," or "improve" the **larger system** outside and beyond the group of elements being worked on?\[38\]\[39\]    ◦ Does the solution preserve the existing global structure while adding the necessary new structure?\[40\]\[41\]

---
> [!info]- References
> [1] A search for beauty a struggle with complexity Alexander.pdf
> [2] A search for beauty a struggle with complexity Alexander.pdf
> [4] Coevolving innovations systems generating systems architectural design theory by Christopher Alexander -1968.pdf
> [5] Systems Changes Ing Learning Alexander Legacy.pdf
> [6] Coevolving innovations systems generating systems architectural design theory by Christopher Alexander -1968.pdf
> [7] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [8] A search for beauty a struggle with complexity Alexander.pdf
> [9] Systems Changes Ing Learning Alexander Legacy.pdf
> [10] Systems Changes Ing Learning Alexander Legacy.pdf
> [11] Systems Changes Ing Learning Alexander Legacy.pdf
> [12] Thesis - Steenseon - architectures of information  christopher alexander  cedric price.pdf
> [13] Thesis - Steenseon - architectures of information  christopher alexander  cedric price.pdf
> [14] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [15] Thesis - Steenseon - architectures of information  christopher alexander  cedric price.pdf
> [18] Systems Changes Ing Learning Alexander Legacy.pdf
> [19] steenson-alexander-article-sm.pdf
> [20] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [21] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [22] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [23] Misfits Balance Requirements and Systems_ Thoughts on Alexande.pdf
> [24] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [25] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [26] [Book] Alexander - Notes on the Synthesis of Form.pdf
> [27] Alexander - Harmony seeking computations.pdf
> [28] Alexander - Harmony seeking computations.pdf
> [29] Alexander - Harmony seeking computations.pdf
> [30] A search for beauty a struggle with complexity Alexander.pdf
> [31] Alexander - Harmony seeking computations.pdf
> [32] Alexander - New Concepts In Complexity Theory.pdf
> [33] Alexander and a phenomenology of wholeness.pdf
> [34] Alexander - New Concepts In Complexity Theory.pdf
> [35] Alexander - New Concepts In Complexity Theory.pdf
> [36] A search for beauty a struggle with complexity Alexander.pdf
> [37] A search for beauty a struggle with complexity Alexander.pdf
> [38] Alexander - Harmony seeking computations.pdf
> [39] Alexander - Harmony seeking computations.pdf
> [40] Alexander - Harmony seeking computations.pdf
> [41] Alexander - Harmony seeking computations.pdf


FILE: 'Claude Shannon.md'
---
exported: '2026-02-02T06:04:03.990Z'
source: NotebookLM
type: chat
title: Claude Shannon on 💬How To Guides
tags:
  - Claude-Shannon
  - How-To
  - NoMethodology
author: Claude Shannon
---
Based on the provided sources—which cover **Information Theory**, **Semiotics** (the study of signs), and **Complex Adaptive Systems**—here is a guide for conducting an investigation into a "chaordic" (complex) system.

In a chaordic environment, linear cause-and-effect is often obscured. Therefore, the investigation must focus on **reducing uncertainty (entropy)**, **identifying constraints**, and **validating patterns** rather than looking for a simple "root cause" immediately.

### Phase 1: Strategy – Reducing Uncertainty

In a high-entropy environment (one with high disorder or uncertainty), the investigator’s primary goal is to acquire information to narrow down possibilities.

**The "Twenty Questions" Strategy**According to information theory, the most efficient way to isolate a specific cause or object from a vast set of possibilities is to ask binary questions that divide the probability space roughly in half\[1\]\[2\].

• **The Principle:** In a game of "Twenty Questions," you can isolate one object from approximately one million possibilities by asking 20 well-structured "yes or no" questions\[1\].

• **The Question to Ask:**_“Does the problem reside in \[Category A\] or \[Category B\]?”_ (e.g., "Is the issue internal or external?" rather than "Who did it?").

• **Why:** This approach uses logarithmic logic to rapidly reduce the "entropy" (uncertainty) of the investigation\[3\]\[4\].

### Phase 2: Detecting Interference – The Semiotic Approach

In complex systems, information is often defined by what is _absent_ or by deviations from the most probable state (disorder). You must look for "constraints" that limit behavior\[5\]\[6\].

**1\. Analyzing "Absence"**Nature and complex systems have "habits" or regularities. Information is generated when a reliable habit fails to manifest\[7\].

• **The Question to Ask:**_“What normally occurs here that has failed to occur?”_

• **The Logic:** The absence of a reliable feature (like the dog that didn't bark in the night) is often the strongest evidence of external interference. If a system naturally tends toward disorder (entropy increase), and it suddenly becomes ordered, or if a regular pattern breaks, something external has performed "work" on the system\[8\]\[9\].

**2\. The Thermodynamic Check**A reduction in entropy (the appearance of order or specific structure) rarely happens spontaneously.

• **The Question to Ask:**_“Is the current state of the system thermodynamically probable?”_

• **The Logic:** If you see a highly organized state (e.g., mud on a shoe, a specific signal in noise), it is evidence that an external influence has intervened. The specific form of this deviation provides the clue to the identity of that influence\[9\].

### Phase 3: Interpreting the Traces – The Detective Method

Physical traces (signs) left in a system limit the possible explanations but do not specify them uniquely. For example, a footprint shows someone walked there, but not who or when, unless cross-referenced\[12\]\[13\].

**1\. Scope of Reference**

• **The Question to Ask:**_“What different causal histories could have produced this specific result?”_

• **The Logic:** Recognize that a single trace (e.g., a log entry, a clinical symptom, a broken part) belongs to a "causal chain." You must extrapolate backward, but be aware that the trace itself does not fully determine the event\[12\]\[13\].

**2\. The Redundancy Check (Fact-Checking)**To distinguish true signals from "noise" or error, you must utilize redundancy.

• **The Question to Ask:**_“Do we have independent sources providing the same information?”_

• **The Logic:** Comparing reports from independent witnesses or data streams reduces interpretive error. If multiple uncorrelated sources point to the same event, the probability of it being a random error (noise) drops significantly\[14\].

**3\. Hypothesis Testing (The "Sting Operation")**In a complex system, you often cannot know the truth without interacting with the system.

• **The Question to Ask:**_“If we behave as though Theory X is true, do the consequences align with our predictions?”_

• **The Logic:** This involves setting up conditions (like a police sting or a controlled experiment) and observing if the system reacts in the predicted manner. This active testing generates new information that confirms or denies the interpretation\[17\]\[18\].

### Phase 4: System Health – Medical & Process Lens

When investigating organizations or "Complex Adaptive Systems" (like healthcare or software), look for flow and interoperability\[19\].

• **The Question to Ask:**_“Where are the suboptimal business processes?”_

    ◦ Look for bottlenecks in the flow (e.g., patient admission to discharge)\[19\].
• **The Question to Ask:**_“Is there a mismatch between process, people, and technology?”_

    ◦ Change in a complex system requires alignment of all three. "Thinking in silos" leads to closed solutions that fail to adapt\[19\].
• **The Question to Ask:**_“What is the 'Value' equation?”_

    ◦ Assess the system by the formula: Value\=Quality/(Risk+Cost+Time)\[19\]. High risk or cost reduces the system's value/viability.
### Summary Checklist for the Investigator

1\. **Bisect the Problem:** Use binary questions to cut the probability space in half\[1\].

2\. **Spot the "Work":** Look for unlikely order or the absence of usual disorder; this points to the external agent\[10\].

3\. **Triangulate:** Never rely on a single trace; use independent sources (redundancy) to filter out noise\[15\].

4\. **Probe the System:** Act on the system (hypothesis testing) to see if it responds as your theory predicts\[17\].

---
> [!info]- References
> [1] [Book] Shannon - Collected Papers of Claude E. Shannon.pdf
> [2] entropy-19-00048.pdf
> [3] entropy-19-00048.pdf
> [4] entropy-19-00048.pdf
> [5] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [6] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [7] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [8] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [9] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [10] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [12] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [13] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [14] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [15] tw deacon - shanon boltzmann darwin - redefining information part II.pdf
> [17] tw deacon - shanon boltzmann darwin - redefining information part II.pdf
> [18] tw deacon - shanon boltzmann darwin - redefining information part II.pdf
> [19] Unknown - Medical Leadership Complex Systems Open Data - Shannon, Shannon - Unknown.pdf


FILE: 'Colin Eden.md'
---
exported: '2026-02-01T15:55:31.567Z'
source: NotebookLM
type: chat
title: Colin Eden on 💬How To Guides
tags:
  - Colin-Eden
  - How-To
  - Methodology
aliases:
  - SODA
author: Colin Eden
---
Based on the provided sources, here is a guide for conducting a Strategic Options Development and Analysis (SODA) investigation. SODA is a methodology designed to help groups tackle "messy" or "wicked" problems by capturing individual views through **cognitive mapping** and merging them to facilitate negotiation and strategic agreement\[1\],\[2\],\[3\].

### Phase 1: Preparation and Team Selection

Before interviewing, you must define the scope and select the participants.

• **Define the Boundary:** Decide which organization or unit the strategy is for (e.g., department, division, or whole company)\[4\].

• **Select the Team:** Choose a "client" and roughly five key "power brokers" to form the strategy-making group. These should be the people who have the power to act and whose commitment is necessary for implementation\[5\],\[4\].

### Phase 2: Individual Interviews (Cognitive Mapping)

The primary method for data collection in SODA is the one-to-one interview, where the facilitator creates a **cognitive map**—a diagram of nodes (concepts) and arrows (causality)—in real-time\[6\],\[7\]. This captures the individual’s "theories-in-action"\[8\].

The Questions to Ask

Unlike a rigid questionnaire, the interview is a conversation guided by the emerging map\[9\].

**1\. Opening the Interview**

• "Discuss some of the strategic issues facing the organization over the next 'n' years" (typically 2–5 years)\[10\],\[11\],\[12\].

• _Tip:_ Encourage the interviewee to focus on the future and issues that are resource-intensive or irreversible\[13\].

**2\. Elaboration (Laddering Down to Options)**When a broad statement is made, ask questions to discover the means or actions required:

• "How might that be done?"\[9\].

• "What action is required?"\[14\].

• "Who, what, where, and when?" (to make the statement actionable)\[15\],\[16\].

**3\. Elaboration (Laddering Up to Goals)**When an issue or option is stated, ask questions to discover the consequences and underlying values:

• "Why is this an important issue?"\[17\].

• "So what?"\[17\],\[9\].

• "What are the consequences of this issue occurring?"\[17\],\[18\].

• "What might happen that is undesirable if we don't address it?" (To identify **negative goals**)\[19\],\[20\].

• "What might we achieve if we were to find an effective way of addressing the issue?"\[19\].

**4\. Clarifying Meaning (Contrasting Poles)**To ensure you understand the specific meaning of a concept (rather than just the dictionary definition), ask for the psychological opposite:

• "What is the opposite of \[Concept X\] in this context?"\[18\].

• "When you say 'increase service quality,' what is the phrase you would use to describe the alternative 'bad' situation rather than just 'decrease service quality'?"\[21\].

• _Note:_ A concept like "increase sales" might have a psychological opposite of "stagnation" for one person and "bankruptcy" for another.

**5\. Unlocking "Deep Knowledge"**If the interviewee is stuck or giving "textbook" answers, use these techniques:

• **The Oracle Question:** "If you had access to an oracle who knew the future, what questions would you wish to ask?" (This highlights key uncertainties)\[22\],\[23\].

• **Critical Incidents:** Ask about a "turning point," a "memorable episode," or a time they were "stopped in their tracks." This reveals what they truly value in practice\[23\].

• **Triading (For values/aspirations):** Select three recent decisions. Ask, "In what way did two of these decisions produce a similar outcome that was different from the third?" Then ask, "Why is that outcome preferred?"\[24\],\[25\].

### Phase 3: Merging and Analysis

Once interviews are complete, the individual maps are merged into a single **Group Strategy Map** (or Cause Map). This aggregates the wisdom of the team and allows the group to see the "whole picture"\[26\],\[27\].

• **Tidying:** Ensure statements are action-oriented (imperative verbs) and merged where meanings are identical\[15\],\[28\].

• **Structuring:** Arrange the map hierarchically.

    ◦ **Heads:** Concepts with no arrows going out (potential goals)\[29\],\[30\].    ◦ **Tails:** Concepts with no arrows coming in (potential detailed options)\[30\],\[31\].    ◦ **Busy Nodes:** Concepts with many arrows in and out. These are potential **Key Strategic Issues**\[32\],\[33\].
• **Tear-drops:** Visualize clusters of arguments as "tear-drops," with a broad issue at the top and detailed options fanning out below\[34\],\[35\],\[36\].

### Phase 4: The SODA Workshop

The merged map acts as a "transitional object" for negotiation. The goal is to move from individual ownership of ideas to group ownership of a strategy\[37\],\[38\].

• **Reviewing the Map:** Present the merged map (often using computer software like Decision Explorer/Group Explorer)\[39\],\[40\]. Allow participants to locate their own contributions first to build trust, then explore others' views\[41\],\[42\].

• **Oval Mapping Technique (Alternative):** If computers are not used, participants can write ideas on oval cards and stick them to a wall, clustering them into "tear-drops" of issues\[43\],\[44\],\[45\].

Questions to Ask During the Workshop

• **Validation:** "Does this link constitute a 'good' explanation? Does A really lead to B?"\[46\].

• **Gap Analysis:** "This cluster seems thin on material but feels important; could you add more?"\[47\].

• **Prioritization:** "If you were forced to identify only a small number of goals/issues, which would they be?" (Use 'preferencing' with sticky dots or electronic voting)\[48\],\[49\].

• **Resource Reality:** "Do we have the resources (cash, time, energy) to implement this portfolio of actions?"\[50\].

### Phase 5: Closure and Action

The investigation must conclude with a commitment to action, not just a map.

• **Confirm Goals:** Agree on a manageable system of 15–20 goals derived from the "heads" of the map\[51\].

• **Define Strategy:** Identify the core "distinctive competencies" and the strategic issues that must be managed to achieve the goals\[52\],\[53\].

• **Action Planning:** Determine who is responsible for specific actions and the timeframe. Ensure each strategy is supported by a "strategic programme" of actions\[54\],\[55\].

---
> [!info]- References
> [1] Ackermann - Extending the scope of problem structuring methods.pdf
> [2] Ackermann - Extending the scope of problem structuring methods.pdf
> [3] Ackermann - Extending the scope of problem structuring methods.pdf
> [4] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [5] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [6] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [7] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [8] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [9] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [10] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [11] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [12] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [13] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [14] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [15] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [16] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [17] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [18] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [19] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [20] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [21] [Book] Eden et al - 1983 - Messing about in problems - Pergamon Press.pdf
> [22] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [23] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [24] [Book] Eden et al - 1979 - Thinking in organizations - Macmillan.pdf
> [25] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [26] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [27] eden use of cognitive maps to structure problems.pdf
> [28] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [29] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [30] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [31] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [32] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [33] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [34] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [35] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [36] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [37] Ackermann - Extending the scope of problem structuring methods.pdf
> [38] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [39] Ackermann - Extending the scope of problem structuring methods.pdf
> [40] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [41] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [42] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [43] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [44] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [45] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [46] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [47] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [48] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [49] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [50] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [51] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [52] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [53] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [54] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [55] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf


FILE: 'Dave Snowden.md'
---
exported: '2026-02-01T15:57:52.856Z'
source: NotebookLM
type: chat
title: Dave Snowden on 💬How To Guides
tags:
  - Dave-Snowden
  - How-To
  - Methodology
aliases:
  - Cynefin
author: Dave Snowden
---
Based on the provided sources, specifically the work surrounding the Cynefin framework and narrative research, an investigation should not follow a traditional hypothesis-based approach (e.g., surveys with direct questions). Instead, it should follow a "naturalizing" sense-making process designed to uncover patterns, weak signals, and context.

Here is a how-to guide for conducting an investigation using these methods, including the specific types of questions to ask.

### Phase 1: Contextualization (Determine the Domain)

Before asking questions of others, the investigation team must determine the nature of the environment they are investigating. This prevents applying the wrong management tools to the problem.

• **The Action:** Use the Cynefin framework to categorize the situation. Is it **Obvious** (clear cause-and-effect), **Complicated** (requires experts), **Complex** (unknown unknowns), or **Chaotic** (crisis)?\[1\]\[2\].

• **The Workshop Method:** Gather a diverse group and place items (events, beliefs, issues) on the framework based on how "tractable" or solvable they seem\[3\]\[4\].

• **The Internal Questions to Ask:**

    ◦ "Have we seen this before?"\[5\]    ◦ "Is the relationship between cause and effect obvious to everyone, or does it require analysis?"\[2\]    ◦ "If we do X, do we know exactly what will happen, or do we need to run an experiment to find out?"\[6\]
### Phase 2: Data Collection (Narrative Capture)

Traditional questionnaires contain hidden hypotheses that bias the results\[7\]. Instead of asking direct questions about opinions, you must elicit **micro-narratives** (anecdotes)\[8\]\[9\].

• **The Rule:** Ask prompting questions that allow the subject to tell a story rather than giving a statement\[10\].

• **The Prompting Questions:**These should be designed to elicit specific experiences. The sources provide several templates:

    ◦ _The "Best Friend" Prompt:_ "Imagine you are in the pub on a Friday night, and an old friend arrives and tells you that they have been offered a job with your company. What story from your own or others’ experience would you tell them if you wanted them to **join**? OR, what story would you tell them if you didn’t want them to **join**?"\[11\].    ◦ _The "Crisis/Ethics" Prompt:_ "Imagine that you have just presented the details about your company to a group of children... A tearful 11-year-old stands up... and says 'I think your company is evil because...' What experience of yours, or of someone you know, would you share in response to that question?"\[12\].    ◦ _The "General Experience" Prompt:_ "What happened?" (Simple, open-ended)\[13\].    ◦ _The Third-Person Permission:_ Always phrase prompts to allow the subject to tell a story about "someone you know" to lower the barrier to sharing sensitive information\[10\].
### Phase 3: Self-Signification (Indexing)

Do not interpret the stories yourself, as this introduces researcher bias\[14\]. Instead, ask the participants to "tag" or index their own stories using abstract shapes (like triangles) and sliders. This turns qualitative stories into quantitative data\[15\]\[16\].

• **The Method:** Ask the participant to locate their story on a triangle where the corners represent three positive but competing attributes (e.g., Altruistic, Assertive, Analytical)\[17\].

• **The Signification Questions (Metadata):**

    ◦ "Why was the story told?" (Options: To attack, to defend, to educate, to entertain, to influence, to inform, to uplift)\[18\].    ◦ "Was the story sacred or everyday?"\[18\].    ◦ "What was the teller's relationship to the story?" (Central character, witness, hearsay, gossip)\[18\].    ◦ "How did this experience make you feel?" (e.g., Frustrated, Helpless, In Control)\[19\].
### Phase 4: Analysis (Pattern Recognition)

Once data is collected, do not look for the "average" answer. Look for clusters and anomalies.

• **The Action:** Look at the visual patterns in the metadata (the triangles and graphs) _first_, before reading the stories\[16\]\[20\].

• **What to Look For:**

    ◦ **Clusters:** High concentrations of dots indicate dominant cultural patterns or beliefs\[21\].    ◦ **Outliers/Weak Signals:** A lone story in an unexpected area may indicate a "weak signal" of a coming crisis or a new innovation opportunity\[20\]\[22\].    ◦ **Conflict:** If different groups (e.g., managers vs. employees) cluster in different areas of the graph, you have identified a cognitive gap\[23\].
### Phase 5: Intervention (Action)

The goal is not to predict the future, but to manage the present\[15\]. The type of action depends on the Cynefin domain identified in Phase 1.

• **If Complex (The Domain of Emergence):**

    ◦ **Strategy:** Probe - Sense - Respond\[2\].    ◦ **The Action:** Create multiple "safe-to-fail" experiments. These are small, contained actions designed to test a hypothesis\[24\]\[25\].    ◦ **The "Vector" Question:** Instead of asking "How do we reach this ideal future state?", ask: "What can we do tomorrow to create **more** stories like these \[positive examples\] and **fewer** like those \[negative examples\]?"\[26\].    ◦ **The Management Question:** "How can we amplify the success or dampen the failure of this experiment?"\[27\].
• **If Chaotic (The Domain of Rapid Response):**

    ◦ **Strategy:** Act - Sense - Respond\[28\].    ◦ **The Action:** Act immediately to establish order (stanch the bleeding), then look for where stability is present to move the situation into the complex domain\[29\].
• **If Complicated (The Domain of Experts):**

    ◦ **Strategy:** Sense - Analyze - Respond\[2\].    ◦ **The Action:** Assemble a panel of experts to investigate the specific cause and effect, but listen for conflicting advice to avoid "entrained thinking"\[30\].

---
> [!info]- References
> [1] 27036324 HBR snowden leaders decision making.pdf
> [2] 27036324 HBR snowden leaders decision making.pdf
> [3] kurtz snowden - IBM Sys Journal.pdf
> [4] kurtz snowden - IBM Sys Journal.pdf
> [5] The-Cynefin-Mini-book-online.pdf
> [6] The-Cynefin-Mini-book-online.pdf
> [7] 100816 Narrative-Research_Snowden FINAL.pdf
> [8] 100816 Narrative-Research_Snowden FINAL.pdf
> [9] Narrative research - Snowden.pdf
> [10] 100816 Narrative-Research_Snowden FINAL.pdf
> [11] 100816 Narrative-Research_Snowden FINAL.pdf
> [12] 100816 Narrative-Research_Snowden FINAL.pdf
> [13] Quinlan - sensemaking in organisations how to create a practical cynefin and sensemaking process - Agile-2019.Sensemaking-and-Complexity.pdf
> [14] 100816 Narrative-Research_Snowden FINAL.pdf
> [15] 044_ Making Sense of Human Systems an interview with Professor Dave Snowden.pdf
> [16] 100816 Narrative-Research_Snowden FINAL.pdf
> [17] Dave-Snowden-IEA14.pdf
> [18] 100816 Narrative-Research_Snowden FINAL.pdf
> [19] Rettig.Snowden-ComplexityTheoryAndNarrativeResearch_notes.pdf
> [20] 100816 Narrative-Research_Snowden FINAL.pdf
> [21] 100816 Narrative-Research_Snowden FINAL.pdf
> [22] 100816 Narrative-Research_Snowden FINAL.pdf
> [23] 100825 Origins of Cynefin.pdf
> [24] 27036324 HBR snowden leaders decision making.pdf
> [25] Cynefin vector theory of change.pdf
> [26] EU Managing Complexity (and chaos) in Times of Crisis.pdf
> [27] Cynefin Paper report.pdf
> [28] 27036324 HBR snowden leaders decision making.pdf
> [29] 27036324 HBR snowden leaders decision making.pdf
> [30] 27036324 HBR snowden leaders decision making.pdf


FILE: 'David L Abel.md'
---
exported: '2026-02-02T06:01:17.353Z'
source: NotebookLM
type: chat
title: David L. Abel
tags:
  - David-L-Abel
  - How-To
  - NoMethodology
---
Based on the provided sources, which focus heavily on the work of David L. Abel, a "chaordic investigation" (an investigation into the relationship between chaos, order, and organization) requires a rigorous distinction between **physicodynamic self-ordering** and **formal self-organization**.

The following guide outlines the steps and critical questions necessary to investigate a system to determine if it arises from natural "chance and necessity" or if it requires "choice contingency" (formalism/agency).

### **Guide to a Chaordic Investigation**

**Objective:** To determine if a system is the result of physicodynamic self-ordering (Chaos/Necessity) or formal organization (Cybernetic Control), and to identify if the "Cybernetic Cut" has been traversed.

\--------------------------------------------------------------------------------

### **Phase 1: Classify the Complexity**

The first step is to categorize the type of complexity observed. You must distinguish between randomness, order, and functional complexity.

**Key Concept:** Order and complexity are antithetical. High order (redundancy) means low complexity; high complexity (randomness) means low order. Neither generates function on its own\[1\]\[2\].

**Questions to Ask:**

1\. **Is the sequence compressible?**

    ◦ _If yes:_ It is highly ordered (Ordered Sequence Complexity - OSC), like a crystal or a polyadenosine string. It has low uncertainty and low information potential\[3\]\[4\].    ◦ _If no:_ It is highly complex. Proceed to the next question.
2\. **Is the complexity random or functional?**

    ◦ _Random Sequence Complexity (RSC):_ It cannot be compressed, but it performs no task. It is "noise" or a stochastic ensemble\[5\]\[6\].    ◦ _Functional Sequence Complexity (FSC):_ It is highly complex (low compressibility) but performs a specific, non-trivial function (e.g., an enzyme, a software program)\[7\]\[8\].
\--------------------------------------------------------------------------------

### **Phase 2: Distinguish Constraints from Controls**

You must determine if the system is shaped by physical laws (constraints) or by arbitrary rules (controls).

**Key Concept:** Laws describe forced, invariant behaviors (constraints). Rules are arbitrary, voluntary, and goal-oriented (controls). Controls are required for true organization\[9\]\[10\].

**Questions to Ask:**

1\. **Are the outcomes determined by invariant laws?**

    ◦ Do the components behave the same way every time due to forces like gravity or electromagnetism (e.g., a vortex forming in a drain)? If so, this is a **Constraint** producing self-ordering, not organization\[11\]\[12\].
2\. **Does the system pursue a goal?**

    ◦ Does the system steer events toward utility or function? Inanimate nature and physicodynamics are "blind" to function. If there is steering toward a goal, **Controls** are present\[13\]\[14\].
3\. **Can the "rules" governing the system be broken?**

    ◦ Physical laws cannot be broken. Formal rules (like linguistic syntax or logic gates) can be broken or disobeyed. If the governing principle can be violated (resulting in loss of function), it is a **Rule/Control**, not a physical law\[15\].
\--------------------------------------------------------------------------------

### **Phase 3: Identify the Source of Information**

Analyze the information within the system. Is it merely statistical uncertainty, or is it prescriptive?

**Key Concept:****Prescriptive Information (PI)** instructs or produces non-trivial function. It represents choices made with intent, not just thermodynamic probability\[18\]\[19\].

**Questions to Ask:**

1\. **Is the information Descriptive or Prescriptive?**

    ◦ Does it merely describe a state (Shannon information), or does it instruct a process (like a recipe or code)?\[19\].
2\. **Is there a Material Symbol System (MSS)?**

    ◦ Are there physical tokens (like nucleotides or letters) that represent something else (amino acids or ideas)? Physicality does not represent; minds/agents create representations\[20\]\[21\].
3\. **Is there a bijection (translation) involved?**

    ◦ Is one set of symbols translated into another (e.g., codons to amino acids)? This requires an arbitrary code, which cannot be generated by physicodynamics\[22\]\[23\].
\--------------------------------------------------------------------------------

### **Phase 4: The "Switch" Test (Dynamic Inertness)**

This is the critical test to see if the system has crossed the "Cybernetic Cut" (the divide between physical law and formal control).

**Key Concept:** True programming requires **Configurable Switches** that are "dynamically inert." This means the switch settings are not determined by physical forces (physics doesn't care if a switch is On or Off)\[24\]\[25\].

**Questions to Ask:**

1\. **Are the "switches" set by physical forces?**

    ◦ Does gravity or magnetism force the switch to a specific position? If yes, it is determined by **Necessity**\[26\]\[27\].
2\. **Are the switches set randomly?**

    ◦ If yes, it is **Chance Contingency**, which does not produce sophisticated function\[28\]\[29\].
3\. **Are the switches set by Choice?**

    ◦ Is the setting uncoerced by physics but selected to achieve a specific potential function? This is **Choice Contingency** and indicates the presence of agency or pre-existing programming\[30\].
\--------------------------------------------------------------------------------

### **Phase 5: Investigation of Origins (Falsification)**

If investigating a claim of "spontaneous self-organization" (e.g., in abiogenesis or artificial life), apply Abel’s null hypotheses.

**Key Concept:** "Self-organization" is often a misnomer for "self-ordering." True organization (systems, circuits, computation) requires crossing the Cybernetic Cut\[33\]\[34\].

**Questions to Ask:**

1\. **Is there hidden investigator involvement?**

    ◦ In simulations or "evolutionary algorithms," did the human experimenter select the fitness function or steer the iterations? If yes, it is not natural self-organization; it is artificial selection\[35\]\[36\].
2\. **Can you falsify the following hypothesis?**

    ◦ _"Physicodynamics alone cannot organize itself into formally functional systems requiring algorithmic optimization, computational halting, and circuit integration"_\[37\]\[38\].
3\. **Does the system generate a "Universal Plausibility Metric" (ξ) < 1.0?**

    ◦ Is the spontaneous formation of the system statistically prohibitive (e.g., requiring fewer trials than available in the history of the universe)? If ξ < 1.0, the hypothesis of spontaneous origin must be rejected\[39\]\[40\].
### **Summary of the Chaordic Investigation Checklist**

| Category | Characteristic of Physicality (Chaos/Necessity) | Characteristic of Formalism (Organization/Life) |
| --- | --- | --- |
| Contingency | Chance (Random) or Necessity (Fixed) | Choice (Selection for potential function)[41][42] |
| Structure | Self-Ordered (e.g., vortex, crystal) | Organized (e.g., circuit, engine)[43][44] |
| Driver | Laws (Constraints) | Rules (Controls/Algorithms)[13][17] |
| Component | Interacting forces | Configurable Switches (Logic Gates)[25][26] |
| Goal | None (Blind to utility) | Pragmatic Utility / Computational Halting[14][45] |

If your investigation finds **Controls, Rules, Prescriptive Information, and Configurable Switches**, the system has traversed the **Cybernetic Cut** and is the result of formal organization (agency/life), not merely chaotic or ordered physical processes\[46\].

---
> [!info]- References
> [1] Abel - Presentation The role of Complexity The Edge of Chaos.pdf
> [2] Abel - Presentation The role of Complexity The Edge of Chaos.pdf
> [3] Abel - Presentation The role of Complexity The Edge of Chaos.pdf
> [4] Abel - Presentation The role of Complexity The Edge of Chaos.pdf
> [5] Abel - Presentation The role of Complexity The Edge of Chaos.pdf
> [6] Abel - The Capabilities of Chaos and Complexity.pdf
> [7] Abel - Is Life Reducible to Complexity.pdf
> [8] Abel - Presentation The role of Complexity The Edge of Chaos.pdf
> [9] Abel - Constraints vs Controls.pdf
> [10] Abel - Constraints vs Controls.pdf
> [11] Abel - Self organisation vs self ordering events in Life origin models.pdf
> [12] Abel - The Three Fundamental Categories of Reality.pdf
> [13] Abel - Constraints vs Controls.pdf
> [14] Abel - Constraints vs Controls.pdf
> [15] Abel - Assembly theory in life-origin models a critical review.pdf
> [17] Abel - The Cybernetic Cut Progressing from Description to Prescription in Systems Theory.pdf
> [18] Abel - Constraints vs Controls.pdf
> [19] Abel - Constraints vs Controls.pdf
> [20] Abel - Linear Digital Material Symbol Systems.pdf
> [21] Abel - Linear Digital Material Symbol Systems.pdf
> [22] Abel - Linear Digital Material Symbol Systems.pdf
> [23] Abel - The capabilities of chaos and complexity.pdf
> [24] Abel - Constraints vs Controls.pdf
> [25] Abel - The Capabilities of Chaos and Complexity.pdf
> [26] Abel - Constraints vs Controls.pdf
> [27] Abel - The Cybernetic Cut Progressing from Description to Prescription in Systems Theory.pdf
> [28] Abel - Constraints vs Controls.pdf
> [29] Abel - The Cybernetic Cut Progressing from Description to Prescription in Systems Theory.pdf
> [30] Abel - Constraints vs Controls.pdf
> [33] Abel - Self organisation vs self ordering events in Life origin models.pdf
> [34] Abel - Self organisation vs self ordering events in Life origin models.pdf
> [35] Abel - Constraints vs Controls.pdf
> [36] Abel - The Capabilities of Chaos and Complexity.pdf
> [37] Abel - The Capabilities of Chaos and Complexity.pdf
> [38] Abel - The capabilities of chaos and complexity.pdf
> [39] Abel - Assembly theory in life-origin models a critical review.pdf
> [40] Abel - Assembly theory in life-origin models a critical review.pdf
> [41] Abel - Constraints vs Controls.pdf
> [42] Abel - The Three Fundamental Categories of Reality.pdf
> [43] Abel - Moving Far From Equilibrium.pdf
> [44] Abel - Moving Far From Equilibrium.pdf
> [45] Abel - Constraints vs Controls.pdf
> [46] Abel - The Cybernetic Cut Progressing from Description to Prescription in Systems Theory.pdf


FILE: 'Dee Hock.md'
---
exported: '2026-02-01T15:50:32.904Z'
source: NotebookLM
type: chat
title: Dee Hock on 💬How To Guides
tags:
  - Dee-Hock
  - How-To
  - Methodology
aliases:
  - Chaordic Stepping Stones
author: Dee Hock
---
Based on the provided sources, a chaordic investigation—often referred to as the **Chaordic Stepping Stones** design process—is a method for planning and organizing within complex, unpredictable environments\[1\]\[2\].

The following guide outlines how to conduct this investigation, emphasizing that the process is **non-linear** and designed to blend chaos (creativity/flexibility) with order (structure)\[2\].

### **Phase 1: The Groundwork**

Before designing any structure or making logistical decisions, you must anchor the work in the following foundational steps.

**1\. Identify the Necessity (The Need)**

This is the compelling, present reason for doing anything\[3\]. It refers to the conditions in the current state of affairs indicating that something must change\[4\].

• **The Goal:** To create a shared understanding of _why_ the work is urgent and important\[5\].

• **Questions to Ask:**

    ◦ What is going on right now that makes this work important?\[5\]    ◦ What are the challenges and opportunities we are facing?\[5\]    ◦ What are we seeing or hearing that tells us we must act now?\[6\]    ◦ Who else do we need to speak with to understand this need more fully?\[7\]

**2\. Define the Purpose**

The purpose is a clear, shared statement of direction\[8\]. It acts as an "invisible leader" for the group\[9\]. Unlike a goal, a purpose is a direction, not a destination, and may evolve as you learn\[5\]\[10\].

• **The Goal:** To clarify the intent and direction of travel\[9\].

• **Questions to Ask:**

    ◦ If this work lived up to its fullest potential, what would be possible?\[3\]    ◦ What could this work create, inspire, or result in?\[3\]    ◦ What are the stories, experiences, or outcomes we want to see more of?\[3\]

**3\. Establish Principles**

Principles are behavioral agreements on how the group will work together\[11\]. They are critical for guiding decisions when plans inevitably break down or the group enters chaotic territory\[11\]\[12\].

• **The Goal:** To create crisp statements of agreement on cooperation and conduct\[11\].

• **Questions to Ask:**

    ◦ How will we work together?\[8\]    ◦ What commitments are we willing to make to one another?\[13\]    ◦ If the plan breaks down, what principles will guide us anyway?\[13\]    ◦ Examples of principles: "Speak respectfully," "Ensure everyone has a chance to speak before decisions are made," or "People impacted must be represented"\[14\].

**4\. Map the People**

You must identify who is involved, their level of commitment, and their role. This often takes the form of concentric rings: a **Core Team** (responsible for the work), **Essential Stakeholders** (provide input/permission), and those who must be **Kept Informed**\[9\]\[15\].

• **The Goal:** To ensure the right people are involved and to check for bias or exclusion\[16\].

• **Questions to Ask:**

    ◦ Who is the core team most committed to this work?\[17\]    ◦ Who needs to give permission?\[17\]    ◦ Who is impacted by the work?\[16\]    ◦ Who has the power to accelerate or impede this work?\[18\]    ◦ Are we excluding anyone based on habit, assumption, or fear?\[16\]
\--------------------------------------------------------------------------------

### **Phase 2: The Design**

Only after the groundwork is laid should you move toward design. This phase distinguishes chaordic design from traditional planning by investigating beliefs before finalizing structure.

**5\. Develop the Concept**

The concept is a high-level framework or metaphor for how the needs and purpose will be met (e.g., deciding whether to build a bridge, a ferry, or a causeway to cross water)\[19\]. It allows you to prototype ideas before solidifying them\[20\].

• **The Goal:** To visualize a high-level approach to test against your purpose\[21\].

• **Questions to Ask:**

    ◦ What is a good high-level approach to addressing our need?\[21\]    ◦ What do we want to experiment with to test effectiveness?\[21\]    ◦ How will we ensure our work reflects our principles?\[22\]

**6\. Confront Limiting Beliefs**

This step is unique to chaordic investigation. It asks you to identify unchecked assumptions and fears that might restrict innovation\[23\]\[24\]. Without this step, groups often inadvertently build their fears into their organizational structure\[25\].

• **The Goal:** To surface fears, attachments to control, and "old ways" of working\[23\].

• **Questions to Ask:**

    ◦ What are we afraid will happen if we try this new approach?\[26\]    ◦ Why are we attached to the "same old way" of doing things?\[26\]    ◦ Who are we judging, avoiding, or excluding, and why?\[27\]    ◦ Can we absolutely know that this fear or belief is 100% true?\[27\]

**7\. Structure**

Only once the concept is chosen and limiting beliefs are addressed do you decide on structure. Structure channels resources (time, money, energy) to enable the work\[28\].

• **The Goal:** To decide on roles, logistics, and decision-making processes\[28\].

• **Questions to Ask:**

    ◦ How will decisions be made and by whom?\[29\]    ◦ What resources (time, money, attention) are needed and where will they come from?\[25\]    ◦ What logistical questions need to be resolved?\[25\]    ◦ What form will the work take (e.g., event, program, organization)?\[25\]
\--------------------------------------------------------------------------------

### **Phase 3: Implementation and Harvest**

Chaordic work focuses heavily on "Harvesting"—the tangible and intangible outputs of the process\[30\].

**8\. Practice and Outputs (Harvesting)**

You must plan for both **tangible outputs** (reports, decisions, products) and **intangible outputs** (relationships, trust, commitment)\[31\].

• **Questions to Ask:**

    ◦ What are the tangible outputs we need (e.g., a report, a plan)?\[32\]    ◦ What are the intangible effects we want (e.g., trust, community, confidence)?\[32\]    ◦ How will we make our learning visible and usable for others?\[33\]    ◦ How will we sustain the work after this specific meeting or initiative ends?\[14\]
### **Leadership Mindset for the Investigation**

To conduct this investigation successfully, the leader must adopt a specific mindset:

• **Educing vs. Compelling:** True leadership draws forth (educes) potential and behavior from participants rather than compelling it through force or authority\[34\].

• **Management Hierarchy:** The investigator must prioritize managing themselves (50% of effort) and their superiors/peers (45% of effort) over managing subordinates\[35\]\[36\].

• **Tolerance for Ambiguity:** The leader must accept that the future is unknowable and focus on preparing for surprise rather than planning for certainty\[37\]\[38\].

---
> [!info]- References
> [1] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [2] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [3] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [4] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [5] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [6] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [7] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [8] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [9] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [10] Corrigan - The Chaordic Stepping Stones.pdf
> [11] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [12] Corrigan - The Chaordic Stepping Stones.pdf
> [13] Corrigan - The Chaordic Stepping Stones.pdf
> [14] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [15] Corrigan - The Chaordic Stepping Stones.pdf
> [16] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [17] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [18] Corrigan - The Chaordic Stepping Stones.pdf
> [19] Corrigan - The Chaordic Stepping Stones.pdf
> [20] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [21] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [22] Corrigan - The Chaordic Stepping Stones.pdf
> [23] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [24] Corrigan - The Chaordic Stepping Stones.pdf
> [25] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [26] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [27] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [28] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [29] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [30] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [31] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [32] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [33] Corrigan - The Chaordic Stepping Stones.pdf
> [34] the_art_of_chaordic_leadership_hock.pdf
> [35] the_art_of_chaordic_leadership_hock.pdf
> [36] the_art_of_chaordic_leadership_hock.pdf
> [37] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [38] Chaordic Systems Thinking for organizational holnic renewal.pdf


FILE: 'Derek Cabrera.md'
---
exported: 2026-02-04T22:42:38.706Z
source: NotebookLM
type: chat
title: Derek Cabrera on 💬How To Guides
tags:
  - Derek-Cabrera
  - How-To
author: Derek Cabrera
---
To conduct a **DSRP investigation**, one must follow a structured, iterative process designed to align **mental models (**M**)** with the **material complexity of the real world (**R**)**\[1\]\[2\]. This guide outlines the foundational loop, the tactical mapping steps, and the critical questions used to deconstruct and understand any system.

### Phase 1: The ST/DSRP Loop (The Investigative Engine)

Every investigation is governed by a continuous, recursive feedback loop called the **ST/DSRP Loop**\[3\]\[4\]. You do not simply "solve a problem"; you **iterate towards understanding**\[5\]\[6\].

1\. **Build Your Mental Model:** Use the four DSRP rules to organise your current information\[7\]\[8\].

2\. **Test the Approximation:** Compare your model against the real-world system to see where it fails to match\[7\].

3\. **Observe and Incorporate Feedback:** Gather new information from the real world (observables)\[7\].

4\. **Evolve the Model:** Use DSRP to restructure your thinking based on that new information\[7\]\[9\].

5\. **Repeat:** Continuously cycle through these steps to improve the "parallelism" between your mind and nature\[10\]\[11\].

\--------------------------------------------------------------------------------

### Phase 2: Tactical Steps for Systems Mapping

When conducting a formal investigation into a specific issue, follow these **five tactical steps** to build a comprehensive map\[12\]:

• **Step 1: Splat Map it.** List all the **identities** (ideas, things, or people) that initially seem relevant to the system\[12\]\[13\].

• **Step 2: Organise into Part-Whole Systems.** Group the "splat" items into systems. Determine which items are **parts** of a larger **whole**\[12\]\[14\].

• **Step 3: Consider the Top-Level Model.** Identify the primary **relationships** between your top-level systems\[15\]\[16\].

• **Step 4: Relate Parts at Level 2.** Drill down. Do not just relate the wholes; examine how the **sub-parts** within those systems interact with each other\[15\].

• **Step 5: Look from Different Perspectives.** Identify **points-of-view** (stakeholders, concepts, or objects) that can see the system differently\[17\]\[18\].

\--------------------------------------------------------------------------------

### Phase 3: The "Thinkquiry" Question Set

Use these specific questions to trigger **metacognition** (thinking about your thinking) during the investigation\[5\]\[19\]:

1\. Distinctions (Identity ↔ Other)

• **What is \_\_\_\_\_\_?** (Identify the core idea)\[20\]\[21\].

• **What is \_\_\_\_\_\_** **not****?** (Define the boundary by identifying what is excluded)\[20\]\[22\].

• **What are the distinctions we are seeing vs. not seeing?**\[23\].

• **Is my distinction MECE/NONG** (Mutually Exclusive, Collectively Exhaustive / No Overlaps, No Gaps)?\[24\]\[25\].

2\. Systems (Part ↔ Whole)

• **What are the parts of \_\_\_\_\_\_?** (Deconstruct the item)\[26\]\[27\].

• **What is \_\_\_\_\_\_ a part of?** (Contextualise the item within a larger whole)\[28\]\[29\].

• **Can I "zoom in" to see more parts or "zoom out" to see more wholes?**\[30\]\[31\].

• **Am I locked into a categorical hierarchy?** (Challenge if items can be grouped differently)\[32\].

3\. Relationships (Action ↔ Reaction)

• **How does \_\_\_\_\_\_ relate to \_\_\_\_\_\_?**\[27\]\[33\].

• **What is the action and the reaction between these items?**\[34\]\[35\].

• **Can I distinguish this relationship?** (Treat the relationship line as its own identity and name it)\[32\]\[36\].

• **What are the parts of the relationship?** (Zoom into a relationship to see it as a system)\[27\].

4\. Perspectives (Point ↔ View)

• **What is the point and what is the view of this perspective?**\[35\]\[37\].

• **From the perspective of \_\_\_\_\_\_, what do we see?**\[28\].

• **Can I take a conceptual perspective?** (e.g. view the problem from an "economic," "legal," or "biological" lens)\[18\]\[38\].

• **What perspectives are missing or marginalized?**\[39\]\[40\].

\--------------------------------------------------------------------------------

### Phase 4: Refinement and Bias Check

Finally, use this **10-step checklist** to interrogate your completed investigation\[25\]\[41\]:

1\. Are my distinctions **necessary and sufficient**?\[25\].

2\. Am I **"othering"** (marginalising an excluded group) through my distinctions?\[24\]\[41\].

3\. Have I scaled up (+1) and scaled down (-1) from my current level of thinking?\[42\]\[43\].

4\. Am I locked into **categorical thinking**?\[41\].

5\. Have I identified **webs of causality** rather than just linear cause-and-effect?\[44\]\[45\].

6\. Have I **RDS'd** my relationships (Relate → Distinguish → Systematise)?\[32\]\[41\].

7\. What perspective is the whole system from, and am I **comfortable with that bias**?\[39\]\[40\].

8\. Are all my perspectives **"with eyes"** (human) or have I included **conceptual** ones?\[40\]\[46\].

9\. Does any node appear so significant that it requires its own **secondary analysis**?\[46\].

10\. Is there anything in the view that should actually be a **point-of-view**?\[40\].

---
> [!info]- References
> [1] Cabrera - A Mathematical Theory of organizational DSRP as The Universal Reality Code.pdf
> [2] Cabrera - Summary of DSRP Research Findings.pdf
> [3] Cabrera - Hard and Soft Methods in Complex Adaptive Systems.pdf
> [4] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [5] Cabrera - Hard and Soft Methods in Complex Adaptive Systems.pdf
> [6] Cabrera Cabrera 2019 Reference Work Entry - What Is Systems Thinking.pdf
> [7] Cabrera Cabrera 2019 Reference Work Entry - What Is Systems Thinking.pdf
> [8] Common Biases in Systems Thinking.pdf
> [9] Common Biases in Systems Thinking.pdf
> [10] Cabrera - DSRP Theory - A Primer.pdf
> [11] Cabrera Cabrera 2019 Reference Work Entry - What Is Systems Thinking.pdf
> [12] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [13] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [14] Cabrera Cabrera 2019 Reference Work Entry - What Is Systems Thinking.pdf
> [15] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [16] What Is Systems Thinking – Derek Cabrera.pdf
> [17] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [18] Cabrera Cabrera 2019 Reference Work Entry - What Is Systems Thinking.pdf
> [19] Cabrera - Systems Thinking Flash Cards.pdf
> [20] Balan - how to improve systems thinking in aid.pdf
> [21] Cabrera - Systems Thinking Flash Cards.pdf
> [22] Balan - how to improve systems thinking in aid.pdf
> [23] Cabrera - DSRP Theory - A Primer.pdf
> [24] Cabrera - Hard and Soft Methods in Complex Adaptive Systems.pdf
> [25] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [26] Balan - how to improve systems thinking in aid.pdf
> [27] Cabrera - Systems Thinking Flash Cards.pdf
> [28] Balan - how to improve systems thinking in aid.pdf
> [29] Balan - how to improve systems thinking in aid.pdf
> [30] Cabrera - Developing and Validating a Measurement of Systems Thinking - The Systems Thinking and Metacognitive Inventory.pdf
> [31] Cabrera - Metacognitive awareness of Distiunctions Systems Relationships and Prespectives Increases Cognitive Complexity.pdf
> [32] Cabrera - Hard and Soft Methods in Complex Adaptive Systems.pdf
> [33] Balan - how to improve systems thinking in aid.pdf
> [34] Cabrera - DSRP Theory - A Primer.pdf
> [35] Common Biases in Systems Thinking.pdf
> [36] Cabrera Cabrera 2019 Reference Work Entry - What Is Systems Thinking.pdf
> [37] Cabrera - Perspectives Organize Information in Mind and Nature.pdf
> [38] Cabrera - Frameworks for Transdisciplinary Research.pdf
> [39] Cabrera - Hard and Soft Methods in Complex Adaptive Systems.pdf
> [40] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [41] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf
> [42] Cabrera - Summary of DSRP Research Findings.pdf
> [43] Cabrera - Systems Organize Information in Mind and Nature.pdf
> [44] Cabrera - From One Cause to Webs of Causality.pdf
> [45] What Is Systems Thinking – Derek Cabrera.pdf
> [46] Cabrera - The Universal Cognitive Grammar of Systems Mapping - A Rubric to Evaluate the Various Tools and Techniques of Systems Mapping.pdf


FILE: 'Donella Meadows.md'
---
exported: '2026-02-02T06:03:34.045Z'
source: NotebookLM
type: chat
title: Donella Meadows on 💬How To Guides
tags:
  - Donella-Meadows
  - How-To
  - NoMethodology
author: Donella Meadows
---
Based on the provided sources, particularly the works of Donella Meadows, there is no explicit definition of a "chaordic" investigation (a term often associated with Dee Hock, blending chaos and order). However, Meadows extensively discusses systems that exist on a "chaotic edge," where small changes can drive a system from order to "wild disorder"\[1\]\[2\]. She argues that complex systems are self-organizing, nonlinear, and inherently unpredictable—characteristics that require a specific investigative approach she calls "Dancing with Systems"\[3\]\[4\].

The following guide outlines how to conduct a systems investigation into these complex environments, structured around Meadows’ methodologies for understanding system behavior and identifying leverage points.

### **Phase 1: Preparation and Mindset**

Before asking specific questions about the system, you must adopt a stance of humility and learning. We cannot impose our will upon a system; we can only listen to it\[5\].

• **Step 1: Expose Your Mental Models.**

    ◦ Acknowledge that everything you know is only a model\[6\].    ◦ **Action:** Write down your assumptions. Use pictures, arrows, or lists to show what you _think_ is connected to what\[7\].    ◦ **Goal:** Invite others to challenge your assumptions. Collect multiple hypotheses rather than championing one\[6\].
• **Step 2: "Get the Beat" of the System.**

    ◦ Before disturbing the system, watch how it behaves. Do not focus on static data (snapshots); focus on history and behavior over time\[8\].    ◦ **Action:** Create time graphs of actual data. Avoid relying solely on people’s memories, which can be unreliable regarding timing\[8\].    ◦ **Goal:** Focus on facts rather than theories to avoid falling into misconceptions\[9\].
### **Phase 2: Mapping the Anatomy of the System**

A "chaordic" or complex system is composed of stocks, flows, and feedback loops. You must map these to understand the system's structure.

• **Step 3: Identify Stocks and Flows.**

    ◦ **Stocks:** Identify the foundation of the system—the accumulation of physical or non-material assets (e.g., water in a dam, money in a bank, trust in government)\[10\].    ◦ **Flows:** Identify the inflows (deposits, births) and outflows (withdrawals, deaths) that increase or decrease the stocks\[11\].
• **Step 4: Identify Feedback Loops.**

    ◦ **Positive Loops (Self-Reinforcing):** Look for the engines of growth, explosion, or collapse. These amplify change (e.g., the more people catch the flu, the more they infect others)\[12\]\[13\].    ◦ **Negative Loops (Self-Correcting):** Look for the stabilizing mechanisms that balance the system (e.g., a thermostat)\[14\]. Note that "emergency" negative loops are often invisible until the system is stressed\[15\].
### **Phase 3: The Investigation – Questions to Ask**

To investigate where to intervene (leverage points), you must move from the least effective changes (numbers) to the most effective (paradigms). Ask the following questions, ordered from lowest to highest leverage:

**Level 1: The Physical and Mechanical (Low Leverage)**

• **Regarding Parameters:** Are we just "diddling with details" (e.g., changing the minimum wage, spending slightly more on police)? These numbers rarely change the behavior of the system\[16\]\[17\].

• **Regarding Buffers:** Are the stocks (buffers) large enough to stabilize the system? (e.g., Is there enough water in the reservoir? Is the inventory too small, making the system brittle?)\[18\]\[19\].

• **Regarding Physical Structure:** Is the "plumbing" of the system laid out incorrectly? (Note: This is often rarely a leverage point because physical rebuilding is slow and expensive)\[20\]\[21\].

**Level 2: The Dynamics and Feedbacks (Medium Leverage)**

• **Regarding Delays:** Are there delays in the system causing us to overshoot or undershoot our goals? Is the information timely? Is the response time too slow?\[22\]\[23\].

• **Regarding Balancing Loops:** Is the feedback signal clear, unambiguous, and timely? Are we weakening the system's self-correcting powers (e.g., removing emergency response mechanisms to save costs)?\[15\]\[24\].

• **Regarding Reinforcing Loops:** What is driving the runaway growth or collapse? Can we slow down the growth rate rather than trying to strengthen the brakes?\[25\].

**Level 3: The Design and Intent (High Leverage)**

• **Regarding Information Flows:** Who _does not_ have access to information? Can we restore missing feedback loops? (e.g., Making pollution levels public caused companies to reduce emissions)\[26\]\[27\].

    ◦ _Critical Question:_ Are decision-makers receiving direct, compelling feedback on the consequences of their actions?\[28\].
• **Regarding Rules:** What are the incentives, punishments, and constraints? Who has the power to make the rules?\[29\]\[30\].

• **Regarding Self-Organization:** Is the system allowed to experiment and evolve? Are we encouraging diversity and variability, or are we crushing it to maintain control?\[31\]\[32\].

**Level 4: The Purpose and Paradigm (Highest Leverage)**

• **Regarding Goals:** What is the _actual_ goal of the system, deduced from its behavior, not its rhetoric? (e.g., Is the goal of the corporation actually "profit" or "growth at any cost"?)\[33\].

    ◦ _Critical Question:_ Does the goal of the subsystem (e.g., a tumor cell) trump the goal of the whole system (the body)?\[34\].
• **Regarding Paradigms:** What are the unstated assumptions that give rise to the system? (e.g., "Growth is good," "One can own land")\[35\]\[36\].

    ◦ _Action:_ Keep pointing at the anomalies and failures in the old paradigm\[37\].
### **Phase 4: Taking Action (Systemic Responsiveness)**

In a complex or chaotic environment, you cannot "control" the result. You must "dance" with it.

• **Move from "Prediction" to "Envisioning":** Do not try to foresee the future exactly. Envision what you want and design for it\[5\].

• **Trial and Error:** Because the system is complex, you must learn by experiment. Take small steps, monitor constantly, and be willing to change course\[38\]\[39\].

• **Expand Horizons:**

    ◦ **Time:** Look beyond the next election or payback period\[40\].    ◦ **Space:** Look beyond your immediate community to the whole system\[41\].    ◦ **Caring:** Expand the boundary of caring, as the system is interconnected\[42\].
• **Celebrate Complexity:** Abandon the attraction to straight lines and uniformity. Recognize that the universe is messy, nonlinear, and dynamic\[43\].

### **Modern Application: Systemic Responsiveness**

Recent interpretations of Meadows' work suggest moving from purely "seeing" the system structure to "being" in the system's relationships\[44\].

• **Sense-Making:** Instead of just metrics, tune into emotional rhythms ("Get the beat")\[45\].

• **Rituals:** Design rituals to overcome barriers to collaboration (Intervening at the "Goals" level)\[46\].

• **Flow:** Shift from enforcing mandates to enabling conditions for people to do their best work (Intervening at the "Rules" level)\[46\].

---
> [!info]- References
> [1] D Meadows Places To Intervene 1997.pdf
> [2] Leverage_Points.pdf
> [3] Meadows.pdf
> [4] Meadows.pdf
> [5] Meadows.pdf
> [6] Meadows.pdf
> [7] Meadows.pdf
> [8] Meadows.pdf
> [9] Meadows.pdf
> [10] Leverage_Points.pdf
> [11] Leverage_Points.pdf
> [12] Leverage_Points.pdf
> [13] Leverage_Points.pdf
> [14] Leverage_Points.pdf
> [15] Leverage_Points.pdf
> [16] Leverage_Points.pdf
> [17] Leverage_Points.pdf
> [18] Leverage_Points.pdf
> [19] Leverage_Points.pdf
> [20] Leverage_Points.pdf
> [21] Leverage_Points.pdf
> [22] Leverage_Points.pdf
> [23] Meadows.pdf
> [24] Leverage_Points.pdf
> [25] Leverage_Points.pdf
> [26] Leverage_Points.pdf
> [27] Leverage_Points.pdf
> [28] Meadows.pdf
> [29] Leverage_Points.pdf
> [30] Leverage_Points.pdf
> [31] Leverage_Points.pdf
> [32] D Meadows Places To Intervene 1997.pdf
> [33] Leverage_Points.pdf
> [34] Leverage_Points.pdf
> [35] Leverage_Points.pdf
> [36] Leverage_Points.pdf
> [37] Leverage_Points.pdf
> [38] Meadows.pdf
> [39] Meadows.pdf
> [40] Meadows.pdf
> [41] Meadows.pdf
> [42] Meadows.pdf
> [43] Meadows.pdf
> [44] Seeing Differently Insights from Donella Meadows.pdf
> [45] Seeing Differently Insights from Donella Meadows.pdf
> [46] Seeing Differently Insights from Donella Meadows.pdf


FILE: 'Fred Emery.md'
---
exported: '2026-02-01T16:00:15.155Z'
source: NotebookLM
type: chat
title: Fred Emery on 💬How To Guides
tags:
  - Fred-Emery
  - How-To
  - Methodology
aliases:
  - OST
author: Fred Emery
---
Conducting an investigation based on **Emery’s Open Systems Theory (OST\[E\])** requires a specific methodology known as the **Two-Stage Model**, which integrates the **Search Conference** for strategic planning and the **Participative Design Workshop (PDW)** for structural redesign\[1\]\[2\]. The goal is to achieve **active adaptation**, where a system and its environment are directively correlated toward a desirable future\[3\]\[4\].

The following guide outlines the investigation process and the specific questions to ask at each stage.

### **Phase 1: The Search Conference (Strategic Investigation)**

The Search Conference investigates the relationship between the system (the organization or community) and its **extended social field (L22)**\[5\]\[6\].

**Step 1: Environmental Scan (L22)**

Before looking inward, the investigation must analyze the external world to identify **relevant uncertainty** and emerging trends\[7\]\[8\].

• **Questions to ask:**

    ◦ What significant changes have occurred in the world around us in the last 5–7 years?\[7\]\[9\]    ◦ Which of these changes are "**embryos of social change**" that might indicate future value shifts?\[10\]\[11\]    ◦ Based on these trends, what is the **most probable future** for our world?\[12\]    ◦ What is our **most desirable future** for the world (identifying shared human ideals)?\[12\]\[13\]

**Step 2: System Analysis (L11)**

The focus shifts to the internal history and current state of the organization\[14\]\[15\].

• **Questions to ask:**

    ◦ What are the significant historic events that have shaped us as a system?\[16\]\[17\]    ◦ Looking at our current operations, what must we **keep, drop, and create** to be adaptive?\[16\]\[18\]

**Step 3: Creating the Most Desirable Future (L12/L21)**

This step establishes a new **system principle**—the unique relation between the system and its environment\[19\]\[20\].

• **Questions to ask:**

    ◦ **Where and what do we want to be** in year X?\[10\]\[21\]    ◦ What are our strategic goals for this most desirable system?\[20\]\[22\]    ◦ How can we use the **strategy of the indirect approach** to get around obstacles and constraints?\[10\]\[23\]
\--------------------------------------------------------------------------------

### **Phase 2: The Participative Design Workshop (Structural Investigation)**

Once the strategy is set, the investigation must determine if the organization’s structure is capable of implementing it\[24\]\[25\]. This phase focuses on moving from **Design Principle 1 (DP1/Bureaucracy)** to **Design Principle 2 (DP2/Democracy)**\[26\]\[27\].

**Step 1: Analysis of the Current Structure**

Analyze the existing structure using the **Six Criteria** (intrinsic motivators) for productive activity\[28\]\[29\].

• **Questions to ask:**

    ◦ **Elbow Room:** Do people have optimal autonomy in decision-making?\[30\]\[31\]    ◦ **Learning:** Can people set their own goals and get timely feedback?\[30\]\[31\]    ◦ **Variety:** Is there an optimal level of variety to avoid boredom or fatigue?\[32\]\[33\]    ◦ **Mutual Support:** Do workers get help and respect from their peers without asking?\[32\]\[33\]    ◦ **Meaningfulness:** Can people see the whole product and the social value of their work?\[34\]\[35\]    ◦ **Desirable Future:** Is this a career path for personal growth rather than a dead-end job?\[35\]\[36\]    ◦ **Skills Matrix:** What skills are currently held, and where are the gaps for start-up?\[37\]\[38\]

**Step 2: Redesigning for DP2**

Participants redesign their own workflow to relocate responsibility for coordination and control to the people doing the work\[28\]\[39\].

• **Questions to ask:**

    ◦ How do we restructure into **self-managing groups**?\[26\]\[40\]    ◦ How do we ensure that responsibility for control and coordination is located **at the level of the doer**?\[26\]\[41\]    ◦ How do we create a **hierarchy of functions** (peers negotiating) instead of a hierarchy of personal dominance?\[42\]\[43\]

**Step 3: Practicalities for Effectiveness**

The final step is to operationalize the new design\[37\]\[44\].

• **Questions to ask:**

    ◦ What is our comprehensive set of **measurable goals** (including social and environmental)?\[37\]\[45\]    ◦ What are the specific training requirements based on our skills matrix?\[37\]\[44\]    ◦ How will we transition to a system of **pay for skills and knowledge held**?\[42\]\[46\]
\--------------------------------------------------------------------------------

### **Key Principles of an OST Investigation**

1\. **Direct Perception:** Participants must extract information directly from their environment rather than relying on external experts\[10\]\[47\].

2\. **Puzzle Learning:** Approach the investigation as a **jigsaw puzzle** (finding where pieces fit) rather than problem-solving (which assumes a known end-point)\[10\]\[48\].

3\. **Rationalization of Conflict:** Do not seek artificial consensus; place irreconcilable differences on a "**disagreed list**" and proceed on the common ground\[49\]\[50\].

4\. **Ownership:** The design must be created by those who do the work, as people do not resist their own plans\[51\]\[52\].

---
> [!info]- References
> [1] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [2] Emery Open or Closed Systems.pdf
> [3] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [4] The Search Conference - Rehm on Emery.pdf
> [5] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [6] The Search Conference - Rehm on Emery.pdf
> [7] The Search Conference - Rehm on Emery.pdf
> [8] The Search Conference - Rehm on Emery.pdf
> [9] The Search Conference - Rehm on Emery.pdf
> [10] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [11] Emery Open or Closed Systems.pdf
> [12] The Search Conference - Rehm on Emery.pdf
> [13] The Search Conference - Rehm on Emery.pdf
> [14] Emery Open or Closed Systems.pdf
> [15] The Search Conference - Rehm on Emery.pdf
> [16] The Search Conference - Rehm on Emery.pdf
> [17] The Search Conference - Rehm on Emery.pdf
> [18] The Search Conference - Rehm on Emery.pdf
> [19] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [20] Emery 2000 - The Evolution of Open Systems to the 2 Stage Model.pdf
> [21] Emery Open or Closed Systems.pdf
> [22] The Search Conference - Rehm on Emery.pdf
> [23] The Search Conference - Rehm on Emery.pdf
> [24] Emery 2000 - The Evolution of Open Systems to the 2 Stage Model.pdf
> [25] The Search Conference - Rehm on Emery.pdf
> [26] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [27] Emery Open or Closed Systems.pdf
> [28] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [29] Improving Productivity - 2025.pdf
> [30] Improving Productivity - 2025.pdf
> [31] Participative Design - Work and Community Life - 1974 - 2022 Revision.pdf
> [32] Improving Productivity - 2025.pdf
> [33] Participative Design - Work and Community Life - 1974 - 2022 Revision.pdf
> [34] Improving Productivity - 2025.pdf
> [35] Participative Design - Work and Community Life - 1974 - 2022 Revision.pdf
> [36] Improving Productivity - 2025.pdf
> [37] Emery 2000 - The Evolution of Open Systems to the 2 Stage Model.pdf
> [38] Participative Design - Work and Community Life - 1974 - 2022 Revision.pdf
> [39] The Search Conference - Rehm on Emery.pdf
> [40] The Search Conference - Rehm on Emery.pdf
> [41] Improving Productivity - 2025.pdf
> [42] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [43] Participative Design - Work and Community Life - 1974 - 2022 Revision.pdf
> [44] Participative Design - Work and Community Life - 1974 - 2022 Revision.pdf
> [45] Emery Open or Closed Systems.pdf
> [46] Improving Productivity - 2025.pdf
> [47] The Search Conference - Rehm on Emery.pdf
> [48] The Search Conference - Rehm on Emery.pdf
> [49] The Search Conference - Rehm on Emery.pdf
> [50] The Search Conference - Rehm on Emery.pdf
> [51] Emery Open or Closed Systems.pdf
> [52] Participative Design - Work and Community Life - 1974 - 2022 Revision.pdf


FILE: 'Geoffrey Vickers.md'
---
exported: '2026-02-01T15:59:55.483Z'
source: NotebookLM
type: chat
title: Geoffrey Vickers on 💬How To Guides
tags:
  - Geoffrey-Vickers
  - How-To
  - Methodology
aliases:
  - Appreciative Inquiry
author: Geoffrey Vickers
---
Based on the works of Sir Geoffrey Vickers and the interpretative frameworks provided in the sources (particularly by Checkland, Casar, and Burt), the following is a guide for conducting an investigation using the concept of **Appreciation** or the **Appreciative System**.

Unlike standard problem-solving, which often assumes a linear path to a fixed goal, this approach views investigation as a cyclical process of maintaining relationships and regulating norms\[1\]\[2\].

### **Core Principle: The Appreciative Cycle**

Before asking questions, the investigator must understand that human action is not merely "goal-seeking" (like a rat in a maze) but "norm-setting" and "relationship-maintaining"\[3\]\[4\]. The investigation seeks to uncover the **Appreciative Settings**: the tacit standards, values, and readinesses to notice certain things and ignore others\[5\]\[6\].

The investigation revolves around three inseparable types of judgment: **Reality**, **Value**, and **Instrumental**\[1\].

\--------------------------------------------------------------------------------

### **Step-by-Step Guide to an Appreciative Investigation**

**Phase 1: Reality Judgment (Making Sense of "What Is")**

The goal here is not just to gather raw data, but to understand how the situation is _perceived_ and _constructed_ by the participants. Facts are relevant only in relation to the values of the observer\[9\]\[10\].

**Key Task:** Select relevant facts from the "flux of events and ideas" and identify the history of the situation\[11\]\[12\].

**Questions to Ask:**

• **Contextual History:** "How did we get here?" and "Where are we currently located in the stream of time?"\[13\].

• **Selective Perception:** "What aspects of the situation are we noticing, and what are we ignoring?" (Recognizing that our interests define what we see as factual)\[14\].

• **Systemic State:** "What is the current 'state of the system,' both internally and in its external relations?"\[9\]\[15\].

• **Prediction:** "What is likely to happen in the future if current trends continue?" (This is a prediction based on the current reality judgment)\[16\]\[17\].

• **Shared Perceptions:** "Do the different stakeholders see the 'same' reality? Where do their descriptions differ?"\[18\].

**Phase 2: Value Judgment (Determining "What Ought to Be")**

This phase involves comparing the perceived reality against norms and standards. It is not about finding an objective "truth" but determining what is acceptable or unacceptable to those involved\[10\]\[19\].

**Key Task:** Identify the norms (standards of what is expected) and values (principles) that generate "mismatch signals" (dissatisfaction) or "match signals" (reassurance)\[1\]\[20\].

**Questions to Ask:**

• **Norm Identification:** "What are the standards by which we are judging success or failure in this situation?"\[21\].

• **Mismatch Signals:** "Is the current situation acceptable or unacceptable? If unacceptable, what specific relationship is out of balance?"\[1\]\[22\].

• **Value Conflict:** "Are there conflicting values or norms at play here?" (e.g., Is the drive for efficiency conflicting with the need for stability?)\[22\]\[23\].

• **Relationship Maintenance:** "What relationships are we trying to maintain, modify, or elude?"\[1\]\[24\].

• **Expectations:** "What are our self-expectations and our mutual expectations of each other?"\[25\].

**Phase 3: Instrumental Judgment (Deciding "What To Do")**

This is the executive phase where actions are selected to reduce the mismatch between "what is" and "what ought to be." However, in Vickers' view, the action must also be "appreciated" (evaluated) before being taken\[26\].

**Key Task:** Derive action from the discrepancy between reality and value, while acknowledging constraints.

**Questions to Ask:**

• **Options:** "What can be done to reconcile the difference between the observed reality and our expected standards?"\[1\].

• **Constraints:** "What is 'for us' and what is 'not for us'?" (Role assumptions that limit available actions)\[27\].

• **Feasibility:** "Is the proposed action actually possible within our current resources and constraints?"\[26\].

• **Feedback:** "If we take this action, how will it alter the situation and, crucially, how will it alter our _view_ (appreciation) of the situation?"\[28\]\[29\].

\--------------------------------------------------------------------------------

### **Practical Framework: The Triple 'E' Model**

For a practical application of Vickers' concepts in an organizational setting (e.g., project management or policy reform), you can utilize the **Triple 'E' Model** (Explore, Experiment, Experience) developed to synthesize Vickers' work with Ackoff's problem structuring\[30\]\[31\].

**1\. Explore (Inquiry and Discussion)**

• **Activity:** Engage stakeholders to discuss their perspectives.

• **Goal:** Gain an appreciation of the context and the expectations of different actors.

• **Guide:** Do not look for a single problem definition; look for the "mess" of interacting problems and conflicting worldviews\[32\]\[33\].

**2\. Experiment (Testing Ideas)**

• **Activity:** Float ideas and assess responses.

• **Goal:** Test potential instrumental judgments.

• **Guide:** See how colleagues respond to proposed changes. Does the new idea fit their "appreciative setting" or does it require them to learn new ways of seeing?\[34\]\[35\].

**3\. Experience (Situated Practice)**

• **Activity:** Share, collate, and evaluate the results of actions.

• **Goal:** Continuous learning.

• **Guide:** Use the experience to "reset" the appreciative system—updating the norms and readinesses to see for the next cycle\[35\]\[36\].

\--------------------------------------------------------------------------------

### **Summary Checklist for the Investigator**

When conducting this inquiry, the investigator must remember that the **Appreciative System** is a filter\[37\]. You are not observing an objective world, but a world filtered through interests and values.

1\. **Map the Flux:** Identify the events, ideas, people, and organizations moving through time\[11\]\[12\].

2\. **Identify the Norms:** What are the tacit standards governing behavior?\[38\].

3\. **Detect the Mismatch:** Where does "what is" deviate from "what ought to be"?\[22\].

4\. **Analyze the Constraints:** What limits the ability to act?\[39\].

5\. **Monitor the Learning:** How has the act of investigation itself changed the views (the appreciative settings) of the participants?\[28\]\[40\].

---
> [!info]- References
> [1] Appreciative systems.pdf
> [2] Vickers - relationship maintenance as an alternative to goal seeking.pdf
> [3] Heijden 2008 - Towards a framework to understand purpose in futures studies the role of Vickers Appreciative System.pdf
> [4] Vickers - relationship maintenance as an alternative to goal seeking.pdf
> [5] Blackmore - Laerning for communication about climate change using Vickers apprecative inquiry.pdf
> [6] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [9] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [10] vickers relationship maintenance as an alternative to goal seeking.pdf
> [11] Blackmore - Laerning for communication about climate change using Vickers apprecative inquiry.pdf
> [12] Blackmore - Laerning for communication about climate change using Vickers apprecative inquiry.pdf
> [13] 25610337.pdf
> [14] Judgment from [Book] Vickers - The Vickers Papers.pdf
> [15] vickers relationship maintenance as an alternative to goal seeking.pdf
> [16] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [17] [Book] Vickers - The Vickers Papers.pdf
> [18] Lewis 1991 - The decision making basis for information systems the contribution of Vickers appreciation.pdf
> [19] Judgment from [Book] Vickers - The Vickers Papers.pdf
> [20] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [21] Appreciative systems.pdf
> [22] [Book] Vickers - The Vickers Papers.pdf
> [23] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [24] Checkland 2005 - Webs of Significance - the work of Geoffrey Vickers.pdf
> [25] Williams 2005 - Geoffrey Vickers Philosopher of Responsibility.pdf
> [26] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [27] Heijden 2008 - Towards a framework to understand purpose in futures studies the role of Vickers Appreciative System.pdf
> [28] Blackmore - Laerning for communication about climate change using Vickers apprecative inquiry.pdf
> [29] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [30] Triple_E_model_chapter.pdf
> [31] explore experiment expeience - ackoff bateson vickers Triple_E_model_chapter.pdf
> [32] Triple_E_model_chapter.pdf
> [33] Triple_E_model_chapter.pdf
> [34] Triple_E_model_chapter.pdf
> [35] Triple_E_model_chapter.pdf
> [36] Triple_E_model_chapter.pdf
> [37] Lewis 1991 - The decision making basis for information systems the contribution of Vickers appreciation.pdf
> [38] 4531518.pdf
> [39] Appreciative systems.pdf
> [40] The Appreciative Cycle.pdf


FILE: 'George Lakoff.md'
---
exported: '2026-02-01T16:03:55.695Z'
source: NotebookLM
type: chat
title: George Lakoff on 💬How To Guides
tags:
  - George-Lakoff
  - How-To
  - Methodology
author: George Lakoff
---
Based on the work of George Lakoff provided in the sources, an investigation into political discourse, public policy, or social issues requires probing the unconscious cognitive structures—frames, metaphors, and narratives—that shape how we perceive reality.

Here is a how-to guide for conducting a cognitive and linguistic investigation, including the specific questions you should ask.

### Phase 1: Identify the Surface Frames and Language

The first step is to analyze the language being used. Words are not neutral; they are defined relative to conceptual frames. When you hear a word, its frame is activated in your brain\[1\]\[2\].

**Steps:**

1\. **Identify Specific Terms:** Look for specific phrases that are repeated (e.g., "tax relief," "illegal immigrants"). Determine what frame these words evoke. For example, using "relief" implies there is an affliction and a hero who removes it\[3\].

2\. **Check for "Orwellian Language":** Look for language that seems to mean the opposite of what it says (e.g., "Healthy Forests Initiative" for a bill that allows clear-cutting). This often points to political weakness on that specific issue\[4\]\[5\].

3\. **Detect Hypocognition:** Determine if there are concepts missing entirely. If a concept does not exist in your culture or vocabulary (hypocognition), it is difficult to perceive or discuss certain realities\[6\].

**Questions to Ask:**

• **The Relationship Question:** regarding specific phrases (like "permission slip"), ask: "Think about who has to ask for a permission slip. Think about who is being asked. Think about the relationship between them"\[7\].

• **The Framing Question:** If you negate the opponent's claim (e.g., "I am not a crook"), are you actually reinforcing their frame? Remember the rule: "Don't think of an elephant"\[2\].

• **The Definition Question:** When people use terms like "liberal" or "freedom," ask for their specific definitions. Concepts like freedom are "contested concepts," meaning different moral systems define them in opposite ways\[8\]\[9\].

### Phase 2: Analyze Metaphors and Narratives

Political and social reality is defined by metaphors and narratives that highlight certain truths while hiding others\[10\]\[11\].

**Steps:**

1\. **Identify the Source and Target:** Determine what physical or familiar domain (source) is being used to understand a complex or abstract domain (target). For example, is an argument being understood as war? (e.g., "He _shot down_ my arguments")\[12\].

2\. **Check for Highlighting and Hiding:** Metaphors create a partial reality. Investigate what the metaphor highlights and, crucially, what it hides. For example, viewing a "nation as a person" hides the internal diversity of the country\[10\].

3\. **Analyze the Narrative Structure:** Complex narratives are built from simple frames with roles (Hero, Victim, Villain). Determine which roles are being assigned to whom\[13\]\[14\].

**Questions to Ask:**

• **The Hiding Question:** If a specific metaphor is used (e.g., "War on Terror"), what does this metaphor hide? Does it hide the root causes or the non-military solutions (like police work)?\[15\].

• **The Role Question:** In this narrative, who is cast as the Hero? Who is the Villain? Who is the Victim?\[14\].

• **The Family Question:** How does this view of the nation correspond to a view of the family? Does the logic follow a "Strict Father" model (discipline, punishment, hierarchy) or a "Nurturant Parent" model (empathy, responsibility, protection)?\[4\]\[16\].

### Phase 3: Determine the Moral System and Causation

Underlying every political position is a moral system. An investigation must determine which moral logic is being applied.

**Steps:**

1\. **Locate the Moral Core:** Determine if the argument relies on "Strict Father" morality (authority, discipline, self-interest) or "Nurturant Parent" morality (empathy, responsibility)\[17\]\[18\].

2\. **Analyze Causation:** Determine if the subject views the world through **Direct Causation** (bad things are caused by bad people/lack of discipline) or **Systemic Causation** (bad things are caused by the structure of whole systems)\[19\]\[20\].

3\. **Check for "Privateering":** Investigate if the capacity of the government is being destroyed to allow private corporations to take over critical functions (e.g., Blackwater, privatization of public resources)\[21\].

**Questions to Ask:**

• **The Causation Question:** Is the problem being framed as a failure of individual discipline (Direct) or a failure of the system (Systemic)?\[22\].

• **The "Bad Apple" Question:** Is a systemic problem being framed as a "Bad Apple" problem (blaming an individual to protect the system)?\[23\].

• **The Privateering Question:** Is the government being forcefully defunded or dismantled to allow private profit from public missions?\[21\].

### Phase 4: The "Ecological" Inquiry (Policy Investigation)

When investigating a specific policy or proposal, Lakoff suggests a "New Enlightenment" approach that moves beyond simple cost-benefit analysis. You must investigate the systemic and moral consequences\[24\].

**Questions to Ask (The Ecological Checklist):**

• **The Empathy Question:** "What are a policy's empathetic consequences—how does it affect all that we are connected to?"\[24\].

• **The Biological Question:** "How does it affect the natural world? Does it sustain life, or does it harm life?"\[24\].

• **The Connection Question:** "How am I personally connected to its consequences, as a human being?"\[24\].

• **The Future Question:** "How will it affect future generations?"\[24\].

• **The Freedom Question:** "Is it fair and does it make us more free?"\[24\].

### Phase 5: Self-Reflection and Action

Finally, an investigation requires examining your own cognitive biases.

**Steps:**

1\. **Check for Biconceptualism:** Recognize that people (including yourself) may use different moral models for different issues\[25\].

2\. **Avoid the Rational Actor Myth:** Do not assume people act solely on rational self-interest. They vote their identity and values\[26\]\[27\].

**Questions to Ask:**

• **The Reframing Question:** Am I just negating the opponent's frame? How can I restate the issue using my own moral values (e.g., protection, empowerment, dignity)?\[28\]\[29\].

• **The Trap Question:** Am I falling into a conservative framing trap by accepting their premise or language? (e.g., accepting "tax relief" instead of "investing in the future")\[30\]\[31\].

---
> [!info]- References
> [1] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [2] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [3] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [4] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [5] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [6] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [7] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [8] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [9] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [10] [Book] Lakoff - Metaphors We Live By.pdf
> [11] [Book] Lakoff - Metaphors We Live By.pdf
> [12] [Book] Lakoff - Metaphors We Live By.pdf
> [13] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [14] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [15] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [16] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [17] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [18] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [19] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [20] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [21] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [22] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [23] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [24] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [25] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [26] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [27] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [28] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [29] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [30] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [31] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf


FILE: 'Gregory Bateson.md'
---
exported: 2026-02-05T07:56:17.046Z
source: NotebookLM
type: chat
title: Gregory Bateson on 💬How To Guides
tags:
  - Gregory-Bateson
  - How-To
author: Gregory Bateson
---
Based on the provided sources, particularly the works of Ison & Russell, Bednar et al., and Bateson’s own writings on methodology (double description, abduction), here is a guide for conducting an investigation into living, complex (or "chaordic") systems.

This type of investigation does not seek linear causes for specific effects but rather looks for patterns of relationship, context, and the interplay between order (redundancy) and chaos (entropy/randomness)\[1\]\[2\].

### **Guide to Chaordic Investigation**

This investigation is cyclical and recursive, moving between observation of data ("first-order") and reflection on the categories and premises used to observe ("second-order")\[3\]\[4\].

**Phase 1: Establishing the Context and Agency**

**Goal:** To define the system based on the problem/interest rather than fitting the problem into pre-existing rigid boundaries\[5\].

• **Action:** Identify the "unit of survival" or the system of interest. Remember that the boundary of the system is not a physical shell (like skin) but a pathway of information transmission\[6\]\[7\].

• **Method:****Analysis A (Individual/Particulars).** Focus on the specific situation, competence, and personal context of the participants involved\[8\].

• **Key Questions to Ask:**

    ◦ **Who has agency?** Identify who has the power to act and to what end within the relationship\[9\].    ◦ **What are the particularities?** What are the specific aims, goals, and local conditions (the "what" and "where")?\[8\].    ◦ **Where are the boundaries?** Determining boundaries should incorporate data from both the biophysical domain and the psychosocial domain\[10\]\[11\]. _Note: Boundaries are often "fictitious lines" drawn by the observer_\[6\]_._

**Phase 2: Generating Patterns (First-Order Inquiry)**

**Goal:** To collect descriptions of events and behaviors to find redundancies (patterns)\[12\]\[13\].

• **Action:** Engage in **Double Description**. Collect information from at least two different sources or perspectives (e.g., binocular vision). One description is not enough; the combination of two generates an extra dimension of insight (depth)\[14\]\[15\].

• **Method:** Use "Abduction." Look for recognizable similarities between different events or systems (e.g., "How is the anatomy of this crab similar to the structure of this argument?")\[16\]\[17\].

• **Key Questions to Ask:**

    ◦ **What are the patterns of data over time?** Look for the existence of specified events or experiences that repeat\[12\].    ◦ **Is this a difference that makes a difference?** Information is not just data; it is a difference that triggers a response. Does this specific change alter the system's behavior?\[18\]\[19\].    ◦ **What is the "news"?** Since systems respond to changes (differences), what specific changes are currently activating the system?\[20\].

**Phase 3: Investigating Worldviews and Context (Second-Order Inquiry)**

**Goal:** To understand the mental models, myths, and "rules of the game" that govern how the system interprets data\[21\]\[22\].

• **Action:****Analysis B (Group/Inter-individual).** Move from individual data to group worldviews. Investigate the "myths" or dominant narratives that shape meaning outside of conscious awareness\[21\]\[22\].

• **Method:****Reframing.** Seek additional contextual data to understand _why_ the data looks the way it does. This gives meaning to the "first-order" data collected in Phase 2\[21\].

• **Key Questions to Ask:**

    ◦ **What are the dominant mythologies?** How is meaning being made by reference to institutional or cultural "stories" (often outside of awareness)?\[21\].    ◦ **Why? (The Reflection Dynamics).** Why are these specific solution sets or "truths" perceived as the only options?\[23\].    ◦ **What are the alternative roads?** Inquiry into competitive goals and the political feasibility of different worldviews\[23\].    ◦ **What is the context of this context?** If a specific behavior is observed (e.g., a "stimulus"), is it a response to a context, or a context marker?\[24\].

**Phase 4: Synthesis and Evaluation**

**Goal:** To evaluate the effectiveness of decisions and the "fit" of the system, acknowledging ambiguity\[25\].

• **Action:****Evaluation C.** Evaluate the analysis process itself. Move from "presenting problems" to "dispositional" focus (how one positions oneself in the flow of living)\[23\]\[26\].

• **Method:****Recursive Reflection.** Reflect on how the observer's own presence and assumptions have shaped the investigation. (The observer must be included within the focus of observation\[27\]).

• **Key Questions to Ask:**

    ◦ **How has the action taken been judged by stakeholders?** Use collective judgments on how well the generated "problem" represented the key needs\[25\].    ◦ **Is there ambiguity?** Ambiguity and uncertainty should be treated as reflections of non-absolutist understandings, not errors to be removed. Does the inquiry allow participants to speak from their respective positions without forcing a false consensus?\[28\].    ◦ **What is the "pattern which connects"?** How do the separated parts (e.g., crab, lobster, orchid, human) relate through a shared meta-pattern?\[2\].
### **Summary Checklist for the Investigator**

1\. **Do not isolate the phenomenon:** Remember that the "unit of survival" is the organism _plus_ its environment\[6\]\[29\].

2\. **Avoid linear causality:** Do not ask "Why did X cause Y?" in a simple linear sense. Instead, ask about the circular chains of determination and feedback loops\[30\]\[31\].

3\. **Hunt for the "Not":** In cybernetic systems, cause is often negative (restraint). Ask "Why did this _not_ happen?" or "What constraints prevented alternative outcomes?"\[32\]\[33\].

4\. **Use Abduction:** Actively look for formal resemblances between seemingly unlike systems to generate new hypotheses\[16\]\[34\].

---
> [!info]- References
> [1] The Pattern which connects Gregory Bateson.pdf
> [2] [Book] Bateson Gregory - Mind and Nature.pdf
> [3] Bednar et al. - 2014 - Evaluation processes Lessons from Bateson ’ s second order learning - European Conference on Information Technol.pdf
> [4] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [5] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [6] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [7] [Book] Bateson - Steps to an Ecology of Mind_ Collected Essays in Anthropology, Psychiatry, Evolution, and Epistemology.pdf
> [8] Bednar et al. - 2014 - Evaluation processes Lessons from Bateson ’ s second order learning - European Conference on Information Technol.pdf
> [9] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [10] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [11] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [12] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [13] [Book] Bateson - Steps to an Ecology of Mind_ Collected Essays in Anthropology, Psychiatry, Evolution, and Epistemology.pdf
> [14] Hui 2008 - Batesons method double description what is it how does it work what do we learn.pdf
> [15] [Book] Bateson Gregory - Mind and Nature.pdf
> [16] Hui 2008 - Batesons method double description what is it how does it work what do we learn.pdf
> [17] The Pattern which connects Gregory Bateson.pdf
> [18] [Book] Bateson - Steps to an Ecology of Mind_ Collected Essays in Anthropology, Psychiatry, Evolution, and Epistemology.pdf
> [19] [Book] Bateson Gregory - Mind and Nature.pdf
> [20] [Book] Bateson - Steps to an Ecology of Mind_ Collected Essays in Anthropology, Psychiatry, Evolution, and Epistemology.pdf
> [21] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [22] Bednar et al. - 2014 - Evaluation processes Lessons from Bateson ’ s second order learning - European Conference on Information Technol.pdf
> [23] Bednar et al. - 2014 - Evaluation processes Lessons from Bateson ’ s second order learning - European Conference on Information Technol.pdf
> [24] The Logical Categories of Learning and Communication.pdf
> [25] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [26] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [27] [Book] Bateson - Steps to an Ecology of Mind_ Collected Essays in Anthropology, Psychiatry, Evolution, and Epistemology.pdf
> [28] Ison - Fruits of BAtesons Epistemological Crisis.pdf
> [29] [Book] Hoffmeyer - A Legacy for Living Systems Batesons Method Double Description.pdf
> [30] [Book] Bateson Gregory - Mind and Nature.pdf
> [31] bothcybernet.pdf
> [32] Bateson 1991 - Cybernetic Explanation.pdf
> [33] The Logical Categories of Learning and Communication.pdf
> [34] [Book] Bateson Gregory - Mind and Nature.pdf


FILE: 'Harish Jose.md'
---
exported: 2026-02-09T20:54:43.332Z
source: NotebookLM
type: chat
title: An effective investigation is a systematic search ...
tags:
  - Harish-Jose
  - How-To
---
An effective investigation is a systematic search for truth and understanding that avoids jumping to conclusions\[1\]\[2\]. It requires a balance of **divergent thinking** to gather data (Yin) and **convergent thinking** to narrow down causes (Yang)\[3\]\[4\].

### **Step 1: Grasp the Current Condition (The "Gemba")**

The first step is to go to the **Gemba**—the actual place where the event occurred—to gather first-hand facts rather than relying on reports\[5\].

• **Observe without preconceived notions:** Stand in an "Ohno Circle" to observe the process for an extended period until the waste and abnormalities become visible\[8\]\[9\].

• **Look for the "Void":** Identify not just what is present, but what is missing, as missing information is often the most critical\[10\]\[11\].

• **Define the Gap:** Clearly state the difference between the **Ideal State** (how things should be) and the **Current State** (how they are now)\[12\].

### **Step 2: Identify Potential Causes**

Use structured frameworks to explore why the deviation occurred.

• **The 5 Whys (and "What Caused"):** Instead of just asking "Why?", which can lead to blaming individuals, ask "**What caused** the operator to miss this step?" to shift focus to system failures\[9\]\[15\].

• **ECRS Method:** Evaluate every task by asking if it can be **E**liminated, **C**ombined, **R**earranged, or **S**implified\[16\].

• **Hill's Criteria for Causality:** To establish if "A" truly caused "B," check for **Strength** of correlation, **Consistency** (is it reproducible?), and **Temporality** (did the cause happen before the effect?)\[19\].

### **Step 3: Combat Bias and Speculation**

Human minds naturally seek to confirm existing beliefs, creating blind spots\[1\]\[20\].

• **The "Tenth Man" Policy:** If everyone agrees on a cause, assign one person to take the opposite side and attempt to disprove the consensus\[21\].

• **Baloney Detection:** Spin multiple working hypotheses instead of latching onto the first idea that comes to mind\[22\]\[23\].

• **Can you turn the problem on and off?** A true root cause, in the presence of enabling conditions, should allow you to deliberately trigger or stop the effect\[24\].

\--------------------------------------------------------------------------------

### **Crucial Questions to Ask**

**To Understand the Situation:**

• What is the **ideal condition** for this process, and how exactly does the current state differ?\[12\]\[14\]

• Is this a **Simple, Complicated, or Complex** problem? (This determines if you need an expert, an experiment, or just an SOP)\[25\].

• Is the information being shared **Relevant, Credible, and worth the cost** of gathering?\[28\]

**To Investigate Failures (Red Flags):**

• Was the unit **returned more than once** for the same issue?\[29\]

• Were there **nonstandard reworks** performed on this unit during production?\[29\]

• Is this part of the **first lot produced** after a major design change?\[29\]

**To Challenge the Reasoning (Socratic Method):**

• If you define the cause as "X," can you find examples where "X" occurred but the **problem did not**?\[30\]\[31\]

• **The Triple Filter:** Is the information you are reporting **True**, is it **Good** (helpful), and is it **Useful**?\[32\]\[33\]

• What is the **purpose** of this specific task or step, and what would happen if we eliminated it entirely?\[34\]\[35\]

**To Ensure Valid Evidence:**

• Can this hypothesis be **falsified** (proven wrong) by a specific test?\[23\]

• Is there **independent confirmation** of the facts from multiple sources?\[23\]

• Is the "fact" actually a fact, or is it an **opinion** coated in information?\[36\]\[37\]

Would you like to apply this guide to a specific incident, such as a equipment failure or a recurring quality defect?

---
> [!info]- References
> [1] Harish Jose.md
> [2] Harish Jose.md
> [3] Harish Jose.md
> [4] Harish Jose.md
> [5] Harish Jose.md
> [8] Harish Jose.md
> [9] Harish Jose.md
> [10] Harish Jose.md
> [11] Harish Jose.md
> [12] Harish Jose.md
> [14] Harish Jose.md
> [15] Harish Jose.md
> [16] Harish Jose.md
> [19] Harish Jose.md
> [20] Harish Jose.md
> [21] Harish Jose.md
> [22] Harish Jose.md
> [23] Harish Jose.md
> [24] Harish Jose.md
> [25] Harish Jose.md
> [28] Harish Jose.md
> [29] Harish Jose.md
> [30] Harish Jose.md
> [31] Harish Jose.md
> [32] Harish Jose.md
> [33] Harish Jose.md
> [34] Harish Jose.md
> [35] Harish Jose.md
> [36] Harish Jose.md
> [37] Harish Jose.md


FILE: 'Harold Nelson.md'
---
exported: '2026-02-02T06:03:49.788Z'
source: NotebookLM
type: chat
title: Harold Nelson on 💬How To Guides
tags:
  - Harold-Nelson
  - How-To
  - NoMethodology
author: Harold Nelson
---
Based on the provided sources, a "chaordic" investigation—one that navigates the space between chaos and order to address complex, wicked, or indeterminate problems—is best approached through the frameworks of **Systemic Design** and **Social Systems Assessment**. While the term "chaordic" is specifically referenced in the bibliography regarding Dee Hock’s "Chaordic Organization"\[1\], the sources provide a detailed methodology for investigating these types of complex, unpredictable systems where traditional linear problem-solving fails\[2\],\[3\].

Here is a how-to guide for conducting a systemic (chaordic) investigation, drawing primarily from the works of Harold Nelson, Erik Stolterman, C. West Churchman, and Sigrun Lurås found in your sources.

### Phase 1: Preparation (The Stance)

Before asking questions, you must establish the correct mindset. In chaordic situations, you cannot rely on pre-existing answers or standard operating procedures.

• **Adopt "Conscious Not-Knowing":** Begin by "unlearning" old answers. You must adopt a "beginner’s mind" open to new possibilities, a state described as "conscious not-knowing"\[4\],\[5\].

• **Practice "Letting Go":** You must commit to the specific conditions of the particular situation and open your mind to new interpretations. This is not a lack of knowledge, but a "heightened readiness for change"\[5\].

• **Employ** **Notitia** **(Attentive Noticing):** Do not just observe; engage in _notitia_. This is an act of attention that is complete and uncompromising, sensing every nuance and pattern of connection that passive observation misses\[6\].

• **Establish Agency:** Determine who has the right to act. You must seek agency—the right to act on behalf of others (stakeholders, clients, end-users)\[7\].

### Phase 2: Mapping the Territory (The Framework)

A chaordic investigation requires you to define the boundaries of the system you are investigating. You should map the situation as a "system of systems" to make sense of the complexity.

• **Define the Three Systems:**

    1. **The System You Design:** The specific artifact, organization, or intervention you are creating\[8\].    2. **The System You Design** **For****:** The situation you seek to change (e.g., a macro environment, user context)\[9\].    3. **The System You Design** **Within****:** The framework conditions shaping your ability to perform (regulations, culture, resources)\[10\].
### Phase 3: The Investigation (The Questions to Ask)

The core of the investigation involves asking specific **teleological questions**. These allow you to distinguish between "what is" (Analysis) and "what ought to be" (Critique)\[11\].

A. The "Real" and "True" (Systems Analysis)

_Ask these questions to understand the current reality_\[12\]_,_\[13\]_,_\[14\]_:_

1\. **The Situation:** What is the current situation? Why is it this way?

2\. **The Client:** Who is the client currently? Whose interests are currently being served?

3\. **The Purpose:** What is the current purpose of the system?

4\. **The Measure:** What is the current measure of performance? How do we currently know if the system is working?

5\. **The Decision Maker:** Who currently has the power to change the measure of performance?

6\. **The Components:** What are the system's components (who/what produces the performance)?

7\. **The Environment:** What are the environmental constraints (factors that matter but are outside the decision maker's control)?

8\. **The Planner:** Who is currently planning or designing the system?

B. The "Ideal" (Systems Critique)

_Ask these questions to determine the ethical and desired future state_\[13\]_,_\[14\]_:_

1\. **The Ought:** What _ought_ the situation to be?

2\. **The Client:** Who _ought_ to be the client? (Who should benefit?)

3\. **The Purpose:** What _ought_ the purpose to be?

4\. **The Measure:** What _ought_ to be the measure of performance? (How should we measure success?)

5\. **The Decision Maker:** Who _ought_ to be the decision maker?

6\. **The Components:** What components _ought_ to be included?

7\. **The Environment:** What _ought_ the environment to be?

8\. **The Planner:** Who _ought_ to be the planner?

C. The "Intervention" (Bridging the Gap)

_Ask these questions to navigate the "wicked problem" or "mess" found between the current reality and the ideal_\[15\]_,_\[16\]_:_

1\. **The Problematic:** What is the difference between "what is" and "what ought to be"? (This gap defines the problematic situation)\[17\].

2\. **The Leverage:** Where can we intervene? Is it better to _fix/restore_ (repair elements), _reform_ (redesign means), or _transform_ (redefine ends)?\[18\].

3\. **The Desiderata:** What is truly desired? (Not just needed, but desired by the stakeholders)\[19\].

### Phase 4: Navigating the Investigation (Methods)

Because chaordic investigations deal with vast amounts of fragmented data, you cannot rely on linear logic alone.

• **Use Visual Mapping (GIGA-mapping):** Create visual maps to cope with fragmented data and understand causes and effects. This helps you grasp and mirror the complexity of real-life problems\[20\],\[21\].

• **Conduct ZIP-Analysis:** When analyzing your maps or observations, identify:

    ◦ **Z-points (Zoom):** Areas requiring more research.    ◦ **I-points (Innovation):** Ideas or solutions.    ◦ **P-points (Potential):** Problem areas with potential for improvement\[22\].
• **Seek the "Parti":** Look for the emergence of a _parti_—a generative seed or breakthrough insight that unifies the complex inputs into a coherent whole. This often occurs subconsciously after "saturating" yourself in the data\[23\],\[24\].

### Phase 5: Assessing Validity

Unlike scientific research, which seeks "truth," a design-led chaordic investigation seeks "adequacy" and "meaning."

• **Judge for Adequacy:** Do not strive for a perfect solution, but for an _adequate_ one. A design is adequate when the composition of elements produces a whole that serves the purpose effectively\[25\],\[26\].

• **Evaluate Desiderata:** Have you uncovered the "desiderata"—the all-encompassing wants, needs, and desires of the stakeholders? Ideas about change should emerge from a deep understanding of this desiderata\[27\].

• **Measure Value:** Use the "Measurements of Life" framework to assess the worth of the outcome\[28\],\[29\]:

    ◦ _Standards of Life_ (Quantitative/Scientific)    ◦ _Qualities of Life_ (Qualitative/Descriptive)    ◦ _Ways of Life_ (Nominal/Names)    ◦ _Spirit of Life_ (Ineffable/Spiritual judgements of worth)

---
> [!info]- References
> [1] Nelson - Design of Design Education.pdf
> [2] Nelson - The Design Way Chapt 1.pdf
> [3] Nelson The Impact of Complexity and Scale on Organizational Systems.pdf
> [4] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [5] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [6] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [7] Nelson The Impact of Complexity and Scale on Organizational Systems.pdf
> [8] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [9] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [10] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [11] Nelson 2003 - The Legacy of C West Churchman.pdf
> [12] Nelson 2003 - The Legacy of C West Churchman.pdf
> [13] Nelson 2003 - The Legacy of C West Churchman.pdf
> [14] Nelson 2003 - The Legacy of C West Churchman.pdf
> [15] Nelson 2003 - The Legacy of C West Churchman.pdf
> [16] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [17] Nelson 2003 - The Legacy of C West Churchman.pdf
> [18] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [19] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [20] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [21] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [22] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [23] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [24] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [25] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [26] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [27] The Challenge of Improving Design.pdf
> [28] Collaborating for Comprehensivity by CJ Fearnley.pdf
> [29] Collaborating for Comprehensivity by CJ Fearnley.pdf


FILE: 'Herb Simon.md'
---
exported: 2026-02-07T15:54:06.284Z
source: NotebookLM
type: chat
title: Herb Simon on 💬How To Guides
tags:
  - Herb-Simon
  - How-To
author: Herb Simon
---
Based on the comprehensive collection of Herbert A. Simon’s work provided, an investigation into complex, dynamic, or "ill-structured" systems requires a shift from seeking optimal, all-encompassing solutions to seeking "satisficing" solutions through structural decomposition and heuristic search.

Here is a guide to conducting an investigation based on Simon's principles of bounded rationality, near-decomposability, and causal ordering.

### **Phase 1: Structuring the Ill-Structured Problem**

_Goal: To convert a vague "mess" into a solvable problem space by retrieving constraints from memory and the environment._

Real-world problems are usually "ill-structured" (ISPs). They do not come with clear start states, goal states, or legal moves\[1\]\[2\]. The investigator’s first task is not to solve the problem, but to structure it.

**Questions to Ask:**

• **What is the representation?** Are we solving the problem using verbal sentences or diagrams? Can we convert the data into a diagram to make geometric relations explicit and reduce the computational cost of search?\[3\].

• **What are the "generators" and "tests"?** In designing a solution, which criteria will we use to _generate_ possibilities and which will we use to _test_ them? (e.g., A bank officer might use "growth industries" to generate investment options, and "safety" to test them)\[6\].

• **Where are the boundaries?** Since we cannot handle the "interrelatedness of all things," what specific set of variables can we isolate to create a closed system for analysis?\[9\]\[10\].

• **Are we maximizing or satisficing?** Have we set a specific "aspiration level" (a standard of "good enough") so we know when to stop searching, rather than searching indefinitely for the theoretical optimum?\[11\].

### **Phase 2: Decomposition and Hierarchy**

_Goal: To simplify the investigation by breaking the system into semi-independent subsystems._

Complex systems in nature and society are almost always hierarchic ("boxes-within-boxes")\[14\]\[15\]. They are "nearly decomposable," meaning things interact strongly with their neighbors but weakly with distant parts\[16\]\[17\].

**Questions to Ask:**

• **Where are the "cleavage points"?** Can we identify subsystems where interactions _within_ the cluster are high-frequency and intense, but interactions _between_ clusters are low-frequency and weak?\[14\]\[18\].

• **Can we separate time scales?** Can we analyze the short-run dynamics of the subsystems independently, treating other parts of the system as constant?\[17\]\[19\].

• **Can we aggregate?** For long-run analysis, can we ignore the internal details of the subsystems and treat them as simple aggregate variables (e.g., treating a department as a single unit rather than analyzing every employee)?\[20\].

• **Is there a "stable intermediate form"?** Is the system evolving or being built from stable sub-assemblies (like a watch made of sub-components), or is it trying to assemble everything at once?\[23\]\[24\].

### **Phase 3: Causal Ordering and Mechanism Identification**

_Goal: To determine which variables influence others and to identify the functional mechanisms._

Causation is defined by the asymmetry of influence in a self-contained structure. It is not necessarily about time sequence, but about which variables can be altered by intervention\[25\]\[26\].

**Questions to Ask:**

• **Who are the "experimenters"?** If we could intervene in the system, which variables could we change directly (exogenous variables)?\[27\]\[28\].

• **What is the direction of influence?** If a relationship (equation) is altered, which variables change value and which remain invariant? (The variables that remain invariant are the causes)\[29\]\[30\].

• **Is the correlation spurious?** If X and Y are correlated, is there a third variable Z (e.g., weather) influencing both? We must check for "spurious correlation" by introducing the third variable and checking the partial correlations\[31\]\[32\].

• **Are the mechanisms identifiable?** Do we have enough a priori knowledge (e.g., knowing that Variable A _cannot_ influence Variable B) to solve the equations uniquely?\[33\]\[34\].

### **Phase 4: Heuristic Search and Discovery**

_Goal: To navigate the problem space efficiently without unlimited computational power._

Because we possess "bounded rationality," we cannot search every possibility. We must use heuristics (rules of thumb) to guide the search\[35\]\[36\].

**Questions to Ask:**

• **What are the differences?** Using **Means-Ends Analysis**: What is the difference between the current state and the desired state? What operator (action) is relevant to reducing that specific difference?\[37\].

• **Can we use a "planning space"?** Can we abstract the problem (ignoring details) to find a general path, and then use that path to guide the detailed solution?\[40\].

• **What is the "alphabet"?** Is the complex system built from a limited number of basic elements (like the 92 elements in chemistry or a standard set of organizational roles)? Identifying the alphabet simplifies the description\[43\]\[44\].

• **Are we surprised?** Did something occur contrary to our knowledge? Surprise is a key heuristic for spotting new opportunities or problems (e.g., Fleming discovering penicillin)\[38\]\[45\].

### **Phase 5: Evaluation and Design**

_Goal: To select a course of action based on multidimensional constraints._

Decisions are rarely made to maximize a single utility function (like profit). They are made to satisfy a complex set of constraints\[46\]\[47\].

**Questions to Ask:**

• **What is the constraint set?** Instead of asking "What is the goal?", ask "What is the full set of constraints (budget, safety, time, legality) that a solution must satisfy?"\[46\]\[48\].

• **Who is the client?** Are we designing for the "inner environment" (the organization) or the "outer environment" (the market/reality)? A good design adapts the inner system to the outer environment\[49\]\[50\].

• **Is the solution robust?** Since we cannot predict the future perfectly, does the solution rely on feedback mechanisms to correct errors as they arise?\[51\]\[52\].

### **Summary Checklist for the Investigator**

1\. **Define:** Convert the amorphous "mess" into a problem space with defined states and operators\[53\].

2\. **Factor:** Use near-decomposability to break the system into manageable, hierarchical subsystems\[20\].

3\. **Satisfice:** Stop searching when a solution meets the aspiration level; do not waste resources seeking perfection\[11\].

4\. **Diagram:** Use visual representations to make relationships explicit and reduce search time\[3\]\[54\].

5\. **Intervene:** Test causal theories by asking what would happen if specific mechanisms were altered\[27\].

---
> [!info]- References
> [1] Simon - The Structure of Ill Structured Problems.pdf
> [2] Simon - The Structure of Ill Structured Problems.pdf
> [3] Larkin Simon 87 - Why a diagram is sometimes worth ten thousand words.pdf
> [6] Simon 1964 - On the concept of organizational goal.pdf
> [9] Simon 1961 aggregation of variables in dynamic systems.pdf
> [10] [Book] Simon - Administrative Behavior.pdf
> [11] [Book] Simon - Administrative Behavior.pdf
> [14] Simon - Can there be a science of complex systems.pdf
> [15] Simon - the organization of complex systems.pdf
> [16] Simon - the organization of complex systems.pdf
> [17] Simon 1961 aggregation of variables in dynamic systems.pdf
> [18] Simon - the organization of complex systems.pdf
> [19] Simon - the organization of complex systems.pdf
> [20] Simon - Can there be a science of complex systems.pdf
> [23] Simon - Can there be a science of complex systems.pdf
> [24] Simon - the organization of complex systems.pdf
> [25] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [26] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [27] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [28] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [29] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [30] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [31] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [32] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [33] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [34] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [35] Simon 1961 aggregation of variables in dynamic systems.pdf
> [36] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [37] Simon - The Structure of Ill Structured Problems.pdf
> [38] [Book] Simon - Administrative Behavior.pdf
> [40] Simon - The Structure of Ill Structured Problems.pdf
> [43] Simon - the organization of complex systems.pdf
> [44] Simon 1976 - How complex are complex systems.pdf
> [45] [Book] Simon - Administrative Behavior.pdf
> [46] Simon 1964 - On the concept of organizational goal.pdf
> [47] [Book] Simon - Administrative Behavior.pdf
> [48] [Book] Simon - Administrative Behavior.pdf
> [49] [Book] Simon - The Sciences of the Artificial, 3rd Edition.pdf
> [50] [Book] Simon - The Sciences of the Artificial, 3rd Edition.pdf
> [51] Simon - Can there be a science of complex systems.pdf
> [52] [Book] Simon - The Sciences of the Artificial, 3rd Edition.pdf
> [53] Simon - The Structure of Ill Structured Problems.pdf
> [54] Larkin Simon 87 - Why a diagram is sometimes worth ten thousand words.pdf


FILE: 'Horst Rittel.md'
---
exported: '2026-02-01T16:20:13.508Z'
source: NotebookLM
type: chat
title: Horst Rittel on 💬How To Guides
tags:
  - Horst-Rittel
  - How-To
  - Methodology
author: Horst Rittel
---
Based on the provided sources, particularly the works of Klaus Krippendorff and Horst Rittel, an investigation is not a linear process of discovering objective facts, but a recursive, constructed process of making sense of information relative to a specific context.

Here is a guide to conducting an investigation, structured by the logical phases of inquiry found in the texts.

### **Phase 1: Conceptualization and Framing**

Before collecting data, you must define the problem space. Rittel warns that in complex ("wicked") problems, you cannot fully understand the problem until you have started trying to solve it\[1\]. Therefore, your framing must remain flexible.

**Key Tasks:**

• **Construct the Context:** You must explicitly define the context in which you are working. Data are made available to you, but their context is not; you must construct it to include surrounding conditions, antecedents, and consequences\[2\].

• **Acknowledge the Observer:** Recognize that you are not a neutral bystander. You must enter your domain of observation and acknowledge your own role in bringing properties into the open\[3\],\[4\].

• **Formulate Research Questions:** Unlike scientific hypotheses which are tested for generalizability, your questions should pertain to specific phenomena within your chosen context\[5\].

**Questions to Ask in Phase 1:**

• _Why am I approaching this object/text? What are my preconceptions and cultural definitions of it?_\[6\],\[7\].

• _What is the target of my inference? (What is currently unobserved that I want to know about?)_\[8\],\[9\].

• _Am I dealing with a symptom or the real disease? (Is the stated problem actually a symptom of a higher-level problem?)_\[10\],\[11\].

• _How do the stakeholders conceive of this situation? (Am I granting them the same cognitive capabilities I claim for myself?)_\[12\],\[13\].

### **Phase 2: Data Making (Unitizing and Sampling)**

Data are not "found"; they are "made" through the application of explicit techniques\[14\]. You must decide what constitutes a meaningful unit of analysis and which units to select.

**Key Tasks:**

• **Unitizing:** Partition the continuous stream of reality into analyzable segments (units). These can be physical (time/length), syntactical (words/sentences), or thematic (concepts)\[15\],\[16\].

• **Sampling:** Because you cannot analyze everything, you must sample.

    ◦ _Relevance Sampling:_ Select texts/data that contribute to answering your specific question, rather than just choosing randomly\[17\],\[18\].    ◦ _Cluster Sampling:_ If individual units are too numerous, sample larger groups (clusters) like specific documents or time periods\[19\].
**Questions to Ask in Phase 2:**

• _What are the boundaries of the units I am analyzing? (Are they independent of each other?)_\[20\],\[21\].

• _Does my sample fairly represent the phenomena I am investigating, or is it biased by the source's own selectivity?_\[22\],\[23\].

• _Will the prerequisites (ingredients, conditions, data availability) for this analysis be available?_\[24\].

### **Phase 3: Analysis and Inference**

This is the core of the investigation. In Content Analysis, this involves **abductive inference**—moving from the text (data) to the answer via an analytical construct (logic)\[25\]. In Design/Planning, this involves an **argumentative process** of raising issues and weighing positions\[26\].

**Key Tasks:**

• **Recording/Coding:** Transcribe or categorize your observations into a durable language\[27\],\[28\]. Ensure your coding instructions are clear enough to be replicable\[29\].

• **Inferring:** Use "analytical constructs" to bridge the gap between your data and your target. This might involve extrapolating trends, applying standards, or analyzing indices (e.g., frequency of a word indicates attention)\[30\],\[31\],\[32\].

• **Deliberation:** If investigating a course of action, use Rittel's web of reasoning to navigate uncertainty\[33\].

**Questions to Ask in Phase 3:**

• _What does this text/data mean to its user/author, and what does it mean in the context I have constructed?_\[34\],\[35\].

• _Is there a stable relationship (correlation) between the text I have and the phenomenon I am inferring?_\[22\].

• _If proposing a solution/hypothesis (Measure 'A'):_

    ◦ _Are you confident 'A' will work?_\[24\].    ◦ _Will there be undesirable side and after-effects?_\[36\].    ◦ _Do the advantages outweigh the disadvantages?_\[36\].    ◦ _Is there a better way to accomplish the same end?_\[36\].
### **Phase 4: Validation**

You must demonstrate that your findings are trustworthy.

**Key Tasks:**

• **Check Reliability:** Can your process be reproduced by another researcher? (Replicability is the most important form of reliability)\[37\].

• **Check Validity:**

    ◦ _Semantic Validity:_ Do your categories accurately describe meanings in the chosen context?\[38\].    ◦ _Structural Validity:_ Does your logic (analytical construct) accurately model the relations known to exist in the context?\[39\].    ◦ _Pragmatic/Functional Validity:_ Does the solution work in practice?\[39\],\[40\].
**Questions to Ask in Phase 4:**

• _Would another investigator, using my instructions, arrive at the same data?_\[41\],\[42\].

• _Have I exposed my results to the stakeholders for their feedback? (Does the narrative represent their reality?)_\[43\].

• _Does the result withstand independently available evidence?_\[37\].

### **Phase 5: Narration and Reporting**

Finally, you must make your results comprehensible to others.

**Key Tasks:**

• **Narrate:** Create a compelling story that explains the research, acknowledging it as _one_ possible story among many\[44\],\[45\].

• **Justify:** Explicitly describe your context, units, sampling, and logic so the study can be critically examined\[46\].

**Questions to Ask in Phase 5:**

• _Have I made my context and analytical steps explicit?_\[47\].

• _Does my report distinguish between what was observed (data) and what was inferred (context)?_\[9\].

• _Who is the audience for this report, and does the narrative address their stake in the investigation?_\[48\].

---
> [!info]- References
> [1] Rittel-Planning-Crisis-First-Second-Generation-1972.pdf
> [2] [Book] Krippendorff - Content Analysis an introduction to its methodology.pdf
> [3] Krippendorff - A second-order Cybernetics of Otherness.pdf
> [4] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [5] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [6] On Systems Thinking - Krippendorff.pdf
> [7] On Systems Thinking - Krippendorff.pdf
> [8] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [9] [Book] Krippendorff - Content Analysis an introduction to its methodology.pdf
> [10] Rittel - The Reasoning of Designers.pdf
> [11] Rittel-Planning-Crisis-First-Second-Generation-1972.pdf
> [12] Krippendorff - The Dialogic Reality of Meaning.pdf
> [13] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [14] [Book] Krippendorff - Content Analysis an introduction to its methodology.pdf
> [15] [Book] Krippendorff - Content Analysis an introduction to its methodology.pdf
> [16] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [17] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [18] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [19] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [20] [Book] Krippendorff - Content Analysis an introduction to its methodology.pdf
> [21] [Book] Krippendorff - Content Analysis an introduction to its methodology.pdf
> [22] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [23] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [24] Rittel - The Reasoning of Designers.pdf
> [25] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [26] Rittel-Planning-Crisis-First-Second-Generation-1972.pdf
> [27] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [28] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [29] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [30] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [31] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [32] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [33] Rittel - The Reasoning of Designers.pdf
> [34] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [35] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [36] Rittel - The Reasoning of Designers.pdf
> [37] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [38] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [39] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [40] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [41] [Book] Krippendorff - Content Analysis an introduction to its methodology.pdf
> [42] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [43] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [44] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [45] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [46] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [47] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [48] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf


FILE: 'Humberto Maturana.md'
---
exported: '2026-02-02T04:35:16.152Z'
source: NotebookLM
type: chat
title: Humberto Maturana on 💬How To Guides
tags:
  - How-To
  - Humberto-Matruana
  - NoMethodology
author: Humberto Maturana
---
Based on the provided sources, the specific term "chaordic" (a blend of chaos and order coined by Dee Hock) does not explicitly appear. However, the sources offer a comprehensive framework for investigating complex, emergent, and non-linear human systems by bridging **Soft Systems Methodology (SSM)** with Humberto Maturana’s **Ontology of the Observer (OoO)**\[1\].

This approach allows for a "chaordic" investigation by balancing the "chaos" of subjective, multiple realities (Multiversa) with the "order" of biological and structural determinism.

Here is a guide to conducting such an investigation, structuring the inquiry around the "enhanced SSM" framework proposed in the sources.

\--------------------------------------------------------------------------------

### **Guide to a Systemic-Ontological Investigation**

**Phase 1: The Stance of the Investigator**

Before asking questions of the system, the investigator must establish their own epistemological stance. You must move from **Objectivity-without-Parenthesis** (assuming a single external reality) to **Objectivity-in-Parenthesis** (accepting that reality is brought forth by the observer)\[4\]\[5\].

• **Principle:** You are not discovering a pre-existing problem "out there." You are engaging with a "situation considered problematic" by observers within a specific domain of reality\[6\]\[7\].

• **Goal:** To recognize that you live in a **Multiversa** (many equally legitimate realities) rather than a Universe\[8\]\[9\].

**Phase 2: The Investigation Process (The Enhanced SSM Cycle)**

**Step 1: Expressing the Problematic Situation**Do not attempt to model the "real world." Instead, map the flow of events and ideas as perceived by the stakeholders\[10\].

• **Action:** Identify the "conversations" (flows of coordinations of actions and emotions) that constitute the network of the organization\[11\]\[12\].

• **Key Insight:** A social system only exists if the recurrent interactions are based on **mutual acceptance (love)**. If the emotion is coercion or merely instrumental, it is a non-social system\[13\]\[14\].

**Step 2: Defining the System (Root Definitions)**Use Maturana’s distinction between **Organization** and **Structure** to define the system\[15\]\[16\].

• **Define Organization:** What are the relations that give this system its identity? (e.g., What makes this a "hospital" and not a "factory"?) This must remain invariant for the system to survive\[15\]\[16\].

• **Define Structure:** What are the actual components and relationships realizing that identity right now? (e.g., The specific staff, protocols, and buildings)\[16\].

**Step 3: Modeling and Comparison (The "Cylinder" of Worldviews)**When comparing your conceptual models to the "real world," you must account for the divergent worldviews (**Weltanschauungen**) of all stakeholders.

• **The Device:** Visualize a "Cylinder of infinite Weltanschauungen." Each stakeholder represents a "slice" of this cylinder\[17\]\[18\].

• **The Task:** Map proposed changes on a quadrant of "Systemically Desirable" vs. "Culturally Feasible"\[18\].

• **Crucial Rule:** You cannot "instruct" the system to change. You can only "perturb" or "trigger" it. The system is **structure-determined**; it will only change according to its own internal dynamics\[19\]\[20\].

**Step 4: Taking Action (Orthogonal Interaction)**To solve the problem, you must trigger a structural drift.

• **Method:** Engage in **"Orthogonal" (Non-confirmatory) interactions**. Do not confirm the existing relational dynamics (e.g., hierarchy or coercion). Instead, introduce interactions based on mutual acceptance to trigger a shift from a non-social to a social system\[21\].

\--------------------------------------------------------------------------------

### **The Questionnaire: Questions to Ask During the Investigation**

These questions are derived from the intersection of Critical Systemic Thinking and Maturana’s biological philosophy.

**I. Questions regarding the Observer and Reality**

• **The Domain Question:** "In which domain of reality is this statement valid?" (Instead of asking "Is this true?", recognize that every statement is valid in some domain)\[22\].

• **The Distinction Question:** "What specific criterion of distinction are you using to separate this entity from the background?" (Remembering that existence is constituted by the act of distinction)\[7\]\[23\].

• **The Trap of Certainty:** "Am I claiming a privileged access to reality to compel others to obey my argument?" (If so, you are operating in Objectivity-without-Parenthesis)\[8\]\[24\].

**II. Questions regarding Structure and Organization**

• **The Identity Question:** "What relations must be preserved for this system to maintain its identity (Organization)?" vs. "What components can we change (Structure) without destroying the system?"\[15\]\[16\].

• **The Input Fallacy:** "Are we trying to 'input' information into the system, or are we providing perturbations to trigger internal change?" (Recognizing that systems are operationally closed and cannot receive 'instruction')\[20\]\[25\].

• **The Plasticity Question:** "Does the system possess the structural plasticity required to undergo the necessary changes without disintegrating?"\[26\]\[27\].

**III. Questions regarding Social Dynamics and Ethics**

• **The Emotioning Question:** "What is the emotional flow underlying these interactions? Is it mutual acceptance (love), or is it coercion/instrumentalization?"\[28\]\[29\].

• **The Hypocrisy Check:** "Are the stakeholders acting 'as if' they are in mutual acceptance while actually operating under hidden emotions of rejection?" (This identifies unstable, non-social systems)\[13\]\[30\].

• **The Ethical Criterion:** "Does this proposed transformation promote, restore, or cultivate dynamics of interactions based on mutual acceptance?"\[31\].

• **The Victim Witness:** "Who is affected by this system but not involved in the design? What are their worldviews?" (Drawing on Churchman’s concept of the 'witness' or 'enemy' of the system)\[32\]\[33\].

**IV. Questions regarding Change and Action**

• **The Trigger Question:** "Since we cannot determine the change from the outside, what specific interactions (perturbations) will trigger the system to change its own structure in the desired direction?"\[19\]\[34\].

• **The Accommodation Query:** "Are stakeholders merely 'accommodating' the change (which preserves the non-social status quo), or are they undergoing a genuine 'co-ontogenic structural drift' toward a shared consensual domain?"\[35\]\[36\].

### **Summary of the "Chaordic" Approach**

To conduct this investigation effectively, you must abandon the idea of "managing" or "controlling" the system. Instead, view the investigation as a **conversation**—a flow of coordinations of actions and emotions\[37\]. Your goal is to enter the system, perturb it through "orthogonal" (novel/non-confirming) interactions, and allow the system's own structure to drift toward a new, more desirable configuration based on mutual acceptance\[17\]\[21\].

---
> [!info]- References
> [1] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [4] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [5] Maturana 1988 - The search for objectivity.pdf
> [6] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [7] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [8] Maturana 1988 - The search for objectivity.pdf
> [9] Maturana 1988 - The search for objectivity.pdf
> [10] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [11] Bond Maturana Technology and Art Is a Biology of Technology Possible.pdf
> [12] Maturana 1988 - The search for objectivity.pdf
> [13] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [14] Maturana 1988 - The search for objectivity.pdf
> [15] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [16] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [17] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [18] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [19] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [20] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [21] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [22] Maturana 1988 - The search for objectivity.pdf
> [23] Bond Maturana Technology and Art Is a Biology of Technology Possible.pdf
> [24] Maturana 1988 - The search for objectivity.pdf
> [25] Matura-CognitiveStrategies.pdf
> [26] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [27] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [28] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [29] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [30] Maturana 1988 - The search for objectivity.pdf
> [31] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [32] Retmolds - Churchman and Maturana enriching the notion of self organization for social design.pdf
> [33] Retmolds - Churchman and Maturana enriching the notion of self organization for social design.pdf
> [34] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [35] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [36] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [37] Bond Maturana Technology and Art Is a Biology of Technology Possible.pdf


FILE: 'Hylton Boothroyd.md'
---
exported: '2026-02-02T06:02:53.533Z'
source: NotebookLM
type: chat
title: Hylton Boothroyd on 💬How To Guides
tags:
  - How-To
  - Hylton-Boothroyd
  - NoMethodology
author: Hylton Boothroyd
---
Based on the provided sources, particularly the work of Hylton Boothroyd on "Articulate Intervention" and the case studies on problem structuring and risk, there is no explicit mention of the specific term "chaordic." However, the sources describe a methodology perfectly suited for "chaordic" situations—environments characterized by complexity, ambiguity, human conflict, and the intersection of order and chaos.

The sources propose replacing the rigid "scientific method" with a process called **Articulate Intervention** or **Reflection Before Action**.

Here is a guide to conducting such an investigation, structured around the interaction between **Theories**, **Proposals**, **Actions**, and **Consequences**.

### Phase 1: Establish the Investigational Stance

In complex human systems, you cannot simply "apply science" mechanically. You must adopt a specific mindset:

• **Abandon Certainty:** Do not present yourself as a source of certainty. Move participants away from the expectation of "right" answers toward an expectation of "permanent conjecture, enquiry, review and innovation"\[1\].

• **Acknowledge Complexity:** Recognize that the situation involves "magic," "unexpectedness," and potentially the "harsh exercise of power"\[2\].

• **Identify Action Programmes:** View the organization not as a static machine, but as a collision of "action programmes"—bundles of theories, proposals, and actions held by different groups. Your investigation is an intervention that creates a new action programme\[3\]\[4\].

### Phase 2: The Core Framework (Questions to Ask)

Boothroyd provides a pictorial model for investigation involving four key elements: **Theories, Proposals, Actions,** and **Consequences**\[5\]. To investigate a "chaordic" system, you must articulate and question the links between these elements.

1\. Investigating **Proposals** (Values and Intent)

_Unlike science, which deals with "is," investigation deals with "ought"_\[6\].

• **The "Ought" Question:** What do you and others _wish_ to see happen under various possible circumstances?\[7\].

• **The Core Proposal:** What are the "core proposals" (deeply held values or rules) that defy precise statement but drive the organization?\[8\].

• **The Ethical Check:** Are we paying "concerned and imaginative attention to the other"?\[9\].

• **Latent Proposals:** What are the unwritten rules? (e.g., "If I hear loud disagreement, make less noise")\[10\].

2\. Investigating **Theories** (Beliefs about Reality)

_Theories are pictures of how things are or would behave_\[7\].

• **The Reality Check:** What is your picture of how things behave under future conditions?\[7\].

• **The Instrumentality Question:** We don't need absolute truth, but are these theories "instrumental"? Do they work well enough for us to take action right now?\[11\].

• **The Counter-Theory:** If we assume the current theory is false, what else would follow, and is that plausible?\[12\].

• **The Data Question:** "Why can’t you predict the losses and incidents flowing from today’s trading?" (If correlation is weak, it should cause questions about training, system difficulty, or carelessness)\[13\]\[14\].

3\. Investigating **Actions** (The Repertoire)

_Actions can be unnoticed, unitary, or composite depending on who is looking_\[15\].

• **The Repertoire Question:** What is the current list of things we believe we _can_ do?\[16\].

• **The Novelty Question:** Can we conceive of _novel_ actions? (Novelty cannot be deduced logically; it must be imagined)\[17\]\[18\].

• **The Depth Question:** Are we looking at actions as "composite" (a list of tasks) or "unitary" (a single event)? Does the CEO see a "sale" as a minor detail while the department manager sees it as a massive campaign?\[19\].

4\. Investigating **Consequences** (The Feedback Loop)

• **The "What-If" Question:** Instead of asking "which is best?" (optimization), ask "what happens if...?" (consequence display)\[8\].

• **The Desirability Question:** Are the anticipated consequences actually desirable from the perspective of the decision-maker?\[20\].

• **The "Black Box" Question:** If the organization is a black box, do the inputs from the environment match the overall outputs?\[21\].

### Phase 3: Methodologies for "Chaordic" Inquiry

The sources suggest combining methods to handle the "messiness" of real-world problems (Methodological Hybridization)\[22\].

**A. Soft Systems Methodology (SSM) & Problem Structuring**Use this when problems are ill-defined and stakeholders conflict.

• **Cognitive Mapping:** Map individual stakeholders' perspectives to surface their theories and proposals\[23\].

• **Root Definitions:** Ask stakeholders to define the system from their perspective (e.g., Is this carnival a "cultural festival," a "public order challenge," or a "commercial opportunity"?)\[24\].

• **Strategic Choice Approach:** Identify "decision areas" and how they interconnect. Manage uncertainty by identifying what you _don't_ know but need to know to decide\[25\].

**B. Ethnographic Observation (The "Go and See" Approach)**Don't just rely on what people say; observe what they do.

• **Immersion:** "Hang out" with the people doing the work. Gain their confidence. Ask, "Why did you decide to do A rather than B?" while they are working\[26\].

• **Listen for "Native" Language:** Learn the specific dialect and symbols used by the tribe (organization) to understand how they construct rationality\[27\].

• **Watch for "Unnoticed" Actions:** Observe the routine, mundane actions that actors perform without thinking, as these often contain implicit theories about the world\[15\].

**C. Abductive Reasoning (The Detective's Method)**When data is weird or unexpected (chaos), use abduction:

1\. **Gather Data:** "We’ve detected an unusual decrease in trade closure times"\[28\].

2\. **Hypothesize:** Maybe the clients changed behavior? Maybe the computer system is faster?

3\. **Deduce:** If clients changed, we should see different phone call lengths.

4\. **Test:** Go and check if phone call lengths actually changed\[28\].

### Phase 4: Validating the Investigation

How do you know if your investigation is good?

• **Don't expect permanent answers:** Recommendations are "necessarily impermanent." The world changes, and the "action programme" evolves\[29\].

• **Look for Surprise:** A good investigation often produces surprises by looking at existing records in new ways (e.g., discovering that observer performance drops after 10 minutes)\[30\].

• **Heuristic Power:** Does the investigation prompt a whole range of _new_ supporting theories and proposals? Does it generate new ideas?\[31\].

### Summary Checklist for the Investigator

• \[ \] Have I identified the conflicting "Action Programmes" at play?

• \[ \] Have I distinguished between "Theories" (facts/beliefs) and "Proposals" (values/wishes)?

• \[ \] Have I engaged in "Deliberative Argument" rather than just providing data?\[32\].

• \[ \] Am I observing actual behavior (Ethnography) or just analyzing stated policies?

• \[ \] Is my advice "Articulate"? (Have I made the implicit explicit?)\[33\].

---
> [!info]- References
> [1] 2010 Articulate Intervention Revisited.pdf
> [2] 2010 Articulate Intervention Revisited.pdf
> [3] 2010 Articulate Intervention Revisited.pdf
> [4] 2010 Articulate Intervention Revisited.pdf
> [5] 2010 Articulate Intervention Revisited.pdf
> [6] 2010 Articulate Intervention Revisited.pdf
> [7] 2010 Articulate Intervention Revisited.pdf
> [8] 2010 Articulate Intervention Revisited.pdf
> [9] 2010 Articulate Intervention Revisited.pdf
> [10] Boothroyd Scanned.pdf
> [11] 2010 Articulate Intervention Revisited.pdf
> [12] 2010 Articulate Intervention Revisited.pdf
> [13] Risk-case-study.md
> [14] Risk-case-study.md
> [15] 2010 Articulate Intervention Revisited.pdf
> [16] 2010 Articulate Intervention Revisited.pdf
> [17] 2010 Articulate Intervention Revisited.pdf
> [18] Boothroyd Scanned.pdf
> [19] 2010 Articulate Intervention Revisited.pdf
> [20] 2010 Articulate Intervention Revisited.pdf
> [21] Risk-case-study.md
> [22] Rosenhead 2006 - The uses of observation combining problem syructuring methods and ethnography.pdf
> [23] Rosenhead 2006 - The uses of observation combining problem syructuring methods and ethnography.pdf
> [24] Rosenhead 2006 - The uses of observation combining problem syructuring methods and ethnography.pdf
> [25] Rosenhead 2006 - The uses of observation combining problem syructuring methods and ethnography.pdf
> [26] Rosenhead 2006 - The uses of observation combining problem syructuring methods and ethnography.pdf
> [27] Rosenhead 2006 - The uses of observation combining problem syructuring methods and ethnography.pdf
> [28] Risk-case-study.md
> [29] 2010 Articulate Intervention Revisited.pdf
> [30] Boothroyd Scanned.pdf
> [31] 2010 Articulate Intervention Revisited.pdf
> [32] 2010 Articulate Intervention Revisited.pdf
> [33] 2010 Articulate Intervention Revisited.pdf


FILE: 'Ian Mitroff.md'
---
exported: '2026-02-01T16:02:33.377Z'
source: NotebookLM
type: chat
title: Ian Mitroff on 💬How To Guides
tags:
  - How-To
  - Ian-Mitroff
  - Methodology
aliases:
  - SAST
author: Ian Mitroff
---
Based on the works of Ian Mitroff, James Emshoff, and Ralph Kilmann in the provided sources, **Strategic Assumption Surfacing and Testing (SAST)** is a methodology designed to tackle "ill-structured" problems—complex messes where the underlying definition of the problem is in dispute.

The core premise of SAST is that the validity of any strategic plan depends less on the logic of the plan itself and more on the validity of the _assumptions_ underlying it\[1\]\[2\]. Since organizations often take these assumptions for granted, SAST provides a structured mechanism to bring them to the surface and challenge them.

Here is a how-to guide for conducting a SAST investigation, including the specific questions to ask at each stage.

### **Phase 1: Group Formation**

**Goal:** To maximize the diversity of viewpoints and ensure that opposing perspectives are heard.**Concept:** You cannot challenge assumptions effectively if everyone in the room thinks alike. You must create "constructive conflict"\[3\].

• **Action:** Form small groups (6-8 people) consisting of individuals from different functional areas or levels of the organization\[4\].

• **Strategy:** You can group people by:

    ◦ **Functional Area:** (e.g., Marketing vs. Finance).    ◦ **Personality Type:** (e.g., Thinking types vs. Feeling types) to generate different definitions of the problem\[5\].    ◦ **Policy Preference:** Assign groups to defend specific, opposing options (e.g., "Status Quo" vs. "Radical Change")\[6\].    ◦ **Random Assignment:** To force individuals to defend positions they may not personally hold, which often produces stronger arguments\[7\]\[8\].
### **Phase 2: Stakeholder Analysis (The Entry Point)**

**Goal:** To ground abstract assumptions in concrete reality.**Concept:** Most people find it difficult to list "assumptions" directly because they are abstract and hidden. However, assumptions are simply the "presumed properties of stakeholders"\[9\]\[10\]. Therefore, identifying stakeholders is the concrete path to finding assumptions.

• **Action:** Ask each group to identify the key parties who affect or are affected by the problem or the proposed strategy\[9\].

• **Questions to Ask:**

    ◦ Who has a stake in the outcome of this decision?\[11\]    ◦ Who are the "suppliers, customers, competitors, and government agencies" involved?\[12\]    ◦ Who are the "internal assassins" or saboteurs who could derail this plan?\[13\].    ◦ Who are the "victims" and who are the "beneficiaries"?\[14\].    ◦ Who are the "hidden movers"—the people behind the throne who pull the strings?\[15\].
### **Phase 3: Assumption Surfacing**

**Goal:** To articulate exactly what is being believed about the stakeholders that makes the strategy viable.**Concept:** This step involves working backward. Instead of arguing for a policy, the group must argue for the _conditions_ that make the policy true\[9\].

• **Action:** For each stakeholder listed in Phase 2, the group must list the assumptions they are making about that stakeholder's behavior, values, or motivations.

• **The Negation Test:** To check if an assumption is truly relevant, ask: "If the opposite of this assumption were true, would it have any significant bearing on the issue?" If the answer is "No," the assumption is irrelevant and should be dropped\[12\]\[16\].

• **Questions to Ask:**

    ◦ What is it that you have to assume about this stakeholder for your policy to be the correct one?\[17\].    ◦ Are you assuming a stakeholder is price-sensitive (economic) when they might actually be quality-sensitive (professional)?\[12\]\[18\].    ◦ Are you assuming the government will act as an ally or an enemy?\[19\].    ◦ Are you assuming the competition will remain static?\[20\].
### **Phase 4: Assumption Sorting (The Importance/Certainty Matrix)**

**Goal:** To identify which assumptions are the most dangerous risks to the organization.**Concept:** Not all assumptions are equal. You need to identify those that are vital to the plan but factually shaky\[21\].

• **Action:** Plot each assumption on a 2x2 graph with two axes: **Importance** (Least to Most) and **Certainty** (Uncertain to Certain)\[21\]\[22\].

    ◦ **Upper Right (High Importance/High Certainty):** The core planning region. These are the bedrock of the plan.    ◦ **Lower Right (High Importance/Low Certainty):** The **Danger Zone**. These are assumptions that _must_ be true for the plan to work, but the organization has no data to prove they are true.
• **Questions to Ask:**

    ◦ On which assumptions does the entire success of this policy hinge? (Importance)\[18\].    ◦ How confident are we in the truth of this assumption? Is it 100% certain, or is it a 50/50 guess? (Certainty)\[23\].    ◦ Do we have hard data to support this, or are we just hoping it is true?\[24\].
### **Phase 5: The Dialectical Debate**

**Goal:** To expose the "givens" of one group as the "takens" (unwarranted assumptions) of another\[25\].**Concept:** A structured debate occurs where groups present their assumptions, not just their conclusions. The goal is not to win, but to understand _why_ the other side believes what it believes\[26\]\[27\].

• **Action:** A spokesperson from each group presents their most critical assumptions (those in the High Importance/Low Certainty quadrant). Other groups listen and challenge.

• **Questions to Ask:**

    ◦ Under what worldview is this assumption "optimal"?\[28\].    ◦ What evidence do you have to support this specific assumption?\[29\].    ◦ Why is your policy totally dependent on this specific behavior of the stakeholder?\[27\].    ◦ What is the strongest case that can be made _against_ this assumption?\[30\].
### **Phase 6: Synthesis and Negotiation**

**Goal:** To achieve a compromise or a new, better problem formulation.**Concept:** Once the conflicting assumptions are exposed, the groups attempt to bridge the gap. They negotiate to see if a policy can be found that survives the challenges of the opposing assumptions\[26\]\[31\].

• **Action:** Groups identify the assumptions from the _opposing_ side that trouble them the most and attempt to modify them.

• **Questions to Ask:**

    ◦ Can you modify this assumption to make it acceptable to the other group while still supporting your policy?\[32\].    ◦ Is there a new conceptualization of the problem that encompasses both sets of assumptions?\[33\].    ◦ If we cannot agree, what specific data must we go out and collect to determine which assumption is valid?\[31\].    ◦ If we implement this policy, how will we monitor the validity of these uncertain assumptions over time?\[34\].
### **Summary of the "Error of the Third Kind" (E3)**

The ultimate purpose of this investigation is to avoid **E3**: _Solving the wrong problem precisely._ By forcing an organization to ask these questions, SAST ensures that the problem definition is broad enough to include the concerns of all key stakeholders, rather than narrowly solving a technical puzzle that misses the political or social reality\[35\]\[36\].

---
> [!info]- References
> [1] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [2] [Book] Mitroff - Creating a dialectical social science - concepts methods and models.pdf
> [3] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [4] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [5] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [6] [Book] Mitroff - Smart Thinking for Crazy Times.pdf
> [7] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [8] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [9] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [10] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [11] Mitroff - preparing for evil.pdf
> [12] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [13] Mitroff - preparing for evil.pdf
> [14] [Book] Linstone - Decision Making for Technology Executives.pdf
> [15] [Book] Linstone - Multiple Perspectives for Decision Making.pdf
> [16] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [17] [Book] Mitroff - Creating a dialectical social science - concepts methods and models.pdf
> [18] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [19] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [20] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [21] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [22] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [23] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [24] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [25] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [26] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [27] [Book] Mitroff - Creating a dialectical social science - concepts methods and models.pdf
> [28] [Book] Mitroff - Creating a dialectical social science - concepts methods and models.pdf
> [29] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [30] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [31] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [32] [Book] Mitroff - Creating a dialectical social science - concepts methods and models.pdf
> [33] [Book] Mitroff - Creating a dialectical social science - concepts methods and models.pdf
> [34] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [35] Mitroff 1974 - On systemic problem solving and the error of the third kind.pdf
> [36] [Book] Mitroff - Smart Thinking for Crazy Times.pdf


FILE: 'James Ladyman.md'
---
exported: '2026-02-01T16:21:44.747Z'
source: NotebookLM
type: chat
title: James Ladyman on 💬How To Guides
tags:
  - How-To
  - James-Ladyman
  - Methodology
aliases:
  - ITSR
author: James Ladyman
---
Based on the principles of **Information-Theoretic Structural Realism (ITSR)**, also known as **Rainforest Realism** (advocated by Ladyman, Ross, Collier, and Wiesner), and integrating the relational and complexity-based perspectives found in the sources (Vitale, Wolff), here is a guide for conducting an "ISM" investigation.

### **The ISM Investigation Guide: A Real-Patterns Approach**

**Objective:** To determine if a phenomenon qualifies as a "real pattern" (an entity that exists) and to map its structural relations, rather than searching for underlying "substances" or intrinsic essences.

**Core Principle:** To be is to be a real pattern. A pattern is real if it encodes information more efficiently than a description of its constituent parts and supports reliable predictions (projectibility) from a specific perspective\[1\].

\--------------------------------------------------------------------------------

### **Phase 1: Establishing the Perspective (Scale and Locators)**

In this framework, nothing exists in isolation; existence is relative to a scale of resolution. You do not start with "things"; you start with data and a perspective.

**The Strategy:**Identify the "grain of resolution" (scale) at which you are observing. You must define the "locators"—the specific coordinates or "tags" used to fix attention on a region of spacetime\[2\],\[3\].

**The Questions to Ask:**

• **What is the scale of resolution?** Are we observing at the level of fundamental physics, biology, economics, or sociology? (Note: Ontology is scale-relative; a "person" exists at the scale of sociology but may dissolve into cellular networks at the scale of biology)\[4\],\[5\].

• **What are the "locators"?** How are we tagging the data? Are we using spatial coordinates, names (like "Napoleon"), or market indices? Remember that "individuals" (like a specific table or electron) are just book-keeping devices used to track patterns\[5\],\[6\],\[7\].

• **Is the boundary objective or pragmatic?** Are the boundaries of the system defined by a physical discontinuity (like a cell membrane) or by the observer’s need to group interactions (like a "market")?\[8\],\[9\].

\--------------------------------------------------------------------------------

### **Phase 2: The Reality Test (Compressibility and Projectibility)**

You must determine if the candidate pattern is "real" or merely noise (a "bogus" pattern). Real patterns allow for information compression and prediction.

**The Strategy:**Apply the **Real Pattern Criteria**: (1) Is it projectible (can you make predictions)? (2) Is describing the pattern more efficient than describing the raw data (bit-map) of its parts?\[1\].

**The Questions to Ask:**

• **Is it compressible?** Can the data describing this phenomenon be algorithmically compressed? If the description is as long as the raw data itself (randomness), it is not a complex system or a real pattern\[10\],\[11\].

• **Is it projectible?** Does identifying this pattern allow us to predict future measurements better than a random guess? Does the pattern persist over time in a way that supports counterfactuals (e.g., "if X had happened, Y would have followed")?\[1\],\[12\].

• **Does it offer "Indexical Redundancy"?** Can we measure this pattern from multiple different perspectives? (e.g., A "natural kind" like an electron has high indexical redundancy because it can be measured everywhere; a specific historical event has low redundancy)\[13\].

• **Is it "thermodynamically deep"?** Does the system contain internal evidence of a non-trivial causal history? Is it harder to construct than to describe?\[14\],\[11\].

\--------------------------------------------------------------------------------

### **Phase 3: Structural Analysis (Relations and Complexity)**

Once established as a real pattern, you must analyze it structurally. In OSR (Ontic Structural Realism), relations are primary; "things" are secondary nodes in a relational network.

**The Strategy:**Map the modal structure (possibilities and necessities) and the information flow. Do not look for "intrinsic properties" (properties an object has entirely on its own); look for relational properties\[15\],\[16\].

**The Questions to Ask:**

• **What are the relations?** How do the components relate to one another? Are the individuals distinguishable only by their relations (like points in a graph or nodes in a network)?\[17\],\[18\].

• **Is there feedback?** Are there loops where outputs flow back as inputs? Feedback is a requirement for complex adaptive behavior\[19\],\[20\].

• **Is the system in equilibrium?** Is the system "open" (exchanging energy/information with the environment)? Complex systems must be out of thermodynamic equilibrium\[21\],\[22\].

• **Is there self-organization?** Does order arise spontaneously from disordered interactions without a central controller?\[19\],\[23\].

• **What is the "Statistical Complexity"?** How much information does the system store about its past that is relevant to predicting its future? (This is the preferred measure of structural complexity)\[24\],\[25\],\[26\].

\--------------------------------------------------------------------------------

### **Phase 4: Naturalistic Consistency Checks (PNC and PPC)**

The investigation must remain scientifically grounded. It cannot appeal to non-natural explanations.

**The Strategy:**Apply the **Principle of Naturalistic Closure (PNC)** and the **Primacy of Physics Constraint (PPC)**.

**The Questions to Ask:**

• **Does it violate the PPC?** Does the hypothesized pattern contradict the laws of fundamental physics? (Special sciences can describe patterns physics doesn't see, but they cannot violate physical laws)\[27\],\[28\].

• **Is it an "objective research project"?** Is the investigation motivated by finding objective facts, or is it driven purely by anthropocentric, commercial, or ideological preferences? (Metaphysics should only be motivated by the former)\[29\].

• **Are we looking for "biff" or "glue"?** Are we mistakenly looking for a metaphysical "glue" (like a distinct force of causation) to hold the world together? (ISM rejects causation as fundamental glue; the universe is held together by structural relations, not "biff")\[30\],\[31\].

### **Summary Checklist for an ISM Investigation**

1\. **Define the Scale:** At what level of resolution are we observing?

2\. **Identify Locators:** How are we tracking/indexing the phenomenon?

3\. **Test Compression:** Is the pattern a simplification of the underlying data?

4\. **Test Projectibility:** Does the pattern allow for reliable predictions?

5\. **Map Relations:** Are the "objects" defined by their relations and information flow?

6\. **Verify Physics:** Is the pattern compatible with fundamental physical laws?

---
> [!info]- References
> [1] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [2] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [3] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [4] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [5] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [6] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [7] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [8] Ladyman - What is a Complex System.pdf
> [9] [Book] Ladyman - What Is a Complex System.pdf
> [10] sp_phil_maths_2017-12-06.pdf
> [11] wiesner - measuring complexity.pdf
> [12] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [13] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [14] Ladyman - What is a Complex System.pdf
> [15] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [16] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [17] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [18] [Book] Ladyman - What Is a Complex System.pdf
> [19] [Book] Ladyman - What Is a Complex System.pdf
> [20] wiesner - measuring complexity.pdf
> [21] Ladymanetal.-2011-Whatisacomplexsystem.pdf
> [22] [Book] Ladyman - What Is a Complex System.pdf
> [23] [Book] Ladyman - What Is a Complex System.pdf
> [24] Ladyman - What is a Complex System.pdf
> [25] Ladyman 2012 - What is a complex system.pdf
> [26] what is a complex system.pdf
> [27] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [28] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [29] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [30] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [31] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf


FILE: 'James Wilk.md'
---
exported: '2026-02-01T17:05:24.786Z'
source: NotebookLM
type: chat
title: James Wilk on 💬How To Guides
aliases:
  - Minimal Intervention
tags:
  - How-To
  - James-Wilk
  - Methodology
author: James Wilk
---
Based on the provided sources, particularly the writings of James Wilk, Dave Franzetta, and Bill O'Hanlon, here is a guide to conducting a minimalist intervention.

### The Core Philosophy: "Benevolent Skepticism"

Before asking any questions, the interventionist must adopt a specific mindset. You must abandon the "museum theory" of reality (that problems are fixed entities with deep causes)\[1\]\[2\]. Instead, assume that the desired outcome is _already_ present and inherent in the situation, merely waiting to be released\[3\]\[4\]. Your stance should be one of "benevolent skepticism"—a refusal to believe that the client is broken or that the problem is unsolvable\[5\]\[6\].

### Phase 1: Define the Desired Outcome (The "Video Description")

The first step is not to analyze the problem, but to rigorously define the solution. You must strip away abstractions (like "low morale" or "depression") and get down to concrete facts.

**The Goal:** Obtain a "video description"—a description of the situation restricted to direct, uninterpreted observables that a camera with a soundtrack could record\[7\]\[8\].

**Key Questions to Ask:**

• **"What brings you here?"** (A neutral opener to get the client’s report)\[9\].

• **"If I followed you around with a video camera, how would I know you were experiencing this difficulty?"**\[10\].

• **"If a miracle happened tonight and your problem was solved, how would you know in the morning? What would you be doing differently?"**\[11\].

• **"What do you do that you don't want to do, or don't do that you want to do?"**\[12\].

• **"So what?"** (Used to challenge evaluations and force the client to explain why a specific feeling or thought is actually a problem in terms of behavior)\[13\].

### Phase 2: Filter the Complexity

Do not try to _model_ the complexity of the situation; instead, _filter_ it to find the specific constraints preventing the desired state\[14\]\[15\]. You are looking for the "idiosyncratic constraints"—local, specific factors stopping the change\[16\]\[17\].

**The Goal:** Identify the specific "doing" (actions) and "viewing" (interpretations/talk) that constitute the impasse\[18\].

**Key Questions to Ask:**

• **"What stops this from happening?"**\[19\].

• **"How is it that the current state-of-affairs is the only state-of-affairs not currently prevented?"**\[19\].

• **"How do you know?"** (Used to challenge attributions, mind-reading, and causal claims)\[20\]\[21\].

• **"Are you sure?"**\[22\].

• **"Is it always X? Would it ever be Y?"** (Looking for exceptions to the pattern)\[23\].

• **"When does it** **always** **occur and when does it** **never** **occur?"**\[24\].

### Phase 3: Design the Intervention

Once you have filtered the complexity down to the specific constraints, you co-design an intervention with the client\[25\]. The goal is to find the smallest possible action (a "nudge" or "catalyst") that flips the system from the current state to the desired state\[4\]\[26\].

**Strategies for Intervention:**

1\. **Naive Psychology / The Bottom Line:** Propose the obvious solution to see why the client rejects it. This reveals their "imperatives" (rules they believe they must follow)\[27\]\[28\].

    ◦ _Question:_**"Why not just do \[the desired action\]?"**\[29\].    ◦ _Question:_**"What prevents you?"** or **"What would happen if you did?"**\[30\].
2\. **Pattern Intervention:** Identify the invariant sequence of the problem and change one small element (frequency, duration, location, sequence)\[31\].

    ◦ _Action:_ If a couple always fights in the kitchen, instruct them to fight only in the bathroom\[32\].    ◦ _Action:_ If a client compulsively checks a lock, instruct them to check it a specific number of times or in a specific rhythm\[33\].
3\. **Recontextualization:** Introduce a new "context-marker" that changes the meaning of the behavior\[34\]\[35\].

    ◦ _Action:_ Using specific colored paper for memos that require no response\[35\].    ◦ _Action:_ Assigning "odd" and "even" days for giving in to a symptom versus fighting it\[36\].
4\. **Utilization:** Use the client's existing behaviors, beliefs, or resistance to build a bridge to the solution\[37\].

    ◦ _Action:_ If a client is "stubborn," reframe it as "determined" and use that determination to complete a difficult task\[38\].
5\. **Prescribing the Symptom (Recipes):** Give the client a "recipe" for their problem to expose its structure and put it under voluntary control\[39\].

    ◦ _Action:_ Tell a depressed client exactly how to sit, think, and act to "do" depression perfectly\[40\].
### Phase 4: Implementation and Follow-Up

The intervention is often delivered as a "turnkey" solution—ready for immediate use\[41\]. The change should happen essentially instantaneously (an all-or-none flip), not gradually\[42\]\[43\].

**Key Questions for Follow-Up:**

• **"What did you do, and how did it go?"** (Never ask "How are things?" as it invites vague abstractions. Focus on the action taken)\[44\].

**Summary of the Minimalist Approach:**

• **Don't** search for deep causes or history\[45\]\[46\].

• **Don't** try to change the person's personality\[47\].

• **Do** assume the client can change instantly if the right constraint is lifted\[48\].

• **Do** focus entirely on "video descriptions" of the present and future\[8\]\[49\].

---
> [!info]- References
> [1] James Wilk.pdf
> [2] James Wilk.pdf
> [3] James Wilk.pdf
> [4] James Wilk.pdf
> [5] [Book] Wilk - Shifting Contexts.pdf
> [6] [Book] Wilk - Shifting Contexts.pdf
> [7] James Wilk.pdf
> [8] James Wilk.pdf
> [9] [Book] Wilk - Shifting Contexts.pdf
> [10] [Book] Wilk - Shifting Contexts.pdf
> [11] [Book] Wilk - Shifting Contexts.pdf
> [12] [Book] Wilk - Shifting Contexts.pdf
> [13] [Book] Wilk - Shifting Contexts.pdf
> [14] James Wilk.pdf
> [15] James Wilk.pdf
> [16] James Wilk.pdf
> [17] James Wilk.pdf
> [18] [Book] Wilk - Shifting Contexts.pdf
> [19] James Wilk.pdf
> [20] [Book] Wilk - Shifting Contexts.pdf
> [21] [Book] Wilk - Shifting Contexts.pdf
> [22] [Book] Wilk - Shifting Contexts.pdf
> [23] [Book] Wilk - Shifting Contexts.pdf
> [24] [Book] Wilk - Shifting Contexts.pdf
> [25] James Wilk.pdf
> [26] James Wilk.pdf
> [27] [Book] Wilk - Shifting Contexts.pdf
> [28] [Book] Wilk - Shifting Contexts.pdf
> [29] [Book] Wilk - Shifting Contexts.pdf
> [30] [Book] Wilk - Shifting Contexts.pdf
> [31] [Book] Wilk - Shifting Contexts.pdf
> [32] [Book] Wilk - Shifting Contexts.pdf
> [33] [Book] Wilk - Shifting Contexts.pdf
> [34] James Wilk.pdf
> [35] James Wilk.pdf
> [36] [Book] Wilk - Shifting Contexts.pdf
> [37] [Book] Wilk - Shifting Contexts.pdf
> [38] [Book] Wilk - Shifting Contexts.pdf
> [39] [Book] Wilk - Shifting Contexts.pdf
> [40] [Book] Wilk - Shifting Contexts.pdf
> [41] James Wilk.pdf
> [42] James Wilk.pdf
> [43] James Wilk.pdf
> [44] [Book] Wilk - Shifting Contexts.pdf
> [45] James Wilk.pdf
> [46] James Wilk.pdf
> [47] [Book] Wilk - Shifting Contexts.pdf
> [48] James Wilk.pdf
> [49] [Book] Wilk - Shifting Contexts.pdf


FILE: 'John Flach.md'
---
exported: '2026-02-02T06:03:20.954Z'
source: NotebookLM
type: chat
title: John Flach on 💬How To Guides
tags:
  - How-To
  - John-Flach
  - NoMethodology
author: John Flach
---
Based on the provided sources, a "chaordic" investigation—one dealing with complex, adaptive, and often "wicked" sociotechnical systems—requires a fundamental shift from traditional linear analysis. The sources advocate for an approach often described as **Cognitive Systems Engineering**, **Work Domain Analysis**, or the science of **"Muddling Through."**

Here is a how-to guide for conducting this type of investigation, organized by the mindset required, the methodology to use, and the specific questions to ask.

### Phase 1: Establish the Investigative Mindset

Before asking questions, the investigator must adopt a specific stance toward the system. You cannot simply "analyze" a complex system; you must engage with it.

• **Abandon Linear Causality:** Do not look for a single "root cause" or a linear chain of events (like dominoes falling). In complex systems, everything is connected; causes and effects are circular. The behavior of the system (e.g., an accident or a success) is an emergent property of the interactions, not a result of a broken component\[1\],\[2\].

• **Recognize the System is a Mental Model:** Understand that the "system" does not exist objectively in the world. It is a representation you create to make sense of complexity. You choose what to include (the system) and what to exclude (the environment) based on your goals\[3\],\[4\],\[5\].

• **Accept "Wickedness":** Acknowledge that you are likely dealing with a "wicked problem"—one that is ill-formulated, confusing, and where solutions may generate new problems\[6\].

• **Be a Humble Participant:** You cannot be a purely objective observer. Your presence changes the system (the "Demand Characteristics"). You must view yourself as a participant, not a spectator\[7\],\[8\].

### Phase 2: Scoping the Investigation (The Boundaries)

You must explicitly define the scope of your investigation, knowing that this boundary is arbitrary but necessary.

• **Define the Focus System:** Determine the boundaries of your analysis. Do you define the system to fit your current tools, or do you scale your tools to fit the natural constraints of the problem?\[9\],\[10\].

• **Identify the Nature of Constraints:** Determine if the system is primarily governed by physical laws (causal/law-driven) or by human values and social rules (intentional/coherence-driven). Most complex systems are a mix of both\[11\],\[12\],\[13\].

### Phase 3: The "How-To" of Data Collection

The sources suggest specific methods for gathering information that go beyond standard interviews.

**1\. Active Listening (The "Undercover" Approach)**Instead of relying on top-down descriptions from management, go to the "messy" bottom-up reality.

• **Method:** Take a small group of workers (e.g., 3 people) to a private room. Provide food and a safe environment.

• **Rules:** Promise anonymity. State that the only things leaving the room are what is written on the flip chart.

• **Goal:** Discover the "work-as-done" rather than "work-as-imagined." Learn the tricks they use to cope with the system's wickedness\[14\],\[15\],\[16\].

**2\. Work Domain Analysis (WDA)**Do not just list tasks; map the _constraints_ that shape behavior.

• **Method:** Use the **Abstraction Hierarchy**. Map the system across levels, from its physical form (equipment) up to its functional purpose (values and goals)\[17\],\[18\].

• **Search for:** The "deep structure" of the problem—the physics, the economics, and the social rules that constrain what is possible\[17\],\[19\].

**3\. Critical Incident Method / Storytelling**

• **Method:** Ask experts to recount specific "critical incidents" or tough cases.

• **Goal:** Uncover the cues and heuristics (mental shortcuts) they used to make decisions. Experts often cannot articulate their knowledge until prompted by a specific story\[20\],\[21\],\[22\].

### Phase 4: Key Questions to Ask

The sources provide specific questions to guide both the analyst's thinking and the interviews with stakeholders.

Questions for the Analyst (Self-Reflection)

• **The Boundary Question:** "Where do we draw the boundaries to determine what to include in our explorations?"\[9\].

• **The Validity Question:** "Do the quantities in the models correspond to the attributes of the situations that ultimately matter?" (e.g., Can we quantify the apples that matter for the taste of the pie?)\[23\],\[24\].

• **The System Purpose Question:** "What is the system of interest? Do we reduce the problem to fit our models, or do we scale up our models to fit the situations?"\[10\].

Questions for the Workers (Active Listening)

• **The Golden Question:****"What gets in the way of you doing a great job?"**\[25\],\[26\].

• **The "Work-Around" Question:** "How do you actually do this?" (Look for deviations from standard procedures that are necessary to get the work done)\[27\].

• **The Friction Question:** "Are there checks and balances (friction) that feel like obstacles but actually prevent errors?"\[28\].

Questions for Work Domain Analysis (Probing the Structure)

• **The "Why" (Upward Abstraction):** "Why is this function performed?" "What are the ultimate values and priorities?"\[17\],\[29\].

• **The "How" (Downward Decomposition):** "How is this function achieved physically?" "What are the physical objects or resources used?"\[17\],\[30\].

• **The Structural Question:** "Is the system composed of mutually exclusive departments (silos), or is there overlap that allows for resilience?"\[31\].

### Phase 5: Synthesis and Intervention

Instead of trying to "solve" the problem once and for all, the goal is to design for **resilience** and **muddling through**.

• **Incrementalism:** Make small, incremental changes and monitor the feedback. Do not attempt massive, all-at-once overhauls, as small errors in complex systems can lead to large, unpredictable consequences (the Butterfly Effect)\[32\],\[33\],\[34\].

• **Design for Friction:** Do not remove all barriers in the name of efficiency. Some "friction" (resistance/checks) is essential for stability and error detection\[35\],\[36\].

• **Leverage Self-Organization:** Recognize that order often emerges from the bottom up (like termites building a nest). Support the workers' natural ability to adapt rather than imposing rigid top-down control\[37\],\[38\].

• **Triangulate:** Use multiple perspectives. Combine the view from the "microscope" (details) with the view from the "telescope" (big picture). Move up and down the abstraction hierarchy to connect "why" things happen with "how" they happen\[39\],\[40\].

---
> [!info]- References
> [1] Do Conversations Exist.pdf
> [2] Flach 2011 - Complexity learning to muddle through.pdf
> [3] Do Conversations Exist.pdf
> [4] Do systems exist A conversation - Adam Walls John Flach.pdf
> [5] Do systems exist A conversation - Adam Walls John Flach.pdf
> [6] Do systems exist A conversation - Adam Walls John Flach.pdf
> [7] Do Conversations Exist.pdf
> [8] Do systems exist A conversation - Adam Walls John Flach.pdf
> [9] Do Conversations Exist.pdf
> [10] Do systems exist A conversation - Adam Walls John Flach.pdf
> [11] Naikar - Work Domain Analysis.pdf
> [12] [Book] Flach - Display and Interface Design.pdf
> [13] [Book] Flach - Display and Interface Design.pdf
> [14] Do Conversations Exist.pdf
> [15] Do systems exist A conversation - Adam Walls John Flach.pdf
> [16] Do systems exist A conversation - Adam Walls John Flach.pdf
> [17] Do Conversations Exist.pdf
> [18] Flach 2015 - The Semiotic contxt for Systems Engineering.pdf
> [19] [Book] Flach - A Meaning Processing Approach to Cognition What Matters.pdf
> [20] Flach 2017 - Decision making in practice the art of muddling through.pdf
> [21] [Book] Flach - A Meaning Processing Approach to Cognition What Matters.pdf
> [22] [Book] Flach - What Matters 2017.pdf
> [23] Do Conversations Exist.pdf
> [24] Do Systems Exist - a Conversation.pdf
> [25] Do systems exist A conversation - Adam Walls John Flach.pdf
> [26] [Book] Walls - Do systems exist - A conversation Adam Walls John Flach.pdf
> [27] Do Conversations Exist.pdf
> [28] Do systems exist A conversation - Adam Walls John Flach.pdf
> [29] Naikar - Work Domain Analysis.pdf
> [30] Naikar - Work Domain Analysis.pdf
> [31] Do Conversations Exist.pdf
> [32] Do Conversations Exist.pdf
> [33] Do Conversations Exist.pdf
> [34] [Book] Walls - Do systems exist - A conversation Adam Walls John Flach.pdf
> [35] Do Systems Exist - a Conversation.pdf
> [36] Do systems exist A conversation - Adam Walls John Flach.pdf
> [37] Do Conversations Exist.pdf
> [38] Do systems exist A conversation - Adam Walls John Flach.pdf
> [39] [Book] Walls - Do systems exist - A conversation Adam Walls John Flach.pdf
> [40] [Book] Walls - Do systems exist - A conversation Adam Walls John Flach.pdf


FILE: 'John Warfield.md'
---
exported: '2026-02-01T16:17:41.341Z'
source: NotebookLM
type: chat
title: John Warfield on 💬How To Guides
aliases:
  - ISM
tags:
  - How-To
  - John-Warfield
  - Methodology
author: John Warfield
---
Based on the provided sources, here is a guide for conducting an Interpretive Structural Modeling (ISM) investigation. This process is often embedded within a broader framework called Interactive Management (IM) or the "Work Program of Complexity"\[1\],\[2\].

### **Phase 1: Preparation and Setup**

Before questioning begins, the structural parameters must be defined to ensure the group’s work is focused and consistent.

**1\. Define the Context and Issue**The investigation begins with a clear statement of the "problematic situation" or issue to be explored\[3\]. This context statement helps potential participants decide if they have the relevant experience to contribute\[4\].

**2\. Select the Participants and Facilitator**ISM is a group learning process designed to integrate diverse perspectives\[5\].

• **Participants:** Select a group (typically 8–15 people) of knowledgeable stakeholders or experts who possess deep, empirical knowledge of the situation\[6\],\[7\].

• **Facilitator:** An experienced facilitator is required to manage group dynamics, guide the process, and ensure the group focuses on the logic of the relationships rather than wandering into unrelated discussions\[8\],\[9\].

• **Computer Operator:** A staff member is needed to operate the ISM software, which manages the complex logic and matrix calculations\[10\],\[11\].

**3\. Determine the Type of Structure**You must decide what kind of model you wish to build, as this determines the nature of the questions asked. Common structure types include:

• **Problematique:** A structure showing how problems interact\[12\].

• **Intent Structure:** A hierarchy of objectives or goals\[13\].

• **Priority Structure:** A ranking of items by importance or preference\[13\].

• **Attribute Enhancement Structure:** Shows how factors or opportunities contribute to one another\[14\].

• **Process Structure:** Shows the sequence of activities\[15\].

\--------------------------------------------------------------------------------

### **Phase 2: Generating the Elements (Input)**

The ISM software requires a set of elements (ideas) to structure. The standard method for generating these is the **Nominal Group Technique (NGT)**\[16\],\[17\].

**1\. The Triggering Question**Pose a carefully formulated question to the group to elicit the elements.

• _Example:_ "What problems do you anticipate in striving to resolve problematic situation X?"\[18\].

• _Example:_ "What objectives should we achieve during this project?"\[19\].

**2\. Generation and Clarification**

• Participants generate ideas silently in writing\[20\].

• Ideas are posted on a wall or board for all to see\[20\].

• The group engages in a serial discussion to clarify and edit the ideas, ensuring shared understanding\[17\].

**3\. Filtering (Voting)**Because a group may generate over 100 ideas, it is often necessary to select a subset (e.g., the top 25–40) for structuring. Participants vote on the most important items, creating an "Importance Subset" to be entered into the ISM software\[21\],\[22\].

\--------------------------------------------------------------------------------

### **Phase 3: The Structuring Session (The Questions)**

This is the core of the ISM investigation. The computer software presents pairs of elements to the group and asks a specific "Generic Question" based on the "Contextual Relation" chosen in Phase 1\[23\],\[24\].

**1\. The Logic of the Question**The question usually follows the format: **"Does element A \[relationship\] element B?"**\[23\].

• If the group answers "Yes," a relationship is recorded (logic 1).

• If "No," no relationship is recorded (logic 0)\[25\].

• **Inference:** The software uses the mathematical property of _transitivity_ to infer answers to other questions. For example, if A relates to B, and B relates to C, the computer infers that A relates to C and will not ask the group that specific question, saving significant time\[26\],\[27\].

**2\. Specific Questions to Ask (By Structure Type)**You must select the specific phrasing based on your goal. Below are the standard questions identified in the sources:

• **For a Problematique (Analyzing Problems):**

    ◦ _Question:_ "Does problem X **significantly aggravate** problem Y?"\[28\],\[29\].    ◦ _Goal:_ To discover the root causes and how problems make other problems worse\[30\].
• **For an Intent Structure (Analyzing Objectives/Goals):**

    ◦ _Question:_ "Would the achievement of objective X **significantly help us in achieving** objective Y?"\[31\].    ◦ _Question:_ "Would the objective of \[A\] **help to achieve** the objective of \[B\]?"\[25\].    ◦ _Goal:_ To separate low-level actions from high-level strategic goals\[32\].
• **For a Priority Structure (Ranking):**

    ◦ _Question:_ "Is project X **a higher priority than** project Y?"\[26\].    ◦ _Question:_ "Is \[A\] **more important than** \[B\]?"\[14\].    ◦ _Question:_ "Is \[A\] **better value for money than** \[B\]?"\[14\].
• **For a Process or Temporal Structure (Sequencing):**

    ◦ _Question:_ "Does event X **precede** event Y?"\[33\].    ◦ _Question:_ "Should \[learning module A\] **be learned before** \[learning module B\]?"\[34\].
• **For Categorization (Clustering):**

    ◦ _Question:_ "Is element X **in the same category as** element Y?"\[35\].
**3\. Alternative Question Format (Type 2 Relationships)**If the relationship is not transitive (e.g., "influences" in a broad sense, where A influences B and B influences C does _not_ necessarily mean A influences C), standard ISM logic cannot be used\[36\].

• _Alternative Question:_ "What elements **influence** element A?"\[37\].

• The group identifies all impacting elements from the list, and the computer tracks connections without making logical inferences\[38\].

\--------------------------------------------------------------------------------

### **Phase 4: Interpretation and Analysis**

Once the questioning is complete, the software calculates the structure and produces a **Digraph** (Directed Graph) or "Map"\[39\],\[40\].

**1\. Display and Interpret**

• The facilitator presents the resulting map to the group. The numbered nodes on the graph are replaced with the actual text of the elements\[41\].

• The facilitator must be skilled in reading these structures to explain the logic to the participants\[42\].

• _Reading the Map:_ If an arrow points from A to B, it translates to the sentence: "A \[relationship\] B" (e.g., "Problem A aggravates Problem B")\[43\].

**2\. Analyze Cycles**

• A **Cycle** occurs when elements are mutually dependent (e.g., A aggravates B, and B aggravates A)\[44\].

• Cycles often indicate the most complex and difficult parts of the system, requiring a dedicated team to resolve them simultaneously rather than sequentially\[43\].

**3\. Review and Amend**

• The group reviews the structure to ensure it reflects their collective wisdom.

• Amendments can be made (e.g., adding a missing line or moving an element) if the group agrees by consensus\[45\],\[46\].

• **Note:** The structure represents a majority view. Empirical data shows that individual voting (prior to ISM) often correlates poorly with the final ISM structure, proving that the ISM process facilitates significant group learning\[47\],\[48\].

### **Summary Checklist for the ISM Guide**

1\. **Define Goal:** Problem analysis, Objective setting, or Sequencing?

2\. **Generate Items:** Use Nominal Group Technique (NGT).

3\. **Choose Relation:** Aggravates, Supports, Precedes, etc.

4\. **Ask Questions:** "Does Item A \[Relation\] Item B?"

5\. **Vote:** Majority vote determines the "Yes/No" input.

6\. **Computer Logic:** Allow software to infer transitive links.

7\. **Map:** Generate and interpret the resulting directed graph.

---
> [!info]- References
> [1] 17071793.pdf
> [2] Warfield - Measuring Complexity.pdf
> [3] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [4] [Book] Warfield - An Introduction to Systems Science.pdf
> [5] 04309336.pdf
> [6] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [7] Warfield - What questions have been answered to study complexity.pdf
> [8] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [9] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [10] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [11] [Book] Warfield - An Introduction to Systems Science.pdf
> [12] 17071793.pdf
> [13] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [14] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [15] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [16] 25192047.pdf
> [17] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [18] [Book] Warfield - An Introduction to Systems Science.pdf
> [19] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [20] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [21] [Book] Warfield - An Introduction to Systems Science.pdf
> [22] [Book] Warfield - An Introduction to Systems Science.pdf
> [23] Simpson - Augmented Interactive Management Overview.pdf
> [24] [Book] Warfield - An Introduction to Systems Science.pdf
> [25] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [26] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [27] [Book] Warfield - An Introduction to Systems Science.pdf
> [28] Warfield - Measuring Complexity.pdf
> [29] [Book] Warfield - An Introduction to Systems Science.pdf
> [30] warfield 1999 - problematique.pdf
> [31] [Book] Warfield - An Introduction to Systems Science.pdf
> [32] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [33] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [34] Simpson - The Problematique Application Structural Type.pdf
> [35] [Book] Warfield - An Introduction to Systems Science.pdf
> [36] Simpson - Open Source Structural Modeling Software.pdf
> [37] Simpson - Open Source Structural Modeling Software.pdf
> [38] Simpson - Open Source Structural Modeling Software.pdf
> [39] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [40] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [41] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [42] 17071793.pdf
> [43] [Book] Warfield - An Introduction to Systems Science.pdf
> [44] 04309336.pdf
> [45] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [46] [Book] Warfield - An Introduction to Systems Science.pdf
> [47] Warfield 1999 - Twenty Laws of Complexity science applicable in organisations.pdf
> [48] [Book] Warfield - An Introduction to Systems Science.pdf


FILE: 'MC Jackson.md'
---
exported: '2026-02-01T16:14:28.712Z'
source: NotebookLM
type: chat
title: MC Jackson on 💬How To Guides
tags:
  - How-To
  - MC-Jackson
  - Methodology
aliases:
  - EPIC
author: MC Jackson
---
Based on the provided sources, particularly the frameworks of **Critical Systems Practice (CSP)** and its predecessor **Total Systems Intervention (TSI)**, here is a guide for conducting a systemic investigation. This approach avoids linear "checklist" thinking and instead uses multiple perspectives to uncover the root causes of complex problems.

The investigation follows the **EPIC** framework: **E**xplore, **P**roduce, **I**ntervene, and **C**heck\[1\].

\--------------------------------------------------------------------------------

### **Phase 1: Explore the Situation of Interest**

**Goal:** To gain a rich appreciation of the problem without jumping to conclusions. You must view the situation through five specific "systemic perspectives" to identify the primary issues\[2\],\[3\].

**Questions to ask during the Explore Phase:**

• **The Mechanical Perspective (Efficiency & Efficacy):**

    ◦ Is the system structured to achieve its goals efficiently?\[4\]    ◦ Are the inputs, processes, and outputs clearly defined?\[4\]    ◦ Are there clear plans and resources in place to respond to demands?\[5\]
• **The Interrelationships Perspective (Feedback & Control):**

    ◦ How do the different parts of the system interact?\[6\]    ◦ Are there "feedback loops" where an action creates a reaction that reinforces the problem (e.g., panic buying causing shortages)?\[7\]    ◦ Are there unintended consequences of previous actions?\[8\]
• **The Organismic Perspective (Viability & Adaptability):**

    ◦ Is the organization able to adapt to changes in its environment?\[9\]    ◦ Are the subsystems (departments/teams) functioning well in support of the whole?\[10\]    ◦ Is the organization "viable"—can it maintain a separate existence?\[9\]
• **The Purposeful Perspective (Culture & Motivation):**

    ◦ Do the stakeholders share common goals and values?\[9\]    ◦ Are there clashing worldviews (interpretations of reality) among the participants?\[11\]    ◦ What are the "myths and meanings" that drive behavior in the organization?\[12\]
• **The Societal/Environmental Perspective (Fairness & Power):**

    ◦ Who is being marginalized or disadvantaged by the current system?\[13\],\[14\]    ◦ Who has the power to make decisions, and who is excluded?\[15\]    ◦ What is the impact on the wider environment?\[8\]
\--------------------------------------------------------------------------------

### **Phase 2: Produce an Intervention Strategy**

**Goal:** To choose the right specific methodology to address the issues found in Phase 1.**Process:** Use the **System of Systems Methodologies (SOSM)** grid to match the problem context to the right tool\[16\],\[17\].

**Diagnostic Questions to Determine the Approach:**

1\. **Is the system Simple or Complex?**

    ◦ _Simple:_ A small number of elements with regular, predictable interactions\[18\],\[19\].    ◦ _Complex:_ Many elements with loose interactions; the system evolves and is not predictable\[18\],\[19\].
2\. **Is the relationship between participants Unitary, Pluralist, or Coercive?**

    ◦ _Unitary:_ Participants share common interests and agree on ends and means\[20\],\[15\].    ◦ _Pluralist:_ Participants have different values/beliefs but basic compatibility; compromise is possible\[20\],\[15\].    ◦ _Coercive:_ Participants do not share common interests; conflict is irreconcilable; some coerce others\[21\],\[15\].
\--------------------------------------------------------------------------------

### **Phase 3: Intervene (Specific Questions by Methodology)**

Depending on the answers in Phase 2, use one of the following sets of questions to deepen the investigation.

**A. If the problem is Organizational/Structural (Complex-Unitary)**

_Use the_ **Viable System Model (VSM)** _to diagnose faults in structure and communication_\[22\]_,_\[23\]_._

• **System 1 (Operation):** What are the operational units doing? Are they autonomous enough to handle their own problems?\[23\],\[24\]

• **System 2 (Coordination):** What are the sources of conflict or oscillation between units? What harmonizing elements exist (e.g., schedules, protocols)?\[23\],\[25\]

• **System 3 (Control):** How is the "resource bargain" handled? Is accountability clear?\[26\],\[27\]

• **System 4 (Intelligence/Future):** Is the system monitoring the outside world for threats and opportunities? Is it open to novelty?\[28\],\[29\]

• **System 5 (Policy):** Does the system have a suitable identity? Does it balance the present (System 3) with the future (System 4)?\[30\],\[31\]

**B. If the problem is Cultural/Strategic (Pluralist)**

_Use_ **Soft Systems Methodology (SSM)** _or_ **Strategic Assumption Surfacing and Testing (SAST)** _to understand conflicting worldviews_\[32\]_,_\[33\]_._

**SSM Questions (CATWOE Analysis):**

• **C (Customers):** Who are the victims or beneficiaries of the system's activity?\[34\],\[35\]

• **A (Actors):** Who actually does the activities?\[34\],\[35\]

• **T (Transformation):** What input is being transformed into what output?\[34\],\[35\]

• **W (Weltanschauung/Worldview):** What view of the world makes this definition meaningful?\[34\],\[35\]

• **O (Owners):** Who has the power to stop the activity?\[34\],\[35\]

• **E (Environmental Constraints):** What constraints does the system take as given?\[34\],\[35\]

**SAST Questions (Assumptions):**

• Who are the key stakeholders who care about this issue?\[36\]

• What assumptions are we making about them in believing our strategy will succeed?\[37\]

• What is the _counter-assumption_ (the deadly enemy) to our belief?\[38\]

**C. If the problem is Political/Coercive (Coercive)**

_Use_ **Critical Systems Heuristics (CSH)** _to expose power dynamics and value judgments_\[39\]_,_\[14\]_._

**The 12 Boundary Questions (Ask "What is..." vs. "What ought to be..."):**

1\. **Client:** Who is the actual beneficiary? Who _ought_ to be?\[40\],\[41\]

2\. **Purpose:** What is the actual purpose (measured by consequences)? What _ought_ it to be?\[40\],\[41\]

3\. **Measure of Success:** What is the built-in measure of success?\[40\],\[41\]

4\. **Decision-Maker:** Who is actually the decision taker?\[42\],\[41\]

5\. **Resources:** What conditions are controlled by the decision taker?\[42\],\[41\]

6\. **Environment:** What conditions are _not_ controlled by the decision taker?\[42\],\[41\]

7\. **Planner:** Who is actually involved as the planner?\[42\],\[43\]

8\. **Expertise:** Who is involved as an "expert"? What counts as expertise?\[42\],\[43\]

9\. **Guarantee:** Where do the involved seek the guarantee that their plan will succeed?\[42\],\[43\]

10\. **Witness:** Who represents the concerns of those affected but not involved?\[44\],\[43\]

11\. **Emancipation:** Are the affected given the chance to emancipate themselves from the experts?\[44\],\[45\]

12\. **Worldview:** What worldview is actually underlying the design?\[46\],\[45\]

\--------------------------------------------------------------------------------

### **Phase 4: Check on Progress**

**Goal:** Evaluate the intervention not just by whether the problem was "solved," but by how the system has improved across multiple dimensions\[47\].

**Evaluation Questions:**

• **Efficiency:** Did we minimize the use of resources? (Mechanical perspective)\[8\]

• **Efficacy:** Did the means work to achieve the goals? (Mechanical perspective)\[48\]

• **Effectiveness:** Did we achieve the longer-term purposes and agree on desirable changes? (Purposeful perspective)\[8\],\[49\]

• **Viability/Resilience:** Is the system more robust and adaptable? (Organismic perspective)\[8\]

• **Ethicality/Emancipation:** Have we improved the lot of the disadvantaged? Have we empowered the marginalized? (Societal perspective)\[8\],\[50\]

---
> [!info]- References
> [1] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [2] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [3] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [4] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [5] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [6] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [7] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [8] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [9] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [10] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [11] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [12] [Book] Jackson - Systems Thinking - creative holism for managers.pdf
> [13] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [14] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [15] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [16] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [17] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [18] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [19] [Book] Jackson - Systems Thinking - creative holism for managers.pdf
> [20] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [21] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [22] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [23] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [24] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [25] [Book] Jackson - Systems Thinking - creative holism for managers.pdf
> [26] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [27] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [28] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [29] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [30] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [31] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [32] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [33] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [34] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [35] [Book] Jackson - Systems Thinking - creative holism for managers.pdf
> [36] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [37] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [38] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [39] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [40] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [41] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [42] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [43] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [44] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [45] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [46] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [47] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [48] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [49] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [50] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf


FILE: 'MOM.md'
---
exported: 2026-02-07T22:02:24.142Z
source: NotebookLM
type: chat
title: MOM on 💬How To Guides
tags:
  - How-To
  - MOM
author: MOM
---
Based on the "Meeting of Minds" (MoM) discussions, an investigation into a complex situation should not follow a rigid, linear checklist (which they critique as "systematic" or reductionist). Instead, it should be a **methodology of inquiry** that bridges theory and practice ("Rigour and Vigour")\[1\].

Here is a guide to conducting a systemic investigation, structured by the phases and questions advocated by the group.

### **Phase 1: Preparation (The Stance of the Observer)**

Before asking questions of others, you must address your own mindset. You must accept that "systems" do not exist in the real world; they are mental constructs used to make sense of reality\[2\]\[3\].

• **Adopt "Second-Order" Thinking:** Recognize that you cannot separate the observer from the observation. How you define the problem depends on your perspective\[4\].

• **The 3 C’s:** Approach the inquiry with **Curiosity**, **Creativity**, and **Courage**\[5\].

• **Adopt Learned Ignorance:** Move from false certainty to "knowing that you don't know." Avoid immediate solutioneering\[6\].

### **Phase 2: Diagnosis (Reality Judgements)**

Do not look for the "problem" immediately; look at the "mess" (a system of interacting problems).

**Key Principle: POSIWID**

• **The Concept:** "The Purpose Of The System Is What It Does" (Stafford Beer). Ignore the mission statement or what management _says_ the system is for. Observe the actual behavior and outcomes\[7\]\[8\].

**Questions to Ask:**

• **The Reality Question (Vickers):** "What is the state of the world?" Focus on facts, not opinions\[9\].

• **The Clean Language Questions:** Use questions free of jargon to reveal mental models without contaminating the witness\[10\]\[11\]:

    ◦ _"What is actually happening?"_    ◦ _"What stops you from doing X?"_    ◦ _"What happens just before Y?"_
• **The Attribution Question (The Brick Analogy):** If a brick falls on a foot, did gravity cause the pain, or did the person who dropped it cause the pain? (This determines where you draw the boundary of responsibility)\[12\].

### **Phase 3: Framing & Boundaries (Value Judgements)**

Complexity arises from conflicting perspectives. You must identify who is inside the system and who is outside.

**Key Framework: Critical Systems Heuristics (CSH)**Use Ulrich’s boundary questions to expose power dynamics and ethics\[13\].

**Questions to Ask:**

• _"Who is the actual client (beneficiary)?"_\[14\]

• _"Who is the victim (affected but not involved)?"_\[13\]

• _"From whose perspective is this a system?"_\[15\]

• _"What is the measure of success?"_ (Is it efficiency or effectiveness?)\[16\]

• **The Value Question (Vickers):**_"Is this state good or bad?"_\[9\]

### **Phase 4: Intervention Selection (Instrumental Judgements)**

Avoid "Silver Bullets" or pre-packaged solutions (like Lean/Six Sigma) if they don't fit the context\[4\]\[7\].

**Key Principle: Multi-Methodology**Select the right approach for the specific context (Critical Systems Thinking)\[9\].

**Questions to Ask:**

• **Structural Issue:**_"Is the issue about viability, autonomy, or communication channels?"_ (If yes, use the **Viable System Model / VSM**)\[17\]\[18\].

• **Worldview Conflict:**_"Is the issue that stakeholders have different definitions of the problem?"_ (If yes, use **Soft Systems Methodology / SSM** to build conceptual models)\[19\].

• **The "Do Nothing" Option:**_"Is there a clear path to do nothing?"_ (Watchful waiting). If the methodology does not allow for _not_ intervening, it is likely a sales tool, not a systems approach\[20\].

### **Phase 5: Validation & Reflection**

Before acting, validate your thinking against the group's quality criteria.

**Questions to Ask:**

• **The 3 A’s:** Is this insight **Accurate** (theoretically sound), **Accessible** (understandable), and **Actionable** (useful)?\[1\]\[21\].

• **The 4 E’s:**

    1. **Efficacy:** Does the means work?    2. **Efficiency:** How many resources are used?    3. **Effectiveness:** Does it achieve the longer-term goal/value?    4. **Ethics:** Is it the right thing to do?\[16\]\[22\].
• **The "Killer" Test:**_"If you could not access any of the Systems Theory body of knowledge, could you still complete this method?"_

    ◦ If the answer is **Yes**, you are likely doing "Systematic" process improvement (like Vanguard), not Systems Thinking.    ◦ If the answer is **No**, you are engaging in true Systems Thinking\[23\].
### **Summary of the "MoM" Investigation Flow**

1\. **Observe:** Look at the mess through **POSIWID** (What is it actually doing?).

2\. **Frame:** Use **CSH** to ask who benefits and who is affected.

3\. **Select:** Choose a model (**VSM** for structure, **SSM** for perspective) to understand _why_ it is doing that.

4\. **Critique:** Test your proposed intervention against **Ethics** and **Effectiveness**.

---
> [!info]- References
> [1] mom-all-csv.csv
> [2] mom-all-csv.csv
> [3] mom-all-csv.csv
> [4] mom-all-csv.csv
> [5] mom-all-csv.csv
> [6] mom-all-csv.csv
> [7] mom-all-csv.csv
> [8] mom-all-csv.csv
> [9] mom-all-csv.csv
> [10] mom-all-csv.csv
> [11] mom-all-csv.csv
> [12] mom-all-csv.csv
> [13] mom-all-csv.csv
> [14] mom-all-csv.csv
> [15] mom-all-csv.csv
> [16] mom-all-csv.csv
> [17] mom-all-csv.csv
> [18] mom-all-csv.csv
> [19] mom-all-csv.csv
> [20] mom-all-csv.csv
> [21] mom-all-csv.csv
> [22] mom-all-csv.csv
> [23] mom-all-csv.csv


FILE: 'Max Boisot.md'
---
exported: '2026-02-02T06:02:28.149Z'
source: NotebookLM
type: chat
title: Max Boisot on 💬How To Guides
tags:
  - How-To
  - Max-Boisot
  - NoMethodology
author: Max Boisot
---
Based on the provided sources, a "chaordic" investigation operates within the **Complexity Regime** of the **Ashby Space**—a zone situated between the "Ordered Regime" (stable, predictable) and the "Chaotic Regime" (random, incomprehensible)\[1\]. In this zone, events are governed by **power laws** (Pareto distributions) rather than normal (Gaussian) distributions, meaning small "butterfly events" can spiral into extreme outcomes\[5\].

To conduct an investigation in this environment, one cannot rely on standard deductive or inductive logic used in stable environments. Instead, one must use **scalable abduction**—inference to the best explanation across multiple levels of scale\[8\].

The following guide outlines the process of moving from **Possible** to **Plausible** to **Probable** knowledge using the **Social Learning Cycle (SLC)** and the **I-Space** framework.

\--------------------------------------------------------------------------------

### **How-To Guide: Conducting a Chaordic Investigation**

**Phase 1: Preparation (The Cognitive Stance)**

Before collecting data, investigators must adjust their epistemological approach to avoid "false negatives" (missing a threat) or "false positives" (wasting resources on noise).

• **Abandon Gaussian Thinking:** Do not assume events are independent or normally distributed. Acknowledge that in complex systems, "tiny initiating events" can scale up to catastrophic results (e.g., 9/11, Enron)\[11\].

• **Adopt an Abductive Mindset:** Instead of testing a known theory (deduction) or generalizing from a sample (induction), look at the mass of facts and allow them to suggest a pattern. You are looking for a "logic of discovery" rather than a "logic of justification"\[14\]\[15\].

• **Prepare for "Weak Signals":** You are looking for information that is currently **uncodified** (vague/fuzzy) and **concrete** (context-specific). This is the **Scanning** phase of the Social Learning Cycle\[16\].

**Phase 2: The Investigation Process (The Filter Model)**

This process is designed to winnow down trillions of potential patterns into a manageable few by filtering them through three specific lenses: Context, Vantage Point, and Time\[19\]\[20\].

**Step 1: Identify Contextual Tensions (Possible Worlds)**You must filter data points ("dots") by looking for **adaptive tension**—energy differentials in the system that exceed a critical value (R). Order emerges only when tension is sufficient to trigger a phase transition (like water reaching a boiling point)\[19\]\[21\].

• _Action:_ Scan the environment for areas of high stress or energy. Ignore dots where the adaptive tension is too low to generate a reaction.

• _Goal:_ Establish that a threat or opportunity is **Possible**.

**Step 2: Triangulate Vantage Points (Plausible Worlds)**A pattern observed by one person is subjective. To filter out noise, you need corroboration from independent, situated observers.

• _Action:_ Cross-reference the signal with other agents located at different "vantage points" (v). If multiple agents with different perspectives detect the same tension or anomaly, the pattern gains credibility\[22\]\[23\].

• _Goal:_ Move the pattern from Possible to **Plausible**.

**Step 3: Test for Robustness Over Time (Probable Worlds)**Chaotic environments fluctuate wildly. A meaningful pattern must exhibit stability over a duration.

• _Action:_ Track the correlated signals across multiple time periods (t). If the adaptive tension and the signal persist across these periods, the pattern is not random noise\[24\]\[25\].

• _Goal:_ Move the pattern from Plausible to **Probable**.

**Phase 3: Pattern Crystallization (Chunking)**

Once a probable pattern is identified, it must be structured so it can be communicated and acted upon.

• **Codification and Abstraction:** Convert the fuzzy insight into a clear code (Codification) and reduce the number of categories needed to describe it (Abstraction)\[26\]\[27\].

• **Chunking:** Group the corroborated data points into "Chunks"—valid pattern elements that can be fed into decision-making hierarchies or neural networks for response\[28\]\[29\].

\--------------------------------------------------------------------------------

### **Key Questions to Ask During the Investigation**

To facilitate **scalable abduction** and move through the I-Space, ask the following questions at each stage:

**1\. Questions for Scanning (Detecting Possibility)**

• _The Tension Check:_ "Where in the system are energy differentials or tensions exceeding the critical threshold (R)?"\[19\]\[21\].

• _The Anomaly Check:_ "Are we seeing 'dots' (data points) that violate our standard expectations or theoretical models?"\[6\]\[8\].

• _The Butterfly Check:_ "Could this tiny initiating event be a 'butterfly event' capable of scaling up into an extreme outcome?"\[6\]\[9\].

**2\. Questions for Corroboration (Establishing Plausibility)**

• _The Vantage Check:_ "Who else sees this? Do agents at different vantage points (v) perceive a similar correlation?"\[22\]\[23\].

• _The Connection Check:_ "Are the histories of these diverse actors correlated? (e.g., Did Agent A and Agent B interact previously?)"\[30\].

• _The Coherence Check:_ "Does this pattern make sense based on the situated perspectives of different agents?"\[22\].

**3\. Questions for Persistence (Determining Probability)**

• _The Time Check:_ "Has this tension remained consistent over t time periods, or is it transient and chaotic?"\[24\]\[25\].

• _The Recurrence Check:_ "Is the pattern recurring frequently enough to yield a frequency count, allowing us to move from 'plausible' to 'probable'?"\[31\].

**4\. Questions for Action (Codification and Impact)**

• _The Hypothesis Check:_ "What is the 'inference to the best explanation' for these connected dots?"\[14\]\[32\].

• _The Response Check:_ "Does the variety of our response match the variety of the environmental stimuli?" (Ashby’s Law)\[33\].

• _The Knowledge Check:_ "How can we codify this insight to share it rapidly (Diffusion) without losing the rich context required to understand it?"\[36\]\[37\].

\--------------------------------------------------------------------------------

### **Summary of the "Chaordic" Flow**

The investigation follows this trajectory in the **I-Space** (Information Space):

1\. **Scanning (Uncodified/Undiffused):** Detect weak signals/tensions.

2\. **Problem-Solving (Codification):** Give structure to the signals; create a hypothesis.

3\. **Abstraction:** Generalize the pattern to see if it fits broader models.

4\. **Diffusion:** Share the reliable intelligence with the network for action.

5\. **Absorption/Impacting:** Internalize the new reality and act upon it\[38\].

---
> [!info]- References
> [1] 2010 Boisot, McKelvey(10)-Integrating Modernist and Postmodernist Perspectives on Organizations-A Complexity Science Bridge.pdf
> [5] 2010 Boisot, McKelvey(10)-Integrating Modernist and Postmodernist Perspectives on Organizations-A Complexity Science Bridge.pdf
> [6] 2011 Boisot, McKelvey(11)-Connectivity, Extremes, Adaptation-PL Perspective.pdf
> [8] 2010 Boisot, McKelvey(10)-Integrating Modernist and Postmodernist Perspectives on Organizations-A Complexity Science Bridge.pdf
> [9] 2011 Boisot, McKelvey(11)-Connectivity, Extremes, Adaptation-PL Perspective.pdf
> [11] 2011 Boisot, McKelvey(11)-Connectivity, Extremes, Adaptation-PL Perspective.pdf
> [14] 2011 Boisot, McKelvey(11)-Connectivity, Extremes, Adaptation-PL Perspective.pdf
> [15] Boisot and McKelvey - connectivity extremes and adaptation a power-law perspective of organizational effectiveness.pdf
> [16] [Book] Boisot - 1987 - Information and organizations - Fontana Press.pdf
> [19] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [20] [Book] Boisot - Terrorism and financial management.pdf
> [21] [Book] Boisot - Terrorism and financial management.pdf
> [22] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [23] [Book] Boisot - Terrorism and financial management.pdf
> [24] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [25] [Book] Boisot - Terrorism and financial management.pdf
> [26] [Book] Boisot - Collisons and Collaboration - 2011.pdf
> [27] [Book] Boisot - Collisons and Collaboration - 2011.pdf
> [28] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [29] [Book] Boisot - Terrorism and financial management.pdf
> [30] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [31] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [32] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [33] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [36] [Book] Boisot - 1995 - Information space - Routledge.pdf
> [37] [Book] Boisot - Collisons and Collaboration - 2011.pdf
> [38] [Book] Boisot - Knowledge, Organization, and Management Building on the Work of Max  Boisot.pdf


FILE: 'Mike McMaster.md'
---
tags:
  - How-To
  - Mike-McMaster
title: Mike McMaster on 💬How To Guides
author: Mike McMaster
---
Based on the methodologies detailed in the sources, particularly Michael McMaster’s _Performance Management_ and _The Intelligence Advantage_, here is a how-to guide for conducting an investigation. This approach focuses on recovering high-quality information, removing ambiguity, and uncovering the "deep structure" of a situation.

Phase 1: Set the Conditions (Context & Rapport)

Before asking specific questions, you must establish an environment where accurate information can flow.

1. **Frame the Investigation:** Explicitly state the purpose of your questions. This puts the other person at ease and reduces defensiveness.

    ◦ _Script:_ "To make a decision/solve this problem, I need to understand exactly what happened from your perspective. I’m going to ask you a few specific questions to gather the facts so we can move forward with shared information",.

2. **Establish Rapport:** You cannot investigate effectively if the other person is defensive. Match their posture, voice tone, and language style to create a sense of shared understanding before diving into the details,,.

3. **Use Sensory-Grounded Language:** When you speak, describe only what can be seen or heard (observable facts), avoiding judgments or adjectives like "poor attitude" or "sloppy work" which confuse the issue,.

--------------------------------------------------------------------------------

Phase 2: The Precision Investigation (The Questions)

Use the **Precision Model** to drill down into vague statements. Most people speak in "shorthand," leaving out critical details. Your goal is to recover that missing information using these specific "Blockbuster" questions,.

1. The "Noun" Blockbuster

Use this when the person uses vague nouns (e.g., "They," "It," "The management," "The reports").

• **The Trigger:** "They never listen to us." / "The machines are broken."

• **The Question:** **"Who specifically?" / "Which machine specifically?"**.

2. The "Action" Blockbuster

Use this when the verb is unspecified or the process is unclear.

• **The Trigger:** "We need to improve communication." / "He failed to deliver."

• **The Question:** **"Improve how specifically?" / "Failed how specifically?"**.

3. The "Universal" Blockbuster

Use this to challenge generalizations that limit thinking.

• **The Trigger:** Words like _always, never, everyone, no one, all_. ("He is always late.")

• **The Question:** **"Are there any exceptions?"** / **"Has there ever been a time when he wasn't?"**.

4. The "Comparator" Blockbuster

Use this when a comparison is made but the standard is hidden.

• **The Trigger:** Words like _better, worse, too much, too little, expensive_. ("It costs too much.")

• **The Question:** **"Too much compared to what?"**.

5. The "Boundary" Blockbuster

Use this to investigate perceived limitations or necessities.

• **The Trigger:** Words like _can't, must, have to, impossible_. ("We can't do that.")

• **The Question:** **"What stops you?"** or **"What would happen if we did?"**.

--------------------------------------------------------------------------------

Phase 3: Strategic & Complex Investigations

If your investigation is about the root cause of a complex organizational issue rather than a specific event, use **Generative Questions** and **Structural Mapping**.

**Generative Questions (to uncover hidden assumptions):**

• "What is crying out for change in our department/industry?",.

• "What do we all accept to be true that is merely an agreement?".

• "What is hidden from us by our current way of speaking about this problem?".

**Structural Questions (for complex, multi-factor problems):** When investigating a "mess" with many variables (e.g., a breakdown involving staff, technology, and policy), do not ask "Why?" as it often leads to blame. Instead, map the relationships:

• **The Question:** **"Does [Factor A] significantly aggravate or contribute to [Factor B]?"**.

• _Process:_ Repeat this for different factors until you see the "deep structure" or root driver of the problem,.

--------------------------------------------------------------------------------

Phase 4: Confirming Understanding

Never assume you understand the answers. Use these techniques to verify:

1. **Backtracking:** Repeat the key facts back to the person using their own words. "So, you are saying that [X] happened and then [Y] occurred. Is that correct?",.

2. **The "As If" Frame:** If the person is stuck or hesitant, ask: "If you _did_ know, what would the answer be?" or "If we could solve this, what would it look like?",.

3. **Completing the Thought:** Ensure you have a complete sentence structure for every allegation or fact: **"Who did what to whom?"**.

Summary Checklist for an Investigator

• [ ] Did I frame the conversation to reduce fear?

• [ ] Am I asking "Who specifically?" and "How specifically?" rather than accepting vague answers?

• [ ] Am I challenging generalizations ("Always?", "Never?")?

• [ ] Am I asking "Compared to what?" when I hear judgment words?

• [ ] Have I separated the _facts_ (what was seen/heard) from the _interpretations_?,

FILE: 'Nassim Nicholas Taleb.md'
---
exported: '2026-02-02T06:04:22.842Z'
source: NotebookLM
type: chat
title: Nassim Nicholas Taleb on 💬How To Guides
tags:
  - How-To
  - Nicholas-Taleb
  - NoMethodology
author: Nassim Nicholas Taleb
---
Based on the provided sources, particularly the works of Nassim Nicholas Taleb (_Antifragile_, _Fooled by Randomness_) and the paper on the _Precautionary Principle_, the term "**chaordic**" (the blend of chaos and order) does not appear explicitly. However, the texts provide a rigorous framework for investigating systems that exist at the intersection of **chaos** (randomness, volatility, disorder) and **order** (stability, structure).

Taleb frames this investigation as distinguishing between the **Fragile** (what hates chaos), the **Robust** (what ignores chaos), and the **Antifragile** (what benefits from chaos)\[1\],\[2\].

Here is a guide to conducting such an investigation, focusing on detecting fragility, filtering noise, and managing the unknown.

### **Phase 1: Domain Mapping (The Landscape)**

Before investigating specific data, you must determine the nature of the environment. A primary error in investigation is using the wrong map for the territory.

• **Determine the Quadrant:** Ask if the subject belongs to "Mediocristan" or "Extremistan."

    ◦ _Mediocristan (Thin-tailed):_ Variations are small and predictable (e.g., human height). One single observation cannot impact the total\[3\].    ◦ _Extremistan (Fat-tailed):_ Variations are wild (e.g., financial markets, book sales). One single event can change everything. Predictive models here are often dangerous\[4\],\[5\].
• **Distinguish the "Ludic" from the "Ecological":**

    ◦ _Ludic:_ Is the system like a casino with clear, defined rules and known probabilities?\[6\],\[7\].    ◦ _Ecological:_ Is it like real life—messy, with unknown rules and invisible risks? Investigations often fail by treating ecological problems as if they were ludic games\[6\].
### **Phase 2: The Stress Test (Detecting Fragility)**

You do not need to predict the future to understand a system; you only need to measure its fragility. The core heuristic for this is **convexity** (non-linearity)\[8\],\[9\].

• **Apply the "King and the Stone" Test:**

    ◦ If you throw a 10-pound stone at someone, it causes extreme harm. If you throw 1,000 pebbles (totaling 10 pounds), it causes annoyance but no serious injury.    ◦ **The Rule:** If doubling the stress causes _more_ than double the harm, the system is fragile (concave). If it benefits from volatility (up to a point), it is antifragile (convex)\[10\],\[11\],\[12\].
• **Check for Optimization:** Systems that are highly optimized for a specific set of conditions (like a tight train schedule) are fragile to slight deviations. A "chaordic" system requires slack (redundancy) to handle the unexpected\[13\],\[14\].

### **Phase 3: Epistemological Audit (Filtering Knowledge)**

This phase focuses on separating signal from noise and identifying false knowledge.

• **Filter Noise from Signal:** In complex systems, the more frequently you look at data, the more "noise" (randomness) you see relative to "signal" (meaningful information).

    ◦ _Action:_ Ignore small changes. Focus only on large deviations. An investigation reacting to daily fluctuations acts like a neurotic, not an expert\[15\],\[16\].
• **Apply** **Via Negativa** **(Subtractive Knowledge):**

    ◦ We know what is wrong with more certainty than we know what is right. An investigation should focus on disproving theories (falsification) and removing fragile elements rather than trying to prove a complex narrative\[17\],\[18\].
• **Identify the "Green Lumber Fallacy":**

    ◦ Are the experts mistaking "textbook" knowledge (definitions, theories) for "practical" knowledge (how things actually work)? Often, the person who can explain the theory (the "know-what") fails, while the practitioner (the "know-how") succeeds without being able to explain why\[19\],\[20\],\[21\].
### **Phase 4: Risk Assessment (The Precautionary Principle)**

When dealing with chaos, you must distinguish between recoverable mistakes and total ruin.

• **Differentiate Local Risk vs. Systemic Ruin:**

    ◦ If a risk is local (e.g., a car accident), standard risk management applies.    ◦ If a risk is systemic (e.g., a virus, GMOs, financial contagion) and carries a possibility of irreversible ruin, you must apply the **Precautionary Principle**: the burden of proof is on the innovator to prove safety, not on the public to prove harm\[22\],\[23\].
• **Check for "Skin in the Game":**

    ◦ Are the decision-makers exposed to the harm they might cause? If a "captain" does not go down with the ship, the system is fragile because errors do not filter out the incompetent\[24\],\[25\].
\--------------------------------------------------------------------------------

### **The Investigation Checklist: Questions to Ask**

**On Fragility:**

• **"Does this system like volatility?"** Does it improve when stressed (like a muscle) or does it break (like a porcelain cup)?\[1\],\[26\].

• **"What happens if we double the dose?"** Does the harm increase disproportionately? If yes, it is fragile\[10\],\[11\].

• **"Is this system optimized?"** Has redundancy been removed for the sake of "efficiency"? If so, it is vulnerable to Black Swans (rare events)\[13\],\[27\].

**On Evidence and Data:**

• **"Are we mistaking absence of evidence for evidence of absence?"** Just because we haven't seen a crash/disaster/black swan, does that mean it cannot happen?\[28\],\[29\],\[30\].

• **"Is this a 'Turkey' situation?"** Does the data show steady safety (like a turkey being fed for 1,000 days) right before a total blowup (Thanksgiving)?\[28\],\[30\].

• **"Are we looking at the rearview mirror?"** Are we using past frequency to predict future probability in a domain that changes (Extremistan)?\[31\],\[32\].

**On Interventions:**

• **"Can we improve this by removing something?"** (Via Negativa). Can we reduce risk by stopping a medication, removing a regulation, or reducing debt rather than adding a new fix?\[33\],\[34\].

• **"Is this an iatrogenic intervention?"** Is the "cure" causing hidden harm that exceeds the benefits?\[35\],\[36\].

**On Ethics and Competence:**

• **"Do the experts have skin in the game?"** Do they suffer if they are wrong? If not, their predictions are worthless\[24\],\[25\].

• **"Is this person a 'Fragilista'?"** Do they think they understand the system better than they actually do, utilizing naive rationalism to intervene in complex processes?\[37\],\[38\].

---
> [!info]- References
> [1] [Book] Taleb - Antifragile.pdf
> [2] [Book] Taleb - Antifragile.pdf
> [3] [Book] Taleb - Antifragile.pdf
> [4] [Book] Taleb - Antifragile.pdf
> [5] [Book] Taleb - Antifragile.pdf
> [6] [Book] Taleb - Antifragile.pdf
> [7] [Book] Taleb - Antifragile.pdf
> [8] [Book] Taleb - Antifragile.pdf
> [9] [Book] Taleb - Antifragile.pdf
> [10] [Book] Taleb - Antifragile.pdf
> [11] [Book] Taleb - Antifragile.pdf
> [12] [Book] Taleb - Antifragile.pdf
> [13] [Book] Taleb - Antifragile.pdf
> [14] [Book] Taleb - Antifragile.pdf
> [15] [Book] Taleb - Antifragile.pdf
> [16] [Book] Taleb - Fooled by randomness.pdf
> [17] [Book] Taleb - Antifragile.pdf
> [18] [Book] Taleb - Antifragile.pdf
> [19] [Book] Taleb - Antifragile.pdf
> [20] [Book] Taleb - Antifragile.pdf
> [21] [Book] Taleb - Antifragile.pdf
> [22] taleb - pp2.pdf
> [23] taleb - pp2.pdf
> [24] [Book] Taleb - Antifragile.pdf
> [25] [Book] Taleb - Antifragile.pdf
> [26] [Book] Taleb - Antifragile.pdf
> [27] [Book] Taleb - Fooled by randomness.pdf
> [28] [Book] Taleb - Antifragile.pdf
> [29] [Book] Taleb - Antifragile.pdf
> [30] [Book] Taleb - Antifragile.pdf
> [31] [Book] Taleb - Fooled by randomness.pdf
> [32] [Book] Taleb - Fooled by randomness.pdf
> [33] [Book] Taleb - Antifragile.pdf
> [34] [Book] Taleb - Antifragile.pdf
> [35] [Book] Taleb - Antifragile.pdf
> [36] [Book] Taleb - Antifragile.pdf
> [37] [Book] Taleb - Antifragile.pdf
> [38] [Book] Taleb - Antifragile.pdf


FILE: 'Neil Postman.md'
---
exported: '2026-02-02T04:31:20.034Z'
source: NotebookLM
type: chat
title: Neil Postman on 💬How To Guides
tags:
  - How-To
  - Neil-Postman
  - NoMethodology
author: Neil Postman
---
Based on the provided sources, specifically Neil Postman’s _Crazy Talk, Stupid Talk_, the term "chaordic investigation" does not explicitly appear. However, the text details a comprehensive method of inquiry called **"meta-semantics."** This method is designed to investigate the **order** (sanity/effectiveness) and **chaos** (stupidity/craziness) within communication.

Postman describes this investigation as a discipline to help individuals gain control over their "minding processes" by assessing the relationship between language and the "semantic environment" (the total social situation).

Here is a guide to conducting this investigation, including the specific questions Postman proposes to determine if a situation is functioning rationally or has descended into chaos.

### **How to Conduct a Meta-Semantic Investigation**

**1. Adopt the Stance of a Participant-Observer** The fundamental strategy is to psychologically step outside the context of the environment you are in. You must move from being solely a _participant_ to being an _observer_.

- **Goal:** Suspend belief and ideology to focus on the _process_ of communication rather than just the content. You must become less interested in participating and more interested in observing.
- **Action:** Transform every remark you hear into a question about its purpose, tone, assumptions, and metaphorical structure.

**2. Identify the Semantic Environment** Recognize that you are analyzing a "semantic environment," which includes people, their purposes, the general rules of discourse, and the particular talk being used. You must determine if the environment is functioning rationally or is polluted by "stupid" or "crazy" talk.

- **Stupid Talk:** Talk that is confused in direction, inappropriate in tone, or ineffective in achieving its purpose.
- **Crazy Talk:** Talk that creates an irrational context, sustains unreasonable or evil purposes, or challenges the validity of the environment entirely.

### **The Questions to Ask**

Postman provides a specific "instrument" of inquiry consisting of questions to ask during this investigation. These questions are designed to uncover the structure and health of the semantic environment.

**Phase 1: Establish Context and Purpose**

- **What is the general area of discourse I am in?** (Is this the language of law? Science? Commerce? Religion? Romance? Politics? Entertainment?).
- **Is there ambiguity or confusion over what sort of situation this is?** If so, how has such confusion been created?.
- **What are the avowed (or hypothetical) purposes of this environment?** (Is it to satisfy the need for knowledge? Spiritual uplift? Economic security? Social cohesion? Protection?).
- **What are the _actual_ purposes being achieved by the way this environment is organized?**.
- **Is there a correspondence between the avowed and actual purposes?** Or are there contradictions between the environment and its subsystems?.
- **Are there conflicts between the purposes of the situation and the needs of individuals within it?**.

**Phase 2: Analyze Structure and Atmosphere**

- **Who are the people performing within the situation?** How well do they know its rules and language?.
- **What are the general characteristics of the _atmosphere_ of this environment?** How are these characteristics made visible?.
- **What attitudes are required, and of whom?**.
- **What is the role-structure of the environment?** Is it fixed (rigid) or fluid?.

**Phase 3: Examine Vocabulary and Metaphor**

- **What are the technical terms used in the environment?**.
- **What are its _key terms_, including its basic metaphors?**.
- **Who is controlling the metaphors?** Who or what is in charge of maintaining the definitions?.

**Phase 4: Identify Dysfunction (The "Chaos")** You must determine to what extent the language in the environment is characterized by specific communication failures. Ask if the environment suffers from:

- **Fanaticism?** (Falling in love with one's own sentences/irrefutable answers).
- **Eichmannism?** (Commitment to technique over human consequences).
- **The IFD Disease?** (Idealization leading to Frustration and Demoralization).
- **Propaganda?** (Language inviting an emotional, either-or response).
- **Self-reflexiveness?** (Language feeding on itself rather than reality).
- **Sloganeering?** (Ritualistic utterances replacing individual thought).
- **Verbal inflation or Mystification?** (Bloating meanings or making ideas inaccessible).
- **Reification?** (Confusing words with things).
- **Systemaphilia?** (Belief in perfect systems/total change).
- **Confused levels of abstraction?** (Confusing inside/outside realities or specific/general statements).

**Phase 5: Assess Consequences**

- **What are the effects of any of these "problems"?**.
- **Do they compromise the integrity of the environment?**.
- **Do they confuse or change its purpose?**.
- **Do they change the atmosphere or role-structure?**.
- **What attitudes do they promote?**.

### **The Final Judgment**

The investigation concludes by making a judgment about the "workability" or "desirability" of the talk.

- If the talk fails to achieve the legitimate purposes of the environment (e.g., confusing facts with opinions, misinterpreting roles), it is **Stupid Talk**.
- If the talk sustains an irrational purpose or evil/trivial values (e.g., "killing for peace"), it is **Crazy Talk**.

The ultimate goal of this investigation is to move beyond being a "victim" of a mode of discourse to becoming a "critic" of it, ensuring that "rational intelligence proves itself sounder than the reflex".

FILE: 'Niklas Luhmann.md'
---
exported: '2026-02-01T16:52:48.677Z'
source: NotebookLM
type: chat
title: Niklas Luhmann on 💬How To Guides
aliases:
  - Systems Theory
tags:
  - How-To
  - Methodology
  - Niklas-Luhmann
author: Niklas Luhmann
---
Based on the theoretical frameworks of Niklas Luhmann (Systems Theory) and the risk management principles discussed previously (Professor Mainelli), an investigation cannot simply be a search for "what happened." It must be a **second-order observation**: observing how the system observed itself, how it processed information, and how it absorbed uncertainty to reach the outcome in question\[1\]\[2\].

Here is a guide for conducting such an investigation, structured by the theoretical phases of inquiry.

### **Phase 1: Define the System and the Observer**

Before gathering evidence, you must define the boundaries. An organization is not a collection of people; it is an autopoietic system of **decisions**\[3\]. The investigation must focus on the chain of communications, not just physical actions.

**Key Concepts:** System/Environment Difference, Operational Closure.

**Investigation Steps:**

1\. **Identify the System Boundary:** Determine which specific subsystem (department, project team) is under review. Remember that the system constructs its own environment; it does not react to the "real" environment but only to its own internal model of it\[4\].

2\. **Locate the Observer:** Acknowledge your position. Are you an external observer (sociologist/auditor) or an internal observer? You must observe the "blind spot"—the distinctions the system used that it could not see itself using\[5\]\[6\].

**Questions to Ask:**

• "How did the system distinguish itself from its environment in this specific case? What was treated as 'internal' (controllable) and what was treated as 'external' (given)?"\[4\]\[7\].

• "Did the organization operate as a closed system, relying only on its own past decisions to interpret new data, or was it irritated by environmental noise?"\[8\]\[9\].

### **Phase 2: Analyze the Anatomy of Decisions**

Organizations produce themselves through decisions. A decision is a specific operation that fixes a difference between the past (unalterable) and the future (unknown)\[10\]. The most critical mechanism to investigate is **Uncertainty Absorption**.

**Key Concepts:** Uncertainty Absorption, The Rejected Alternative, The Paradox of Decision.

**Investigation Steps:**

1\. **Trace the Chain of Uncertainty Absorption:** Uncertainty absorption occurs when inferences are drawn from evidence, and only the _inference_ (not the evidence) is passed to the next level\[11\]. The investigation must find the exact point where the evidence was dropped and replaced by a "fact."

2\. **Uncover the Rejected Alternatives:** A decision is only a decision if it could have been otherwise. Investigate what alternatives were communicated but rejected. The "rejected possibilities" bind the system just as much as the accepted ones\[12\]\[13\].

3\. **Identify the Paradox:** Every decision is paradoxically baseless (it decides something undecidable). Look for how the organization hid this paradox—usually by attributing the decision to a "subject" (a specific leader) or a "rule" to stop further questioning\[14\]\[15\].

**Questions to Ask:**

• "At what point was raw data converted into a 'conclusion' or 'status report'? Who stripped away the uncertainty before passing the information up the chain?"\[11\].

• "What alternatives were explicitly rejected? Did the system retain a memory of _why_ they were rejected, or was that context lost?"\[16\].

• "Did the organization attempt to resolve the paradox of decision-making by blaming a specific person (attribution) rather than analyzing the decision structure?"\[17\].

### **Phase 3: Evaluate Decision Premises (The "Why")**

Decisions are not isolated; they are based on **decision premises**. These are the structural constraints that allow the organization to operate without analyzing every detail every time\[18\].

**Key Concepts:** Conditional Programs vs. Purposive Programs, Communication Channels.

**Investigation Steps:**

1\. **Classify the Program:** Determine if the decision was based on a **Conditional Program** (if X happens, then do Y) or a **Purposive Program** (we must achieve Goal Z, choose the means)\[19\].

    ◦ _Risk:_ Confusion between these two causes failure. For example, treating a safety rule (conditional) as a goal to be optimized (purposive) often leads to disaster.
2\. **Analyze Communication Channels:** Did the decision follow the formal hierarchy (which serves to absorb uncertainty) or informal networks (gossip/trust)?\[20\]\[21\].

**Questions to Ask:**

• "Was the actor operating under a **conditional program** (input-oriented: 'is this legal/correct?') or a **purposive program** (output-oriented: 'will this make a profit/work?')?"\[19\].

• "Did the conditional program become so complex (too many exceptions) that it became impossible to distinguish right from wrong?"\[22\].

• "Did the formal hierarchy block necessary information flow? Was the 'official channel' used only to confirm decisions already made in the informal 'shadow' network?"\[23\]\[24\].

### **Phase 4: The Human Element (Membership and Personnel)**

Individuals (psychic systems) are part of the _environment_ of the organization, not the system itself. They are "structurally coupled" to the organization via the role of **Membership**\[25\]\[26\].

**Key Concepts:** Interpenetration, Career, The Person as Decision Premise.

**Investigation Steps:**

1\. **Assess "The Person" as a Premise:** Often, organizations use a person's reputation or "character" as a substitute for a decision program. If a rule is missing, they rely on "Smith's judgment." Investigate if this reliance concealed a lack of structural guidance\[27\].

2\. **Analyze the Career Motive:** Individuals observe the organization through the lens of "career." Did the decision-maker act to secure their career (self-observation) rather than to solve the organizational problem?\[28\].

**Questions to Ask:**

• "Was a specific person used as a 'decision premise' to cover up a gap in the organization's programming?"\[20\].

• "Did the organization rely on 'motivating' individuals rather than creating clear structural expectations?"\[29\].

• "How did the 'career' schema influence the information passed upward? Was bad news suppressed to protect a career?"\[30\].

### **Phase 5: Synthesis (Risk, Learning, and Forgetting)**

Finally, apply Mainelli’s scientific management principles (prediction/falsifiability) through Luhmann’s lens of **Time** and **Memory**.

**Key Concepts:** Memory (Forgetting), Risk vs. Danger, Consistency.

**Investigation Steps:**

1\. **Check the System Memory:** The function of memory is largely _forgetting_—clearing the system to process new information\[31\]. Investigate if the system "forgot" previous similar failures too quickly to maintain operational capacity.

2\. **Distinguish Risk from Danger:** Did the organization perceive the outcome as a **risk** (something they decided to take) or a **danger** (something that happened to them from the outside)?\[10\].

3\. **Test for Consistency (ECC):** Did the organization’s internal map (self-description) match the territory? If inputs (resources/programs) did not correlate with outputs (results), the self-description is a fiction\[4\]\[32\].

**Questions to Ask:**

• "What has the system systematically 'forgotten' in order to continue functioning?"\[33\].

• "Did the organization treat a self-generated **risk** (e.g., a risky investment) as an external **danger** (e.g., 'the market crashed') to avoid responsibility?"\[34\]\[35\].

• "Is the organization’s self-description (e.g., 'we are a rational, safety-first company') consistent with its actual decision history, or is it a 'useful fiction' maintained to avoid conflict?"\[36\].

---
> [!info]- References
> [1] [Book] Luhmann - Introduction to Systems Theory.pdf
> [2] [Book] Luhmann - Introduction to Systems Theory.pdf
> [3] [Book] Luhmann - Organization and Decision.pdf
> [4] [Book] Luhmann - Organization and Decision.pdf
> [5] [Book] Luhmann - Introduction to Systems Theory.pdf
> [6] [Book] Luhmann - Organization and Decision.pdf
> [7] [Book] Luhmann - Organization and Decision.pdf
> [8] [Book] Luhmann - Organization and Decision.pdf
> [9] [Book] Luhmann - Organization and Decision.pdf
> [10] [Book] Luhmann - Organization and Decision.pdf
> [11] [Book] Luhmann - Organization and Decision.pdf
> [12] [Book] Luhmann - Organization and Decision.pdf
> [13] [Book] Luhmann - Organization and Decision.pdf
> [14] [Book] Luhmann - Organization and Decision.pdf
> [15] [Book] Luhmann - Organization and Decision.pdf
> [16] [Book] Luhmann - Organization and Decision.pdf
> [17] [Book] Luhmann - Organization and Decision.pdf
> [18] [Book] Luhmann - Organization and Decision.pdf
> [19] [Book] Luhmann - Organization and Decision.pdf
> [20] [Book] Luhmann - Organization and Decision.pdf
> [21] [Book] Luhmann - Organization and Decision.pdf
> [22] [Book] Luhmann - Organization and Decision.pdf
> [23] [Book] Luhmann - Organization and Decision.pdf
> [24] [Book] Luhmann - Organization and Decision.pdf
> [25] [Book] Luhmann - Social Systems (Writing Science).pdf
> [26] [Book] Luhmann - Organization and Decision.pdf
> [27] [Book] Luhmann - Organization and Decision.pdf
> [28] [Book] Luhmann - Organization and Decision.pdf
> [29] [Book] Luhmann - Organization and Decision.pdf
> [30] [Book] Luhmann - Organization and Decision.pdf
> [31] [Book] Luhmann - Organization and Decision.pdf
> [32] [Book] Luhmann - Introduction to Systems Theory.pdf
> [33] [Book] Luhmann - Organization and Decision.pdf
> [34] [Book] Luhmann - Organization and Decision.pdf
> [35] [Book] Luhmann - Organization and Decision.pdf
> [36] [Book] Luhmann - Organization and Decision.pdf


FILE: 'OU Course.md'
---
exported: 2026-02-07T22:01:55.109Z
source: NotebookLM
type: chat
title: OU Course on 💬How To Guides
tags:
  - How-To
  - OU-Course
author: OU Course
---
Based on the Open University materials provided, an investigation is viewed as a "learning system" or a cycle of inquiry rather than a linear search for a single solution. The guide below outlines how to conduct an investigation, structuring the process into phases and providing specific questions to ask at each stage.

### **Phase 1: Entry and "Finding Out" (Unstructured Exploration)**

Before attempting to define "the problem," you must explore the situation to understand the context, culture, and politics. Avoid imposing a rigid structure too early; treat the situation as a "mess" (a system of interacting problems).

**The 5 Fundamental Questions**Start with these broad questions to open the investigation\[1\]:

1\. **"What happened?"** (Establish the events).

2\. **"How did it come to happen?"** (Look for history and process).

3\. **"Was \[X\] to blame?"** (Investigate roles and responsibilities).

4\. **"How could it be put right?"** (Initial ideas for solutions).

5\. **"What would you do next?"** (Action orientation).

**Contextual Questions**To understand the "climate" of the situation, ask\[2\]:

• "What is the history and wider context of this situation?"

• "How do the people involved _feel_ about it? What are their hunches and suspicions?"

• "What is **not** going on? What is missing that you might expect to see?"

• "What behavior is regarded as 'good' or 'bad' in this environment?" (To establish norms).

**Role Definition**Clarify the key players by asking\[5\]:

• **"Who is the Client?"** (Who caused the study to take place?).

• **"Who is the Problem Solver?"** (Who wishes to do something about the situation?).

• **"Who is the Problem Owner?"** (Who is concerned or affected? Note: There are usually multiple problem owners).

\--------------------------------------------------------------------------------

### **Phase 2: Choosing Your Approach**

Once you have an initial picture, you must decide which systems approach fits the situation.

• **Ask:** "Is this a **Difficulty**?" (Are objectives clear and agreed upon? Is it a matter of optimization?) → Use the **Hard Systems Approach**\[8\]\[9\].

• **Ask:** "Is this a **Mess**?" (Is the situation ill-defined? Is there disagreement on what the problem is?) → Use the **Soft Systems Approach (SSM)**\[8\]\[10\].

• **Ask:** "Is this a **Failure**?" (Has something gone wrong that needs explaining?) → Use the **Failures Approach**\[11\]\[12\].

\--------------------------------------------------------------------------------

### **Phase 3: Defining the "System of Interest"**

You must move from the real world to the abstract world of systems thinking by formulating a "System of Interest" to help analyze the situation.

**For Soft Systems (Dealing with "Messes"):**Use the **CATWOE** checklist to rigorously define the system you are modeling\[13\]:

• **C (Customers):** "Who are the victims or beneficiaries of the system?"

• **A (Actors):** "Who would do the activities?"

• **T (Transformation):** "What input is being transformed into what output?" (e.g., Unpainted fence → Painted fence).

• **W (Weltanschauung):** "What worldview makes this system meaningful?"

• **O (Owners):** "Who has the power to stop the activity?"

• **E (Environmental constraints):** "What external constraints does the system take as given?"

**For Hard Systems (Dealing with "Difficulties"):**Focus on the logic of decision-making\[16\]:

• **Objectives:** "Where would you like to get to?"

• **Constraints:** "What stops you?"

• **Routes:** "How could you get there?" (Generate options).

• **Measures of Performance:** "How will you know when you have arrived?" (e.g., cost, speed, reliability).

**For Failures (Diagnosing Breakdown):**Compare the situation against a "Formal System Model"\[19\]\[20\]:

• "Was there a continuous purpose?"

• "Was there a decision-making subsystem?"

• "Was performance monitored?"

• "Were resources adequate?"

\--------------------------------------------------------------------------------

### **Phase 4: Comparison and Debate**

Compare your abstract models back against the real world to generate insights.

**The Comparison Matrix**Take the activities from your model and ask of the real world\[21\]\[22\]:

• "Does this activity happen in the real world?"

• "If so, _how_ is it done and by whom?"

• "How is it judged?"

• "Is there a reason for doing it this way?"

**The "3 Es" of Performance**Evaluate the system's success using these criteria\[23\]\[24\]:

• **Efficacy:** "Does the means work? Does it produce the output?"

• **Efficiency:** "Is it done with minimum resources?"

• **Effectiveness:** "Does the transformation help achieve the longer-term goal?"

\--------------------------------------------------------------------------------

### **Techniques for Asking Questions**

The way you ask questions determines the quality of information you receive.

**1\. Interviewing Strategy**

• **Start with Open Questions:** (e.g., "Tell me about the department's role"). This allows the respondent to shape the answer and reveals their priorities\[25\]\[26\].

• **Use Closed Questions later:** (e.g., "Was X present at the meeting?") Use these only to check specific facts\[27\].

• **Avoid "Leading" Questions:** Do not phrase questions that imply the answer you want (e.g., "Don't you think the new policy is a failure?")\[27\].

**2\. Deep Questioning Techniques**

• **The "Why" Technique:** When a reason is given, ask "Why?" and "Why else?" repeatedly to uncover multiple causes and deeper layers\[28\]\[29\].

• **The Inverse Optimal Question:** To challenge assumptions, ask: "What would I have to assume to be true for this idea to be the optimal solution?"\[30\].

• **De-Construction:** Ask, "Who brought this component into the situation and why?" to understand the purpose behind existing structures\[31\].

### **Summary Checklist for the Investigator**

• **Do** acknowledge that your presence changes the situation (you are part of the system)\[6\].

• **Do not** define "the problem" immediately; define the "situation" first\[32\].

• **Do not** treat your model as a description of the real world; treat it as a tool to explore the real world\[33\]\[34\].

---
> [!info]- References
> [1] IERC - Diagrams as an aid to thinking.pdf
> [2] Managing complexity - A systems approach - Introduction.pdf
> [5] T301 Block I - Introduction.pdf
> [6] T301 Block IV - Soft Systems Analysis.pdf
> [8] IERC - systems thinking for managing change.pdf
> [9] T301 Block I - Introduction.pdf
> [10] IERC - from technology push to organisational pull.pdf
> [11] T301 Block I - Introduction.pdf
> [12] T301 Block II - Systems Paradigms Systems Failures.pdf
> [13] IERC - from technology push to organisational pull.pdf
> [16] T301 Block IIIa - Systems Models - 1 of 2.pdf
> [19] T301 Block II - Systems Paradigms Systems Failures.pdf
> [20] T301 Block IV - Soft Systems Analysis.pdf
> [21] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [22] T301 Block IV - Soft Systems Analysis.pdf
> [23] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [24] block_4_full.pdf
> [25] OU B718 - Methods of inquiry.pdf
> [26] T301 Block VI - Project Guide - 1 of 2.pdf
> [27] OU B718 - Methods of inquiry.pdf
> [28] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [29] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [30] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [31] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [32] T301 Block IV - Soft Systems Analysis.pdf
> [33] OU T306 Managing Complexity Block 1.pdf
> [34] T301 Block IV - Soft Systems Analysis.pdf


FILE: 'Patrick Hoverstadt.md'
---
exported: '2026-02-01T16:23:37.562Z'
source: NotebookLM
type: chat
title: Patrick Hoverstadt on 💬How To Guides
tags:
  - How-To
  - Methodology
  - Patrick-Hoverstadt
aliases:
  - Enhanced VSM
author: Patrick Hoverstadt
---
Based on the provided sources, particularly the works of Patrick Hoverstadt on the Viable System Model (VSM), Patterns of Strategy, and Systems Thinking, here is a guide for conducting a systemic investigation.

This guide combines the **VSM diagnostic approach** (for organizational structure and viability) with the **Patterns of Strategy approach** (for external relationships and strategic fit).

### **Phase 1: Define the Scope and Identity**

Before analyzing mechanics, you must define what the system is and its purpose. This prevents solving the wrong problem or "mistaking the map for the territory"\[1\]\[2\].

**The Process:**

1\. **Establish the Identity:** Determine what the organization actually _is_ based on what it _does_, not just its mission statement.

2\. **Set the Boundaries:** Define the system of interest. You typically need to model three levels: the system itself, the wider system it is part of (meta-system), and its sub-systems\[3\].

**Questions to Ask:**

• **Identity:** "What is this organization and what is it for?"\[4\].

• **Purpose:** "What business are we in?" (If the answer is a generic product, probe deeper into the value provided)\[5\].

• **Primary Activities:** "What are the activities the organization does that deliver value to external customers?" (Distinguish these from support activities like accounting or maintenance)\[6\]\[7\].

• **Structural Coupling:** "Who are the key stakeholders, and how do they have the power to change what the organization does?"\[8\]\[9\].

\--------------------------------------------------------------------------------

### **Phase 2: Unfold Complexity (Structural Analysis)**

This phase uses the Viable System Model to check if the organization has the necessary internal structures to survive and handle complexity\[10\]\[11\].

**The Process:**

1\. **Unfold Primary Activities:** Break down the organization into its constituent viable systems (fractal levels)\[12\].

2\. **Check for Missing Links:** Ensure every primary activity has the five essential management systems (Operations, Coordination, Delivery Management, Intelligence, Policy)\[13\].

**Questions to Ask:**

• **System 1 (Operations):** "How is the organization broken down? Does the structure match the complexity of the environment?"\[14\]\[15\].

• **System 2 (Coordination):** "Are there mechanisms to ensure different primary activities don't conflict or oscillate?" (e.g., Are there turf wars or recurring operational problems?)\[16\]\[17\].

• **System 3 (Delivery Management):** "Is there an agreement on resources provided in return for performance delivered?"\[18\].

• **System 4 (Intelligence):** "Is there a function looking at the future and the outside environment (marketing, R&D, forecasting)?"\[19\]\[20\].

• **System 5 (Policy):** "Is there a mechanism to balance the demands of the 'here and now' (delivery) with the 'future' (intelligence)?"\[21\].

\--------------------------------------------------------------------------------

### **Phase 3: Analyze Relationships (Strategic Fit and Power)**

This phase moves beyond internal structure to examine how the organization relates to other actors (competitors, partners, regulators) using the "Patterns of Strategy" framework.

**The Process:**

1\. **Define Structural Couplings:** Identify the critical relationships that drive the organization's evolution\[22\].

2\. **Assess the Dimensions:** Evaluate the current state of Fit, Power, and Time in these relationships\[23\].

**Questions to Ask:**

• **Trajectory:** "Where does this relationship take us if we make no changes? Is that somewhere we want to go?"\[24\].

• **Differentiation:** "Are we part of the 'herd' (doing what everyone else does), on the 'edge', or an 'individual'?"\[25\]\[26\].

• **Drive:** "Are we shaping the relationship, reacting to it, or co-evolving with it?"\[27\].

• **Power:** "Are we stronger, balanced, or weaker than the other actor?"\[28\].

• **Time:** "Are we faster, synchronized, or slower than the other actor/environment?"\[29\].

• **Value Exchange:** "What value (wanted and unwanted) are we getting, and what are we giving?"\[30\].

\--------------------------------------------------------------------------------

### **Phase 4: Investigate Dynamics and Reality (Monitoring)**

A common failure in investigations is relying on reports rather than reality. This phase focuses on verifying what is actually happening.

**The Process:**

1\. **Check Monitoring Channels:** Ensure management isn't relying solely on filtered reports.

2\. **Look for "Gaming":** Investigate if metrics are being manipulated to look good.

**Questions to Ask:**

• **Monitoring:** "Do managers perform sporadic, unannounced, in-depth monitoring that bypasses immediate subordinates?"\[31\].

• **Truth vs. Reports:** "Does management have confidence that what they _think_ is happening really is happening?"\[32\]\[33\].

• **Gaming:** "Are people meeting targets but destroying value (e.g., hoarding stock, ignoring crimes)?"\[34\].

• **The "Undiscussables":** "What topics are being ignored or passed over in meetings because there are no answers?"\[35\].

\--------------------------------------------------------------------------------

### **Phase 5: Apply Systems Laws (Deep Diagnosis)**

If the problem is stubborn, "splice" systems laws together to find the root cause. This involves looking for what constraints exist and what is _not_ happening\[36\].

**Questions to Ask:**

• **Requisite Variety:** "Does the management system have enough variety (complexity) to match the variety of the situation it is trying to control?"\[37\].

• **Circular Causality:** "Are there positive feedback loops driving instability (e.g., vicious circles)?"\[38\].

• **The "Dog That Didn't Bark":** "What might have happened but did not? What constraints prevented a different outcome?"\[39\]\[40\].

• **Homeostasis:** "What mechanisms are maintaining the status quo and resisting change?"\[41\].

### **Summary of the Investigation Workflow**

1\. **Model the Current Situation:** Map the structural couplings and internal VSM structure\[42\].

2\. **Assess the Default Trajectory:** If nothing changes, where does the current momentum take the organization?\[43\].

3\. **Develop Options:** How can we change the elements of Fit (differentiation, drive), Power, or Time to alter the trajectory?\[44\].

4\. **Test the Strategy:** Use a "Red Team" to challenge assumptions and model how other actors will react\[45\].

---
> [!info]- References
> [1] [Book] Hoverstadt - The Grammar of Systems.pdf
> [2] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [3] [Book] Hoverstadt - The Grammar of Systems.pdf
> [4] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [5] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [6] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [7] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [8] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [9] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [10] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [11] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [12] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [13] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [14] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [15] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [16] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [17] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [18] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [19] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [20] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [21] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [22] [Book] Hoverstadt - Patterns of Strategy.pdf
> [23] [Book] Hoverstadt - Patterns of Strategy.pdf
> [24] [Book] Hoverstadt - Patterns of Strategy.pdf
> [25] [Book] Hoverstadt - Patterns of Strategy.pdf
> [26] [Book] Hoverstadt - Patterns of Strategy.pdf
> [27] [Book] Hoverstadt - Patterns of Strategy.pdf
> [28] [Book] Hoverstadt - Patterns of Strategy.pdf
> [29] [Book] Hoverstadt - Patterns of Strategy.pdf
> [30] [Book] Hoverstadt - Patterns of Strategy.pdf
> [31] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [32] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [33] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [34] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [35] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [36] [Book] Hoverstadt - The Grammar of Systems.pdf
> [37] [Book] Hoverstadt - Patterns of Strategy.pdf
> [38] [Book] Hoverstadt - The Grammar of Systems.pdf
> [39] [Book] Hoverstadt - The Grammar of Systems.pdf
> [40] [Book] Hoverstadt - The Grammar of Systems.pdf
> [41] [Book] Hoverstadt - The Grammar of Systems.pdf
> [42] [Book] Hoverstadt - Patterns of Strategy.pdf
> [43] [Book] Hoverstadt - Patterns of Strategy.pdf
> [44] [Book] Hoverstadt - Patterns of Strategy.pdf
> [45] [Book] Hoverstadt - Patterns of Strategy.pdf


FILE: 'Paul Cilliers.md'
---
exported: '2026-02-02T04:31:20.034Z'
source: NotebookLM
type: chat
title: Paul Cilliers on 💬How To Guides
tags:
  - How-To
  - NoMethodology
  - Paul-Cilliers
author: Paul Cilliers
---
Based on the provided sources, particularly the work of Paul Cilliers, the specific term "chaordic" (often associated with Dee Hock) does not explicitly appear. However, Cilliers extensively discusses the nature of systems that exist between rigid order and pure chaos, often referring to this approach as **"Critical Complexity"** or **"General Complexity"**\[1\],\[2\].

Cilliers argues that complex systems are neither homogeneous nor chaotic; they have structure, but it is dynamic and transformative\[3\],\[4\]. Therefore, an investigation into such systems requires a specific methodological attitude rather than a rigid recipe.

Here is a guide for conducting an investigation into complex systems based on Cilliers' principles, which aligns with the spirit of a "chaordic" inquiry.

### **Guide to a Critical Complexity Investigation**

**Phase 1: Adopting the Correct Attitude**

Before asking specific questions, the investigator must adopt a stance of **modesty** and **provisionality**.

• **Acknowledge Ignorance:** Accept that you cannot know the complex system completely. Because interactions are non-linear and the system is open, any model you create will be flawed and limited\[5\],\[6\].

• **Embrace Modesty:** Modesty is not weakness; it is a responsible recognition of limits. To claim you understand the system fully is not only hubristic (technically wrong) but unethical, as it suppresses the "other" or that which you do not see\[7\],\[8\].

• **Adopt the Provisional Imperative:** You must act and decide, but you must do so knowing your knowledge is incomplete. Your conclusions must always be open to revision\[9\],\[10\].

**Phase 2: Framing and Bounding**

You cannot analyze the whole universe; you must draw a boundary to define the system.

• **Step:** consciously draw a boundary around the system to distinguish it from its environment.

• **Insight:** Realize that this boundary is not "natural" or objective. It is a strategic choice made by you, the observer, for the purpose of description\[11\],\[12\].

• **Action:** Document _why_ you drew the boundary where you did, and acknowledge what is being excluded.

**Phase 3: Mapping Relationships and Differences**

Avoid the trap of reductionism (breaking the system into static parts). Focus on the dynamic interactions.

• **Step:** Identify the interactions between components rather than the components themselves. Meaning and identity in the system are generated through relationships of _difference_, not by positive distinct entities\[13\],\[14\].

• **Insight:** Look for the "trace." Components (or nodes) have no significance by themselves; they only gain significance through patterns of interaction, similar to how a word only has meaning in relation to other words\[15\].

• **Action:** Analyze the feedback loops. Look for where the system "loops back" on itself, creating non-linear effects where small causes might have massive results\[16\],\[17\].

**Phase 4: Incorporating Time and Memory**

A static snapshot of a complex system is a distortion. The investigation must be diachronic (through time).

• **Step:** Investigate the history of the system. The system's current structure is a result of its sedimented history and memory\[18\].

• **Insight:** Respect "slowness." Complex systems require a certain hysteresis (lag or slowness) to maintain identity. If a system reacts immediately to every fluctuation in the environment, it has no identity; it merely mirrors the chaos around it\[19\].

• **Action:** Avoid immediate judgments based on current efficiency. Allow time for the investigation to unfold, as meaning is often "deferred"—it becomes clear only later\[20\].

**Phase 5: The Ethical Check**

Because you cannot calculate an objective truth about the system, your description is a choice, and therefore an ethical act.

• **Step:** Explicitly identify the normative choices made in your model.

• **Insight:** Since you had to reduce complexity to understand it, and since there is no objective way to do this, you are responsible for the distortions you introduced\[21\].

• **Action:** Engage in "agonistic" dialogue. Allow dissenting voices and conflict to surface, as consensus often masks the suppression of difference\[22\],\[23\].

\--------------------------------------------------------------------------------

### **The Investigator’s Questionnaire**

Based on Cilliers' "Provisional Imperative" and his characteristics of complexity, ask the following questions during your investigation:

**1\. Questions on Boundaries and Framing**

• _Where have I drawn the line between the system and its environment, and who or what is excluded by this framing?_\[24\],\[21\].

• _Am I treating this boundary as a natural fact, or acknowledging it as a strategic choice I have made?_\[11\].

• _What are the potential consequences for the elements I have marginalized or ignored by this framing?_\[25\].

**2\. Questions on Dynamics and Relationships**

• _Am I trying to understand the system by breaking it down (reduction), or by observing the patterns of interaction?_\[26\].

• _Where are the feedback loops? Am I assuming linear cause-and-effect where circular causality actually exists?_\[17\],\[27\].

• _Is there enough diversity in the system? (Sameness does not generate meaning; richness comes from the interaction of differences)_\[28\],\[29\].

**3\. Questions on Time and Stability**

• _Am I looking at a snapshot, or am I accounting for the system's history?_\[30\].

• _Am I forcing the system to operate too fast? Is there enough "slowness" or delay to allow memory and identity to form?_\[19\],\[31\].

• _Is the system too rigid (frozen) or too chaotic? Is it maintained in a critical state where it can adapt?_\[32\].

**4\. Questions on Ethics and Provisionality**

• _Am I justifying my actions in a way that prevents me from revising them later?_\[33\].

• _Does my intervention respect the "otherness" and difference within the system, or am I trying to enforce a single, homogenous logic?_\[34\].

• _Am I pretending to be objective to avoid taking responsibility for my choices?_\[35\].

**5\. The "Agonistic" Check**

• _Have I allowed for dissent and conflict within the investigation, or am I forcing a consensus that suppresses complexity?_\[36\],\[22\].

• _Am I entering the "agonistics of the network" (getting my hands dirty), or trying to control the system from a distance?_\[37\].

---
> [!info]- References
> [1] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [2] Cilliers 2010 - Difference Identity and Complexity.pdf
> [3] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [4] [Book] Cilliers - Critical Complexity (Categories).pdf
> [5] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [6] [Book] Cilliers - Critical Complexity (Categories).pdf
> [7] Cilliers 2010 - Difference Identity and Complexity.pdf
> [8] [Book] Cilliers - Critical Complexity (Categories).pdf
> [9] [Book] Cilliers - Complexity difference and identity.pdf
> [10] [Book] Cilliers - Critical Complexity (Categories).pdf
> [11] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [12] [Book] Cilliers - Critical Complexity (Categories).pdf
> [13] Cilliers 2010 - Difference Identity and Complexity.pdf
> [14] [Book] Cilliers - Critical Complexity (Categories).pdf
> [15] [Book] Cilliers - Critical Complexity (Categories).pdf
> [16] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [17] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [18] [Book] Cilliers - Critical Complexity (Categories).pdf
> [19] [Book] Cilliers - Critical Complexity (Categories).pdf
> [20] [Book] Cilliers - Critical Complexity (Categories).pdf
> [21] [Book] Cilliers - Critical Complexity (Categories).pdf
> [22] [Book] Cilliers - Critical Complexity (Categories).pdf
> [23] [Book] Cilliers - Critical Complexity (Categories).pdf
> [24] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [25] [Book] Cilliers - Critical Complexity (Categories).pdf
> [26] [Book] Cilliers - Critical Complexity (Categories).pdf
> [27] [Book] Cilliers - Critical Complexity (Categories).pdf
> [28] Cilliers 2010 - Difference Identity and Complexity.pdf
> [29] [Book] Cilliers - Critical Complexity (Categories).pdf
> [30] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [31] [Book] Cilliers - Critical Complexity (Categories).pdf
> [32] [Book] Cilliers - Critical Complexity (Categories).pdf
> [33] [Book] Cilliers - Complexity difference and identity.pdf
> [34] [Book] Cilliers - Critical Complexity (Categories).pdf
> [35] [Book] Cilliers - Critical Complexity (Categories).pdf
> [36] [Book] Cilliers - Critical Complexity (Categories).pdf
> [37] [Book] Cilliers - Critical Complexity (Categories).pdf


FILE: 'Peter Checkland.md'
---
exported: '2026-02-01T16:32:01.580Z'
source: NotebookLM
type: chat
title: Peter Checkland on 💬How To Guides
tags:
  - How-To
  - Methodology
  - Peter-Checkland
aliases:
  - SSM
author: Peter Checkland
---
Based on the provided sources, particularly the works of Peter Checkland, here is a guide for conducting a Soft Systems Methodology (SSM) investigation.

### **Overview: The Mindset**

SSM is not a recipe to be followed slavishly, but a methodology (a set of principles) for managing complex human situations\[1\]\[2\]. Unlike "hard" systems engineering, which assumes a clear problem and objective, SSM assumes the world is complex and ill-defined. You are not modelling the "real world"; you are building intellectual models (systems) to use as tools to **question** the real world and learn your way toward improvement\[3\]\[4\].

An SSM investigation typically moves through four main phases: Finding Out, Modelling, Comparison/Debate, and Taking Action\[5\].

\--------------------------------------------------------------------------------

### **Phase 1: Finding Out (Entering the Situation)**

Your goal is to understand the "flux of events and ideas" without immediately imposing a rigid structure. You must analyze both the problem content and the intervention itself.

**1\. Create "Rich Pictures"**Draw the situation rather than just writing about it. Capture the structures, processes, conflict, and "climate" of the situation\[6\].

• _Action:_ Draw a cartoon-like representation showing the main stakeholders, their concerns, the layout of the situation, and the relationships (and conflicts) between them\[7\].

**2\. Perform "Analysis One" (The Intervention)**Analyze the roles involved in the project itself\[8\]\[9\].

• **The Client:** Who caused the study to happen?

• **The Practitioner:** Who is conducting the investigation?

• **The Issue Owners:** Who is concerned about or affected by the situation and its outcome? (Note: A person can occupy more than one role).

**3\. Perform "Analysis Two" (Social System)**Understand the culture by looking at its three interacting elements\[10\]\[11\]:

• **Roles:** What are the recognized social positions here?

• **Norms:** What is the expected behavior for these roles?

• **Values:** What standards are used to judge behavior as "good" or "bad"?

**4\. Perform "Analysis Three" (Political System)**Understand how power is exercised\[6\]\[12\].

• _Question:_ How is power generated, preserved, and used in this situation?

• _Question:_ What are the "commodities" of power (e.g., formal authority, charisma, access to information)?

\--------------------------------------------------------------------------------

### **Phase 2: Systems Thinking (Modelling)**

You now leave the "real world" temporarily to build logical models of _purposeful activity_. These are "ideal types" to be used for comparison later, not descriptions of what is actually happening\[13\].

**1\. Select "Relevant Systems"**Choose perspectives (worldviews) that might offer insight. You should ideally model both:

• **Primary Task Systems:** Systems that map onto institutional boundaries (e.g., "A system to manufacture cars")\[14\]\[15\].

• **Issue-Based Systems:** Systems relevant to a debate or concern (e.g., "A system to resolve conflict between sales and production")\[15\]\[16\].

**2\. Formulate "Root Definitions" (RDs)**For each relevant system, write a concise statement of what the system _is_\[6\]. Use the **PQR formula** to structure it:

• **Do P** (What to do?)

• **By Q** (How to do it?)

• **In order to contribute to R** (Why do it/Longer-term aim?)\[17\]\[18\].

**3\. Apply the CATWOE Checklist**Test your Root Definition by asking these six questions\[17\]:

• **C (Customers):** Who are the victims or beneficiaries of this system?

• **A (Actors):** Who would carry out the activities?

• **T (Transformation):** What input is transformed into what output? (Ensure you are transforming an _entity_, e.g., "Unpainted fence" -> "Painted fence", not just an action)\[21\].

• **W (Weltanschauung):** What worldview makes this system meaningful? (Why is this T worth doing?)

• **O (Owners):** Who could stop or abolish this system?

• **E (Environmental Constraints):** What external constraints does the system take as given?

**4\. Build the Conceptual Model**Draw the activities (verbs) necessary to carry out the Root Definition. Structure them logically (what must be done before what?)\[22\].

• _Guideline:_ Aim for 7 ± 2 main activities\[23\].

• _Add Monitoring:_ Add a monitoring and control sub-system based on the **3 Es**\[15\]\[24\]:

    ◦ **Efficacy:** Does the means work? (Is the transformation produced?)    ◦ **Efficiency:** Is it done with minimum resources?    ◦ **Effectiveness:** Does it help achieve the longer-term goal (the R in PQR)?
\--------------------------------------------------------------------------------

### **Phase 3: Comparison and Debate**

Bring the models back to the "real world" to structure a discussion. The goal is not to force the real world to match the model, but to use the difference to learn\[13\].

**The Questions to Ask (The Matrix Method)**Create a chart where the model's activities are on one side and questions are on the other. For each activity in your model, ask the following of the real situation\[25\]\[26\]:

1\. **Does this activity (or relationship) exist in the real situation?**

2\. **How is it done at present?**

3\. **Who does it?**

4\. **How is it judged?** (What are the current criteria?)

5\. **Is it a source of concern?** (Is it regarded as well done?)

Alternatively, ask: "If this model were a description of the real world, how would it differ from what we actually see?"\[27\].

\--------------------------------------------------------------------------------

### **Phase 4: Taking Action**

The debate should lead to ideas for change. In SSM, a change must meet two criteria to be successful\[28\]\[29\]:

1\. **Systemically Desirable:** It makes sense logically (derived from the systems analysis).

2\. **Culturally Feasible:** It can actually be implemented given the specific people, history, and culture of this situation.

**Types of Change to Consider:**

• Changes to **Structure** (organizational groupings, reporting lines).

• Changes to **Process** (procedures, how things are done).

• Changes to **Attitude** (values, norms, expectations)\[30\].

Once changes are implemented, the situation is altered, and the cycle of learning begins again\[28\].

---
> [!info]- References
> [1] Checkland - SSM in encylopedia of operations research.pdf
> [2] [Book] Checkland - Learning for Action.pdf
> [3] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf
> [4] [Book] Checkland - 1981 - Systems thinking, systems practice - J. Wiley.pdf
> [5] [Book] Checkland - Learning for Action.pdf
> [6] An Appreciative Critique and Refinement of Checklands Soft Systems Methodology.pdf
> [7] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [8] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [9] [Book] Checkland - Learning for Action.pdf
> [10] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [11] [Book] Checkland,Scholes - 1990 - Soft systems methodology in action - Wiley.pdf
> [12] [Book] Checkland - Learning for Action.pdf
> [13] An Appreciative Critique and Refinement of Checklands Soft Systems Methodology.pdf
> [14] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf
> [15] Checkland 2011 - Systems Thinking and Soft Systems Mehthodology.pdf
> [16] Checkland 1997 - Reflecting on SSM the link between Root Definitions and Conceptual Models.pdf
> [17] Checkland 2011 - Systems Thinking and Soft Systems Mehthodology.pdf
> [18] [Book] Checkland - Learning for Action.pdf
> [21] Checkland 1997 - Reflecting on SSM the link between Root Definitions and Conceptual Models.pdf
> [22] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf
> [23] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [24] An Appreciative Critique and Refinement of Checklands Soft Systems Methodology.pdf
> [25] [Book] Checkland,Scholes - 1990 - Soft systems methodology in action - Wiley.pdf
> [26] [Book] Checkland - Learning for Action.pdf
> [27] [Book] Checkland,Scholes - 1990 - Soft systems methodology in action - Wiley.pdf
> [28] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [29] [Book] Checkland,Scholes - 1990 - Soft systems methodology in action - Wiley.pdf
> [30] Checkland - SSM in encylopedia of operations research.pdf


FILE: 'Peter Senge.md'
---
exported: 2026-02-07T15:53:27.915Z
source: NotebookLM
type: chat
title: Peter Senge on 💬How To Guides
tags:
  - Peter-Senge
  - How-To
author: Peter Senge
---
Based on the "Fifth Discipline" framework developed by Peter Senge and colleagues, an investigation into a complex problem requires a fundamental "shift of mind" (metanoia). You must move away from linear, static thinking—which focuses on isolated events and blaming individuals—toward systems thinking, which focuses on interconnected wholes, long-term patterns, and underlying structures\[1\].

Here is a guide for conducting a Fifth Discipline investigation, structured by the necessary shifts in thinking and the specific questions to ask at each stage.

### Phase 1: Preparation (Shifting the Mindset)

Before analyzing the external problem, you must investigate your own lens and the team's ability to see reality clearly. The core principle here is that "structure influences behavior"—problems are rarely caused by incompetent individuals or external enemies, but by the design of the system itself\[4\]\[5\].

**Key Concepts to Apply:**

• **No Blame:** Recognize that "there is no outside"—you and the cause of your problems are part of a single system\[6\]\[7\]. Blame is a learning disability\[8\].

• **The Left-Hand Column:** Use this tool to surface hidden assumptions preventing honest investigation. Write out a dialogue on the right side of a page, and on the left, write what you were thinking but not saying\[9\]\[10\].

**Questions to Ask Yourself:**

• _Am I operating under the illusion that "the enemy is out there"?_\[8\]

• _How do my own actions and ways of thinking contribute to the problems I am experiencing?_\[11\]\[12\]

• _What am I thinking but not saying about this issue? (Using the Left-Hand Column)_\[9\].

• _Am I selecting specific data to fit my beliefs and ignoring other data? (Ladder of Inference)_\[13\]\[14\].

### Phase 2: Mapping the Reality (Events vs. Structure)

A Fifth Discipline investigation requires looking at reality at three distinct levels. Most organizations focus only on the first level (Events), which leads to reactive "quick fixes"\[15\]\[16\]. You must drill down to the generative level.

**The Three Levels of Investigation:**

1\. **Events:** What just happened? (Reactive)

2\. **Patterns of Behavior:** What has been happening over time? (Responsive)

3\. **Systemic Structure:** What are the generative forces causing these patterns? (Generative)\[16\]\[17\].

**Questions to Ask:**

• _Is this an isolated event, or part of a long-term trend?_\[18\]

• _What are the patterns of behavior over time? (e.g., Are we seeing an oscillation, or a boom-and-bust cycle?)_\[19\]\[20\].

• _What causes the patterns of behavior?_\[18\]

• _Are we reacting to sudden changes while missing slow, gradual threats? (The "Boiled Frog" syndrome)_\[21\].

### Phase 3: Identifying the Systemic Structure (Using Archetypes)

To understand the structure, you must identify the feedback loops—circles of causality—rather than straight lines of cause and effect\[22\]\[23\]. You can use **Systems Archetypes** (common recurring patterns) to diagnose the situation\[24\]\[25\].

**Step A: Identify the Loops**

• **Reinforcing Loops:** Engines of growth or decline (e.g., word of mouth, snowball effects)\[26\]\[27\].

• **Balancing Loops:** Goal-oriented behavior that seeks stability or limits growth\[26\]\[28\].

• **Delays:** Interruptions in the flow of influence which make consequences occur gradually and often cause leaders to overshoot their targets\[29\]\[30\].

**Step B: Match the Situation to an Archetype**Here are questions to ask to see if your problem fits a specific archetype:

**1\. Limits to Growth**_Structure:_ A process grows for a period, then bumps up against a constraint (internal or external) and slows or collapses\[31\]\[32\].

• _What is the "growing action" or engine of success?_\[33\]

• _What is the limiting condition or factor slowing us down (e.g., management capacity, market size, morale)?_\[32\]\[34\]

• _Are we pushing harder on the growth engine (which will fail) rather than removing the limiting factor?_\[32\]\[35\]

**2\. Shifting the Burden**_Structure:_ A short-term "symptomatic solution" is used to fix a problem, which relieves immediate pressure but obscures the fundamental problem, causing the fundamental solution to atrophy\[36\]\[37\].

• _What is the "problem symptom" that demands attention (e.g., stress, falling sales)?_\[38\]

• _What is the "symptomatic solution" or quick fix we are applying?_\[38\]

• _What is the "fundamental solution" that takes longer but solves the root cause?_\[38\]

• _Are there negative side effects of the quick fix that are making the fundamental solution harder to achieve (e.g., addiction to consultants, erosion of internal skills)?_\[39\]\[40\]

**3\. Tragedy of the Commons**_Structure:_ Individuals use a commonly available limited resource based on individual need, eventually depleting the resource for everyone\[41\]\[42\].

• _What is the "commons" (resource, energy, budget, customer attention) that is being depleted?_\[43\]\[44\]

• _What specific actions by local departments are leading to depleting this resource?_\[44\]

### Phase 4: Determining Leverage (Intervention)

The goal of the investigation is to find "leverage"—small, well-focused actions that produce significant, enduring improvements\[7\]\[45\].

**Key Principles:**

• **Faster is Slower:** Avoid pushing harder on the system; it will often push back\[6\]\[46\].

• **The Easy Way Out Leads Back In:** If the solution is obvious and familiar, it is likely a non-systemic "quick fix"\[6\]\[47\].

• **Avoid Symptomatic Solutions:** Leverage usually requires weakening the symptomatic solution and strengthening the fundamental solution\[7\]\[48\].

**Questions to Ask:**

• _Where is the high leverage? (Often the least obvious place)_\[6\]\[45\].

• _Are we solving the problem or just shifting it to another part of the system?_\[6\]

• _Does our solution strengthen the ability of the system to shoulder its own burdens in the future?_\[46\]

• _Are we ignoring a delay between our action and the system's response?_\[30\]

### Phase 5: Assessing the "Water" (The Six Conditions)

For a holistic investigation, you must look at the explicit and implicit conditions holding the problem in place. This is often referred to as "seeing the water"\[49\]\[50\].

**Questions to Ask across the Three Levels of Systems Change:**

1\. **Structural Change (Explicit):**

    ◦ _What policies, rules, or regulations are guiding our actions?_\[51\]    ◦ _How are resources (money, people, time) flowing?_\[52\]
2\. **Relational Change (Semi-Explicit):**

    ◦ _What are the power dynamics and decision-making authority structures?_\[53\]    ◦ _What is the quality of relationships and connections among the actors in the system?_\[52\]
3\. **Transformative Change (Implicit):**

    ◦ _What are the mental models (deeply held beliefs/assumptions) influencing how we think and talk?_\[53\]\[54\]    ◦ _Are our mental models (e.g., regarding race, gender, or hierarchy) limiting our ability to solve this problem?_\[55\]
### Summary Checklist for Inquiry

When discussing these issues with your team, Senge recommends balancing **advocacy** (stating your view) with **inquiry** (asking about others' views)\[56\]. Use these prompts during your investigation:

• _"Here is my view and how I arrived at it. How does it sound to you?"_\[57\]

• _"Do you see gaps in my reasoning?"_\[58\]

• _"Do you have different data or different conclusions?"_\[58\]

• _"Am I creating a defensive routine to avoid facing difficult truths?"_\[59\]\[60\]

---
> [!info]- References
> [1] peter_senge_the_fifth_discipline1.pdf
> [4] peter_senge_the_fifth_discipline1.pdf
> [5] peter_senge_the_fifth_discipline1.pdf
> [6] 11 Laws of Systems Thinking Peter Senge with references.pdf
> [7] 2022_11_28_15_32_00.pdf
> [8] peter_senge_the_fifth_discipline1.pdf
> [9] 2022_11_28_15_32_00.pdf
> [10] peter_senge_the_fifth_discipline1.pdf
> [11] Winter_2015_The_Dawn_of_System_Leadership.pdf
> [12] peter_senge_the_fifth_discipline1.pdf
> [13] Senge - Mr Learning Organisation.pdf
> [14] Senge - Mr Learning Organisation.pdf
> [15] 2022_11_28_15_32_00.pdf
> [16] peter_senge_the_fifth_discipline1.pdf
> [17] 2022_11_28_15_32_00.pdf
> [18] 2022_11_28_15_32_00.pdf
> [19] peter_senge_the_fifth_discipline1.pdf
> [20] peter_senge_the_fifth_discipline1.pdf
> [21] peter_senge_the_fifth_discipline1.pdf
> [22] peter_senge_the_fifth_discipline1.pdf
> [23] peter_senge_the_fifth_discipline1.pdf
> [24] 2022_11_28_15_32_00.pdf
> [25] peter_senge_the_fifth_discipline1.pdf
> [26] peter_senge_the_fifth_discipline1.pdf
> [27] peter_senge_the_fifth_discipline1.pdf
> [28] peter_senge_the_fifth_discipline1.pdf
> [29] peter_senge_the_fifth_discipline1.pdf
> [30] peter_senge_the_fifth_discipline1.pdf
> [31] 2022_11_28_15_32_00.pdf
> [32] peter_senge_the_fifth_discipline1.pdf
> [33] peter_senge_the_fifth_discipline1.pdf
> [34] peter_senge_the_fifth_discipline1.pdf
> [35] peter_senge_the_fifth_discipline1.pdf
> [36] 2022_11_28_15_32_00.pdf
> [37] peter_senge_the_fifth_discipline1.pdf
> [38] peter_senge_the_fifth_discipline1.pdf
> [39] peter_senge_the_fifth_discipline1.pdf
> [40] peter_senge_the_fifth_discipline1.pdf
> [41] 2022_11_28_15_32_00.pdf
> [42] peter_senge_the_fifth_discipline1.pdf
> [43] peter_senge_the_fifth_discipline1.pdf
> [44] peter_senge_the_fifth_discipline1.pdf
> [45] peter_senge_the_fifth_discipline1.pdf
> [46] peter_senge_the_fifth_discipline1.pdf
> [47] peter_senge_the_fifth_discipline1.pdf
> [48] peter_senge_the_fifth_discipline1.pdf
> [49] Senge - The Water of Systems Change.pdf
> [50] Senge - The Water of Systems Change.pdf
> [51] Senge - The Water of Systems Change.pdf
> [52] Senge - The Water of Systems Change.pdf
> [53] Senge - The Water of Systems Change.pdf
> [54] Senge - The Water of Systems Change.pdf
> [55] Senge - The Water of Systems Change.pdf
> [56] 2022_11_28_15_32_00.pdf
> [57] peter_senge_the_fifth_discipline1.pdf
> [58] 2022_11_28_15_32_00.pdf
> [59] 2022_11_28_15_32_00.pdf
> [60] peter_senge_the_fifth_discipline1.pdf


FILE: 'Reg Revans.md'
---
exported: '2026-02-01T16:04:26.129Z'
source: NotebookLM
type: chat
title: Reg Revans on 💬How To Guides
tags:
  - How-To
  - Methodology
  - Reg-Revans
aliases:
  - Action Learning
author: Reg Revans
---
Based on the sources, an action learning investigation is a moral philosophy and practical method designed to solve **"wicked problems"**—intractable challenges where no single right answer exists and where experts cannot provide a recipe for success\[1\].

This guide outlines the stages of an investigation and the specific questions required to navigate conditions of **"ignorance, risk, and confusion"**\[4\].

### Phase 1: Scoping the Challenge

Before beginning, the investigator must distinguish between a **Puzzle** and a **Problem**.

• **The Puzzle:** A conundrum with an existing solution that can be solved by experts using **Programmed Knowledge (P)**\[3\].

• **The Problem:** A situation where reasonable, experienced people may advocate different courses of action\[3\]\[7\]. This requires **Questioning Insight (Q)**\[9\]\[10\].

**The Starting Mindset:** You must **admit ignorance**\[4\]\[5\]. Learning begins only when one acknowledges being lost or stuck and is willing to search for fresh questions\[4\]\[11\].

### Phase 2: Organizing the Investigation

Action learning is a social process and cannot be done in isolation\[12\].

1\. **Form the "Set":** Gather a group of **4 to 6 "comrades in adversity"**\[13\]. These are peers who meet regularly to offer criticism, advice, and support\[12\]\[13\].

2\. **Assign Roles:**

    ◦ **The Participant:** The person responsible for the real-life task\[16\]\[17\].    ◦ **The Sponsor:** A senior representative of the organization who can act if unexpected needs arise\[18\].    ◦ **The Client:** The person most concerned with ensuring the project's success and providing a fair trial for recommendations\[16\].    ◦ **Avoid Dependency:** Be wary of **"ambiguous facilitators"** or experts; the set should achieve independence as quickly as possible to ensure self-reliance\[19\]\[20\].
### Phase 3: The Diagnostic Inquiry

The investigation must constantly revisit three **"primary interrogations"** to move from confusion to a strategic plan\[21\]:

• **"What are we really trying to do?"** (Identifying the goal or utility)\[21\].

• **"What is stopping us from doing it?"** (Identifying the constraints or state of nature)\[21\].

• **"What can we do about it?"** (Identifying feasible actions)\[21\].

### Phase 4: Recruiting the Client Group

Very little can be achieved without allies\[25\]. To implement a strategy, the participant must recruit a **"Client Group" (structure d'accueil)** by asking three logistical questions\[17\]:

• **"Who knows about (understands) the problem?"**\[17\].

• **"Who cares about (genuinely wants something done) about the problem?"**\[17\].

• **"Who can (has enough power to) get something useful done about it?"**\[17\].

### Phase 5: The Action Cycle (System Beta)

The investigation follows a six-stage cycle modeled on the **scientific method**\[26\]. Each stage is defined by internal questions or goals\[29\]:

1\. **Analysis:** Narrowing the confusion. **"What am I trying to do?"**\[29\]\[31\].

2\. **Development:** Finding "paper answers" or hypotheses. **"This seems worth giving a trial"**\[29\]\[31\].

3\. **Procurement:** Marshaling support and resources. **"Can I get the backing needed?"**\[29\]\[31\].

4\. **Assembly:** Bringing resources together. **"It ought to be possible to organize it like this"**\[30\]\[31\].

5\. **Implementation:** Taking action in the field. **"Those involved are bound to make it go"**\[30\]\[31\].

6\. **Review:** Comparing outcomes against predictions\[28\]. This stage acts as a **"forced draught,"** obliging participants to open their intentions to the criticism of others\[32\].

### Phase 6: Reflection and Self-Development

Because organizational change is impossible without personal change (the **Principle of Insufficient Mandate**), the investigation must conclude with moral self-scrutiny\[33\]. The most valuable questions learned in a set are often\[36\]:

• **"What is an honest man?"**\[36\].

• **"What need I do to become one?"**\[36\].

### Summary of Key Principles

• **Risk Imperative:** There is no learning without the **risk of penalty for failure**\[39\]\[40\].

• **Verification:** New perceptions must be checked against **real-world reality**, not just discussed in a seminar room\[41\].

• **Adaption vs. Learning:** In changing contexts, we are often **"adapting"** (acquiring knowledge through insight and intuition) rather than merely **"learning"** (acquiring knowledge in an invariant context)\[44\]\[45\].

---
> [!info]- References
> [1] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [3] [Book] Revans - ABC of Action Learning.pdf
> [4] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [5] Revans 1981 Management productivity and risk - the way ahead.pdf
> [7] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [9] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [10] [Book] Revans - ABC of Action Learning.pdf
> [11] [Book] Revans - ABC of Action Learning.pdf
> [12] [Book] Revans - ABC of Action Learning.pdf
> [13] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [16] [Book] Revans - ABC of Action Learning.pdf
> [17] [Book] Revans - ABC of Action Learning.pdf
> [18] [Book] Revans - ABC of Action Learning.pdf
> [19] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [20] [Book] Revans - ABC of Action Learning.pdf
> [21] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [25] [Book] Revans - ABC of Action Learning.pdf
> [26] Revans 1981 Management productivity and risk - the way ahead.pdf
> [28] revans 1984 - action learning are we getting there.pdf
> [29] revans 1984 - action learning are we getting there.pdf
> [30] revans 1984 - action learning are we getting there.pdf
> [31] revans 1984 - action learning are we getting there.pdf
> [32] revans 1984 - action learning are we getting there.pdf
> [33] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [36] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [39] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [40] [Book] Revans - ABC of Action Learning.pdf
> [41] [Book] Revans - ABC of Action Learning.pdf
> [44] smith 1997 - revans action learning explained.pdf
> [45] smith 1997 - revans action learning explained.pdf


FILE: 'Relational Biologists.md'
---
exported: '2026-02-02T04:33:11.135Z'
source: NotebookLM
type: chat
title: Relational Biologists on 💬How To Guides
tags:
  - How-To
  - NoMethodology
author: Relational Biologists
---
Based on the provided sources, the specific term "chaordic" (a portmanteau of chaos and order often associated with Dee Hock) does not explicitly appear. However, the sources extensively detail the investigation of systems that exist at the intersection of **stochasticity/instability** (chaos) and **constraints/control** (order).

The following "how-to guide" constructs a method for investigating such systems, drawing primarily from Denis Noble’s work on harnessing stochasticity, Howard Pattee’s theories on constraints and instabilities, and Robert Rosen’s work on complexity and modeling.

### **Guide to a Chaordic Investigation: Harnessing Stochasticity and Order**

A "chaordic" investigation in this context requires analyzing how a system uses fixed rules (order) to harness random or unstable dynamics (chaos) to achieve a function.

**Phase 1: Define the Boundaries (The Epistemic Cut)**

Before investigating the dynamics, you must establish what constitutes the system versus its environment.

• **Determine the "Cut":** You must distinguish between the observer (or the controlling agent) and the system being observed/controlled. This is the **epistemic cut**. Without this separation, you cannot distinguish a measurement or a control from a mere physical interaction\[1\]\[2\].

• **Identify the System Type:** Is the system "simple" (a mechanism where all models are simulable) or "complex" (containing closed causal loops)?\[3\]\[4\].

**Questions to Ask:**

1\. Where is the boundary between the system and its environment? (Note: Functional boundaries may be "fuzzy" and distinct from anatomical ones)\[5\].

2\. Is the system "open"? Does it exchange matter and energy with the environment across this boundary?\[6\].

3\. Are we treating the system as a "closed" model (abstracting away degrees of freedom) while the real system remains open to unmodeled interactions?\[7\]\[8\].

**Phase 2: Identify the Sources of "Chaos" (Stochasticity and Instability)**

You must identify the sources of variability. In this framework, chaos/stochasticity is not merely "noise" to be eliminated, but a necessary resource for creativity and choice.

• **Locate Instabilities:** Look for areas where the system is statistically unstable. Instabilities serve as "escape hatches" from deterministic dynamics, allowing the system to generate new structures or behaviors\[9\].

• **Distinguish Stochasticity from Deterministic Chaos:** Determine if the variation is generated by a determinate algorithm (chaos) or true randomness (stochasticity). For biological choice, this difference may not matter if the variation appears random to the choice process\[10\].

**Questions to Ask:**

1\. Where does the system exhibit unpredictable behavior? Is this due to "molecular stochasticity" (Brownian motion) or quantum randomness?\[11\]\[12\].

2\. Is the system "harnessing" this stochasticity? Is the noise being used to generate a repertoire of possible solutions?\[13\].

3\. Are there "singularities" or "instabilities" where small unobservable causes produce observable effects?\[14\].

**Phase 3: Identify the Structures of "Order" (Constraints and Codes)**

Order in these systems is maintained by **constraints** (often symbolic or linguistic) that limit and direct the underlying dynamics.

• **Find the Constraints:** Look for "non-holonomic" (flexible/rate-dependent) constraints. These are local structures (like enzymes or traffic lights) that control the rates of events without being determined by the fundamental laws of motion\[15\]\[16\].

• **Identify the Code:** Look for a "code" or "language"—a set of rules that relates a symbol (description) to a physical action. These rules are often arbitrary (like driving on the right side of the road) and cannot be derived from physics alone\[17\]\[18\].

**Questions to Ask:**

1\. What are the "frozen accidents" or rules that limit the system's behavior?\[17\]\[19\].

2\. Is there a "description" (like DNA or a policy) separate from the "construction" (the organism or the action)?\[20\]\[21\].

3\. How does the system "harness" physical laws? (e.g., How does a genetic sequence constrain the folding of a protein?)\[22\].

**Phase 4: Analyze the "Choice Process" (The Chaordic Mechanism)**

This is the core operational phase. According to Denis Noble and Raymond Noble, organisms utilize a specific process to transform disordered stochasticity into ordered, rational action. This serves as the template for your investigation.

**The 5-Step Inquiry (Based on Noble’s Choice Process)**\[23\]**:**

1\. **The Situation:** What environmental and historical conditions have defined the current problem? (View this as a "template" or puzzle to be solved).

2\. **The Disengagement:** Does the system decouple from automatic/reflexive control to allow for a period of "free-wheeling"? (This allows stochasticity to generate options).

3\. **The Generation:** How does the system increase variability? (e.g., the immune system increasing mutation rates to find an antibody).

4\. **The Selection:** What is the "comparator"? How does the system compare the stochastic results against the problem template to see what "fits"?

5\. **The Implementation:** Once a fit is found, how does the system lock in this choice and return to direct control?

**Questions to Ask:**

• Does the system exhibit a "puzzled state" where no solution is immediately apparent?\[26\].

• Is the resulting behavior rational in retrospect (it fits the problem) but unpredictable in prospect (generated stochastically)?\[25\].

**Phase 5: Evaluate System Health and Failure (Error)**

Finally, assess how the system manages the discrepancy between its internal order (models) and the external chaos (reality).

• **Detecting Error:** Error is defined as the bifurcation or discrepancy between what the system's model predicts and what actually happens in the open environment\[27\]\[28\].

• **Anticipation:** Does the system contain a predictive model of itself or its environment? Does it change its current behavior based on a predicted future?\[29\]\[30\].

**Questions to Ask:**

1\. Is the system experiencing "side effects"? (These occur when the real system interacts with the environment in ways the internal model did not account for)\[8\].

2\. Is the system "disordering"? (Is the deviation between the model's expectations and the system's actual behavior growing over time?)\[31\]\[32\].

3\. Is the system "senescent"? Has the model become so out of sync with the changing environment that the system can no longer compensate?\[33\].

### **Summary Checklist for the Investigator**

• **\[ \]****Define the Cut:** Separate the Knower (Subject) from the Known (Object)\[1\].

• **\[ \]****Locate the Chaos:** Find the source of stochasticity/instability\[9\].

• **\[ \]****Locate the Order:** Find the constraints/rules/codes\[18\].

• **\[ \]****Trace the Choice:** Map the process of Template → Stochastic Variation → Selection → Action\[23\].

• **\[ \]****Measure the Gap:** Identify errors/side-effects as the divergence between the model and reality\[34\].

---
> [!info]- References
> [1] Howard Pattees Theoretical biology a radical epistemological stance to approach life evolution and complexity.pdf
> [2] Irreducible and complementary semiotic - Howard Pattee.pdf
> [3] [Book] Rosen - Essays on Life Itself.pdf
> [4] [Book] Rosen - Essays on Life Itself.pdf
> [5] Noble - Biological circular causality but not symmetry of causation so where what and when are the boundaries.pdf
> [6] Noble - Biological circular causality but not symmetry of causation so where what and when are the boundaries.pdf
> [7] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [8] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [9] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [10] Noble - Harnessing stochasticity how do organisms make choices.pdf
> [11] Noble - Biological circular causality but not symmetry of causation so where what and when are the boundaries.pdf
> [12] Noble - Harnessing stochasticity how do organisms make choices.pdf
> [13] Noble - Harnessing stochasticity how do organisms make choices.pdf
> [14] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [15] Pattee - Physical Basis and Origin of HierarchicaL Control.pdf
> [16] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [17] Pattee - Physical Basis and Origin of HierarchicaL Control.pdf
> [18] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [19] Pattee - The Physical Basis and Origin of Hierarchical Control.pdf
> [20] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [21] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [22] Pattee Irreducible and complementary semiotic forms.pdf
> [23] Noble - Harnessing stochasticity how do organisms make choices.pdf
> [25] Noble - Harnessing stochasticity how do organisms make choices.pdf
> [26] Noble - Harnessing stochasticity how do organisms make choices.pdf
> [27] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [28] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [29] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [30] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [31] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [32] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [33] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [34] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf


FILE: 'Robert Flood.md'
---
exported: '2026-02-01T15:57:24.423Z'
source: NotebookLM
type: chat
title: Robert Flood on 💬How To Guides
tags:
  - How-To
  - Methodology
  - Robert-Flood
aliases:
  - TSI
author: Robert Flood
---
This guide for conducting a systems thinking investigation is based on the meta-methodology of **Total Systems Intervention (TSI)**, which coordinates various systems approaches to tackle "messes"—sets of interacting problems\[1\]\[2\].

### **Phase 1: Creativity (Exploring the Context)**

The initial task is to use **systemic metaphors** to think creatively about the organization and its issues\[3\]\[4\]. Instead of assuming a single problem exists, you should view the situation through different "lenses" to see which captures the most significant features\[5\]\[6\].

• **Questions to ask:**

    ◦ Does the organization currently function like a **machine** (routine, repetitive, efficient parts) or an **organism** (adapting to a changing environment)?\[7\]\[8\]    ◦ Could it be seen as a **brain** (focused on learning and information processing) or a **culture** (driven by shared values and beliefs)?\[9\]\[10\]    ◦ Is there a **political** dimension involving a "coalition" of stakeholders with different interests?\[11\]\[12\]
• **Technique:** Develop **"Rich Pictures"**—cartoon-like representations that capture the "climate" of the situation, including conflicts and interesting features, without imposing an initial structure\[13\].

### **Phase 2: Defining Boundaries and Logic Levels**

Before choosing a solution, you must determine the **logic level** of the inquiry and the ethical boundaries of the "system"\[16\]\[17\].

• **Questions to ask (from Critical Systems Heuristics):**\[18\]\[19\]

    ◦ **Motivation:** Who is/ought to be the **client** (the beneficiary)? What is/ought to be the **measure of success**?    ◦ **Control:** Who is/ought to be the **decision taker**? What components are actually controlled by them?    ◦ **Expertise:** Who is/ought to be the **designer**? What kind of expertise is being used?    ◦ **Legitimation:** Who represents the **witnesses** (those affected but not involved in the design)?\[20\]\[21\]
• **Logic Check:** Are we dealing with a "real-world" operational problem (Level 1), a scientific modeling problem (Level 2), or an epistemological "metaproblem" regarding how we think about the issue (Level 3)?\[22\]\[23\].

### **Phase 3: Choice (Selecting a Methodology)**

Using the **System of Systems Methodologies (SOSM)**, classify the problem context based on two dimensions: the system's complexity and the relationship between participants\[24\].

• **Questions to ask:**

    ◦ **Systems Dimension:** Is the system **Simple** (few elements, well-defined laws) or **Complex** (many interacting parts, probabilistic behavior)?\[28\]\[29\]    ◦ **Participants Dimension:** Are relationships **Unitary** (shared goals), **Pluralist** (differing values but compromise is possible), or **Coercive** (fundamental conflict and power imbalances)?\[30\]\[31\]
• **Strategic Choice:**

    ◦ **Simple-Unitary:** Use Operations Research or Systems Engineering to optimize efficiency\[32\].    ◦ **Complex-Unitary:** Use the **Viable System Model (VSM)** to diagnose organizational faults and ensure viability\[33\]\[34\].    ◦ **Complex-Pluralist:** Use **Soft Systems Methodology (SSM)** or Interactive Planning to facilitate debate and find accommodations\[35\].    ◦ **Simple-Coercive:** Use Critical Systems Heuristics (CSH) to expose the interests being served\[36\].
### **Phase 4: Implementation (Modeling and Change)**

If using a "soft" approach like SSM, you move through specific stages to propose changes\[37\].

• **Questions to ask (using the CATWOE mnemonic):**\[40\]

    ◦ **C (Customers):** Who are the victims or beneficiaries?    ◦ **A (Actors):** Who performs the activities?    ◦ **T (Transformation):** What input is being turned into what output?    ◦ **W (Weltanschauung):** What worldview makes this transformation meaningful?    ◦ **O (Owner):** Who could stop this system?    ◦ **E (Environment):** What constraints are taken as given?
• **Goal:** Build **Conceptual Models** of what the system _must do_ to satisfy the root definition, then compare these models to reality to identify **culturally feasible** and **systemically desirable** changes\[43\].

### **Phase 5: Reflection (The Triple Loop)**

Investigations must conclude with **Triple Loop Learning** to ensure the intervention was responsible and comprehensive\[47\]\[48\].

• **Questions to ask:**

    ◦ **Loop 1 (Efficiency):** Are we doing things right?\[48\]\[49\]    ◦ **Loop 2 (Purpose):** Are we doing the right things?\[48\]\[50\]    ◦ **Loop 3 (Power):** Is "rightness" buttressed by "mightiness," or who is being excluded from the dialogue?\[48\]

---
> [!info]- References
> [1] [Book] Flood - Dealing with Complexity An Introduction to the Theory and Application of Systems Science.pdf
> [2] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [3] [Book] Flood - Dealing with Complexity An Introduction to the Theory and Application of Systems Science.pdf
> [4] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [5] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [6] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [7] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [8] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [9] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [10] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [11] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [12] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [13] Flood - System Thinking - Action Research.pdf
> [16] [Book] Gigch - Metadecisions Rehabilitating Epistemology.pdf
> [17] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [18] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [19] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [20] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [21] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [22] [Book] Gigch - Metadecisions Rehabilitating Epistemology.pdf
> [23] [Book] Gigch - Metadecisions Rehabilitating Epistemology.pdf
> [24] A matruing of systems thinking Barton Emery Flood et al.pdf
> [28] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [29] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [30] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [31] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [32] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [33] [Book] Flood - Dealing with Complexity An Introduction to the Theory and Application of Systems Science.pdf
> [34] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [35] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [36] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [37] A matruing of systems thinking Barton Emery Flood et al.pdf
> [40] Flood - System Thinking - Action Research.pdf
> [43] Flood - System Thinking - Action Research.pdf
> [47] Flood 1996 - Contours of diversity managmeent and triple loop learning.pdf
> [48] Flood Finnestrand - A mighty step criticial systemic interpretation of the Learning Organisation.pdf
> [49] Flood 1996 - Contours of diversity managmeent and triple loop learning.pdf
> [50] Flood 1996 - Contours of diversity managmeent and triple loop learning.pdf


FILE: 'Robert Pirsig.md'
---
exported: 2026-02-07T15:57:47.605Z
source: NotebookLM
type: chat
title: Robert Pirsig on 💬How To Guides
tags:
  - Robert-Pirsig
  - How-To
author: Robert Pirsig
---
Based on the writings of Robert Pirsig in the provided sources, specifically _Zen and the Art of Motorcycle Maintenance_ and _Lila_, an investigation is not merely a mechanical process of gathering data, but a dynamic engagement with "Quality" and "Value." Whether you are fixing a motorcycle, studying a culture, or solving an abstract problem, the process involves a mix of formal scientific rigor and an intuitive "feeling" for the situation.

Here is a guide to conducting an investigation, structured by the methodologies and philosophies found in the sources.

### **Part 1: The Mindset (Gumption)**

Before beginning the formal steps, you must establish the correct psychological state. Pirsig identifies "gumption" as the "psychic gasoline" essential for any investigation\[1\].

• **Cultivate "Peace of Mind":** An investigation requires an inner quietness. This is not just superficial calm, but a state where you do not separate yourself from the object of your study. If you are agitated or ego-driven, you will miss the subtle "nibbles" of new facts\[2\]\[3\].

• **Value "Stuckness":** In traditional investigations, getting stuck is seen as a failure. Pirsig argues that "stuckness" (the zero moment of consciousness) is actually the _starting point_ of true understanding. It indicates that your traditional patterns of thought have failed and you are ready to learn something new. Do not fear it; cultivate it\[4\]\[5\].

• **Avoid "Gumption Traps":** Be aware of internal blocks that drain your energy:

    ◦ **Value Rigidity:** The inability to see new facts because you are committed to old values (like the monkey trapped because it won't let go of the rice to free its hand). If you are rigid, you will stare right at the answer and not see it\[6\]\[7\].    ◦ **Ego:** A high evaluation of yourself isolates you from reality. If you are trying to look good rather than find the truth, you will be fooled\[8\].    ◦ **Anxiety:** Being so sure you will fail that you become fussy and make errors. Cure this by writing everything down to calm your mind\[9\]\[10\].    ◦ **Boredom:** This means you have lost the "Quality track" or "beginner's mind." Stop working, sleep, or turn the task into a ritual until interest returns\[11\]\[12\].    ◦ **Impatience:** This leads to anger and mistakes. Scale down your goals to the immediate task at hand\[13\].
### **Part 2: The Formal Method (The Notebook)**

For complex problems, you must formalize your thinking to prevent getting lost. Pirsig recommends keeping a lab notebook to force precision and clarity\[14\].

**The Six-Step Structure:**

1\. **Statement of the Problem:** State absolutely no more than you positively know. For example, instead of asking "What is wrong with the electrical system?", ask "What is wrong with the cycle?" if you haven't yet proven the electrical system is at fault\[15\].

2\. **Hypotheses:** List all possible causes for the problem. It is noted that the number of rational hypotheses can be infinite, so you must select the most likely ones based on Quality/Harmony\[15\].

3\. **Experiments:** Design tests for each hypothesis. A true experiment is not a demonstration; it is a question put to nature where the answer is unknown\[18\]\[19\].

4\. **Predicted Results:** Write down what should happen if the hypothesis is true\[18\].

5\. **Observed Results:** Write down what actually happens. Be honest; nature does not cheat\[18\]\[20\].

6\. **Conclusions:** State only what the experiment has proved. If the horn honks, it proves the battery and horn work, not that the whole electrical system is perfect\[18\]\[21\].

**Using Logic:**

• **Induction:** Reason from particular observations to general conclusions (e.g., "The engine misfires on bumps, therefore bumps cause the misfire")\[22\].

• **Deduction:** Reason from general knowledge to predict specific observations (e.g., "The horn requires a battery; the battery is dead; therefore the horn will not work")\[23\].

### **Part 3: Advanced Concepts (Quality and Facts)**

Pirsig emphasizes that an investigation is not just about "objective" facts, because facts are preselected by the observer based on value.

• **Identify the "Static Filter":** We all have a cultural immune system or "static filter" that shuts out information that contradicts our worldview. Be aware that you might be ignoring data simply because it doesn't fit your preconceived patterns\[24\]\[25\].

• **Recognize "Mu":** When an experiment yields a result that is neither "yes" nor "no," Pirsig calls this a "Mu" answer (meaning "no thing" or "unask the question"). This is not a failure; it signifies that the context of your question is too small. You must enlarge your understanding of the situation\[26\]\[27\].

• **Dynamic vs. Static Quality:** Always distinguish between _Static Quality_ (rigid, established patterns, laws, and traditions) and _Dynamic Quality_ (the pre-intellectual cutting edge of reality, the source of new ideas). A good investigator uses Static patterns (the notebook, scientific method) to stabilize their work but remains open to Dynamic Quality (flashes of insight, anomalies) to move forward\[28\]\[29\].

### **Questions to Ask During an Investigation**

Based on the texts, here is a checklist of questions to guide your inquiry:

**Initial Setup:**

• "What is the precise problem?" (State only what is fundamentally known)\[15\].

• "Am I stuck?" (If yes, acknowledge it as a zero-moment of potential enlightenment)\[4\].

• "Do I have a specific hypothesis?" (If not, write down everything you know until one emerges)\[15\].

**Testing & Observing:**

• "Does this experiment test _only_ the hypothesis in question?"\[30\].

• "What are the predicted results versus the observed results?"\[18\].

• "Is the answer 'Mu'?" (Does the data refuse to fit a yes/no structure? Do I need to widen the context?)\[27\].

**Self-Check (Gumption & Value):**

• "Am I suffering from value rigidity?" (Am I staring at the answer but refusing to see it because it seems unimportant?)\[31\].

• "Does this solution have Quality?" (Does it provide peace of mind and harmony, or is it just a messy patch?)\[2\]\[32\].

• "Am I trying to prove how smart I am (Ego), or am I trying to fix the problem?"\[8\].

• "Am I rushing?" (If so, slow down. Impatience leads to mistakes)\[13\].

**Analyzing Data:**

• "Which facts are 'good' facts?" (Which facts recur? Which facts seem simple or harmonious?)\[17\]\[33\].

• "Am I filtering out data because it doesn't fit my cultural or intellectual map?" (The Cleveland Harbor Effect)\[24\]\[25\].

• "Is the 'truth' I am finding a static pattern, or is it a Dynamic opening to something new?"\[28\].

---
> [!info]- References
> [1] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [2] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [3] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [4] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [5] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [6] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [7] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [8] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [9] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [10] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [11] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [12] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [13] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [14] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [15] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [17] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [18] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [19] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [20] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [21] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [22] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [23] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [24] [Book] Pirsig - Lila an inquiry into morals.pdf
> [25] [Book] Pirsig - Lila an inquiry into morals.pdf
> [26] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [27] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [28] [Book] Pirsig - Lila an inquiry into morals.pdf
> [29] [Book] Pirsig - Lila an inquiry into morals.pdf
> [30] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [31] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [32] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [33] [Book] Pirsig - Zen and the art of Motor maintanance.pdf


FILE: 'Roger James.md'
---
exported: '2026-02-02T05:46:56.891Z'
source: NotebookLM
type: chat
title: Roger James on 💬How To Guides
tags:
  - How-To
  - NoMethodology
  - Roger-James
author: Roger James
---
Based on the provided sources, a "chaordic" investigation focuses on the **"Goldilocks Zone" of Organized Complexity**—the region between rigid order (stasis) and random chaos (disorganized complexity)\[1\],\[2\],\[3\]. This is the domain of "Middle Numbers," where systems are too complex for linear cause-and-effect but too organized for statistical averaging\[4\],\[5\].

Here is a how-to guide for conducting an investigation in this zone, drawing heavily on the principles of **Second-Order Cybernetics**, **Minimalist Intervention (James Wilk)**, and **Soft Systems Methodology (Checkland)** found in your materials.

\--------------------------------------------------------------------------------

### **Guide to Chaordic Investigation**

**Objective:** To move from a state of "disquiet" or "mess" to a state of understanding where a **minimalist intervention** (a nudge) can release the system into a new, desirable state\[6\],\[7\].

**Phase 1: The Second-Order Stance (Calibrating the Observer)**

Before investigating the system, you must investigate your own observation of it. Complexity is often a measure of the observer's lack of understanding, not just a property of the world\[8\],\[9\].

• **Principle:** "The system is the observation, not that which is being observed"\[10\].

• **Action:** Acknowledge your "Appreciative Settings" (values and norms)\[11\]. Realize you are constructing a model, not describing absolute truth.

• **The Check:** Are you looking at this through a lens of **mechanisms** (physics/laws) or **intentions** (people/rules)?\[12\].

**Phase 2: Diagnosis (Locating the System)**

Determine if the situation is actually a "chaordic" (Organized Complexity) problem.

• **The Weaver Partition Test:**

    ◦ Is it a **Clock**? (Organized Simplicity: predictable, few variables). _Action: Use Engineering._    ◦ Is it a **Cloud**? (Disorganized Complexity: billions of variables, averages). _Action: Use Statistics._    ◦ Is it a **System**? (Organized Complexity: "Middle Numbers," emergent behavior, organic). _Action: Use Systems Thinking._\[4\],\[2\].
• **The Wicked Problem Test:**

    ◦ Is there a definitive formulation? (If no -> Wicked)\[13\].    ◦ Is the solution True/False or Good/Bad? (If Good/Bad -> Wicked)\[13\].    ◦ Is there a stopping rule? (If no -> Wicked)\[13\].

**Phase 3: The Investigation (Flux and Constraint)**

This is the core of the chaordic method. You must abandon linear cause-and-effect ("What caused this?") and adopt **Negative Explanation** ("What constrains this?").

• **The Core Principle:** "Change is never caused... but rather 'released' by identifying and altering specific, often idiosyncratic, constraints"\[6\].

• **The "Spirograph" Metaphor:** Do not look for the "attractor" (the pen drawing the chaos); look for the **gears and rings** (the constraints) that limit where the pen _cannot_ go\[14\],\[15\].

• **The Inquiry:** You are looking for **constraints** (laws/barriers) and **controls** (rules/choices)\[16\],\[17\].

**The Questions to Ask (The "Negative" Interrogation):**

1\. **The Vickers Question:** "Why is the system doing _this_, rather than _something else_?"\[18\],\[19\].

2\. **The Ashby Question:** "What _might_ have happened, but did not?" (Identify what is being excluded)\[20\],\[19\].

3\. **The Wilk "Flux" Questions:**

    ◦ "What stops this from happening?"\[19\].    ◦ "How is it that the current state-of-affairs is the only state-of-affairs not currently prevented?"\[19\].    ◦ "What is actively maintaining this situation?"\[21\].    ◦ "What one thing can't you change, and why?"\[21\].

**Phase 4: Structuring the "Mess" (Abstraction)**

You cannot solve the problem in the real world directly; you must retreat to the abstract world to model it\[22\],\[23\].

• **Use Rich Pictures:** Draw the situation including culture, emotion, and conflict. Do not use formal logic yet; capture the "mess"\[24\],\[25\].

• **Apply CATWOE (for Purposeful Activity):**

    ◦ **C**ustomers: Who are the victims/beneficiaries?    ◦ **A**ctors: Who does the work?    ◦ **T**ransformation: What does the system _do_ (Input → Output)?    ◦ **W**eltanschauung: What worldview makes this system meaningful?    ◦ **O**wner: Who can stop it?    ◦ **E**nvironment: What constraints are taken as given?\[26\],\[27\].
• **Clean Language Questions (To clarify metaphors):**

    ◦ "What kind of X is that?"    ◦ "Is there anything else about...?"    ◦ "Where does X come from?"\[28\].

**Phase 5: The "Nudge" (Intervention)**

In a chaordic system, you cannot "fix" the parts to fix the whole. You must alter the **relationships** or **constraints** to allow the system to settle into a new equilibrium\[29\],\[30\].

• **Identify the "Leverage Point":** Look for the "Stone Bridge" effect—where stability comes from geometry (structure), not the glue. Can you remove a constraint so the system "topples" into a better state (like a Coke bottle)?\[31\].

• **Minimalist Intervention Questions:**

    ◦ "If I could give you a magic wand, what would you like to see changed?"\[32\].    ◦ "What is the _smallest_, most routine thing you do that, if changed, might ripple through the system?"\[21\].    ◦ "If an outsider were put in charge, what is the first thing they would change?"\[21\].
• **Transduction:** Convert your abstract insight back into a concrete instruction the system can understand\[33\],\[34\].

**Phase 6: Closure (The "Landing")**

Systems thinking fails if it stays in the clouds. You must return to the concrete world\[23\].

• **The Feasibility Check:** Is the proposed change "systemically desirable and culturally feasible"?\[35\].

• **The "Muddle Through":** Accept that you are not "solving" the problem once and for all. You are engaging in an iterative learning process\[36\],\[37\].

• **Action:** Implement the "nudge" and monitor the system's dynamic response (the "drift")\[38\],\[39\].

\--------------------------------------------------------------------------------

### **Summary Checklist for the Investigator**

1\. **Don't ask "What caused this?"**→**Ask "What constrains this?"**

2\. **Don't ask "How do I control it?"**→**Ask "Where is the leverage?"**

3\. **Don't look at the "Ant" (the chaotic behavior).**→**Look at the "Beach" (the environment/structure).**\[40\].

4\. **Don't try to specify the system in full detail.**→**Specify it only "somewhat," then ride the dynamics.**\[41\].

---
> [!info]- References
> [1] Perlite.pdf
> [2] Recent.pdf
> [3] Recent.pdf
> [4] Perlite.pdf
> [5] Perlite.pdf
> [6] Recent.pdf
> [7] Perlite.pdf
> [8] Perlite.pdf
> [9] Recent.pdf
> [10] Perlite.pdf
> [11] Perlite.pdf
> [12] Perlite.pdf
> [13] Recent.pdf
> [14] Perlite.pdf
> [15] Recent.pdf
> [16] Perlite.pdf
> [17] Perlite.pdf
> [18] Recent.pdf
> [19] Recent.pdf
> [20] Perlite.pdf
> [21] Recent.pdf
> [22] Perlite.pdf
> [23] Perlite.pdf
> [24] Recent.pdf
> [25] Recent.pdf
> [26] Recent.pdf
> [27] Recent.pdf
> [28] Recent.pdf
> [29] Perlite.pdf
> [30] Perlite.pdf
> [31] Perlite.pdf
> [32] Recent.pdf
> [33] Perlite.pdf
> [34] Perlite.pdf
> [35] Recent.pdf
> [36] Recent.pdf
> [37] Perlite.pdf
> [38] Perlite.pdf
> [39] Perlite.pdf
> [40] Recent.pdf
> [41] Recent.pdf


FILE: 'Ross Ashby.md'
---
exported: '2026-02-02T06:02:09.450Z'
source: NotebookLM
type: chat
title: Ross Ashby on 💬How To Guides
tags:
  - How-To
  - NoMethodology
  - Ross-Ashby
author: Ross Ashby
---
Based on the work of W. Ross Ashby, particularly his theories on the "Black Box," "Constraint Analysis," and "Requisite Variety," here is a guide for conducting an investigation into complex, self-organizing (chaordic) systems.

While Ashby does not use the specific term "chaordic," his methodology is designed specifically for systems that are too complex to be fully understood by analysis of their parts, requiring instead a focus on behaviors, constraints, and information flows\[1\]\[2\].

### **Phase 1: Defining the System ( The Observer’s Choice)**

In Ashby’s framework, a system is not a physical object but a list of variables defined by the observer. Your first step is not to look at the "thing," but to define your interest in it.

**The Method:**

1\. **Identify the "Generating Question":** You must start with a pragmatic motive or a specific goal (e.g., "How do we reduce delinquency?" or "How do we fix this machine?")\[3\]\[4\]. Without this, the selection of variables is arbitrary and the system remains undefined\[3\].

2\. **Select the Variables:** Create a provisional list of variables (measurable quantities or states) relevant to your question. Remember, variables do not need to be numerical; they can be states like "on/off," "frozen/melted," or "angry/calm"\[5\]\[6\].

3\. **Test for Closure:** Ensure the list is complete enough that the behavior of the variables is determined by the system itself and not by outside, unobserved forces\[7\].

**Key Questions to Ask:**

• What is the specific "generating question" or problem we are trying to solve?\[3\]

• Which variables are _relevant_? (i.e., If I change variable X, does variable Y change?)\[8\]\[9\].

• Is the system "information-tight"? (Is the system closed to sources of variation or noise other than those we are controlling?)\[1\]\[10\].

\--------------------------------------------------------------------------------

### **Phase 2: The "Black Box" Investigation (The Protocol)**

Treat the system as a "Black Box" that cannot be opened. You must determine its nature solely through its input and output.

**The Method:**

1\. **Manipulate and Record:** Interact with the system's inputs (disturbances or controls) and record the outputs. This record is called the **Protocol**\[11\]\[12\].

2\. **Look for Repetition:** Analyze the protocol to see if the system is "state-determined" (machine-like). This means checking if the same state and conditions always lead to the same next state\[13\]\[14\].

3\. **Recode the Protocol:** Your knowledge of the system is essentially a re-coding of the redundancies found in this protocol. If there are no redundancies (patterns), the system is chaotic and "nothing can be made of it"\[11\]\[15\].

**Key Questions to Ask:**

• Is the system behaving in a "machine-like" way? (Does the present state plus input determine the next state?)\[13\]\[14\].

• If the behavior is capricious (unpredictable), have we missed a variable that acts as a parameter?\[7\]\[16\].

• Do we need to assume the existence of "memory" to explain the behavior? (Ashby argues "memory" is simply a sign that we cannot see a variable that is preserving a past effect)\[17\]\[18\].

\--------------------------------------------------------------------------------

### **Phase 3: Constraint Analysis (Finding the Structure)**

Complex systems are characterized by "constraints"—limitations on variety. If a system were purely chaotic, every variable would act independently. If it is organized, there are constraints.

**The Method:**

1\. **Measure the Variety:** Calculate the number of distinct states the system can be in. If there are N variables each with k states, the total possible variety is kN. If the actual variety is less than this, the system is organized\[19\]\[20\].

2\. **Test for Independence:** Test if the parts of the system are independent. If variables A and B are independent, the system is "reducible" and simpler than it looks\[21\]\[22\].

3\. **Analyze "Cylindrance":** Determine the complexity of the relationships. Can the 100-variable system be understood as just a collection of 3-variable interactions (a cylindrance of 3)? This reveals the true structural complexity\[23\]\[24\].

**Key Questions to Ask:**

• What is the **variety** of the system? (How many distinct states does it actually exhibit vs. how many are theoretically possible?)\[25\]\[26\].

• Is there "conditionality" between the parts? (Does the behavior of part A depend on the state of part B?)\[27\]\[28\].

• Is the system "reducible"? Can we break it into smaller, independent sub-systems without losing the essential behavior?\[21\]\[22\].

\--------------------------------------------------------------------------------

### **Phase 4: Evaluating Regulation and Stability**

If the investigation concerns a living or social system, it is likely trying to maintain stability against a chaotic environment.

**The Method:**

1\. **Identify Essential Variables:** What are the variables that _must_ be kept within limits for the system to survive (e.g., cash flow in a business, temperature in a body)?\[29\]\[30\].

2\. **Apply the Law of Requisite Variety:** Measure the variety of the disturbances (D) threatening the system and the variety of the regulator's (R) responses. For the system to be stable, the variety of R must be greater than or equal to the variety of D\[31\].

3\. **Check for "Double Loop" Learning:** Does the system just correct errors (Loop 1), or does it change its own internal organization when those corrections fail (Loop 2)? This is the definition of an adaptive or "ultrastable" system\[34\].

**Key Questions to Ask:**

• What are the **disturbances** threatening the system?\[37\]\[38\].

• What are the **essential variables** that define survival?\[29\]\[30\].

• Does the regulator possess **Requisite Variety**? (Does it have enough responses to match the number of possible disturbances?)\[31\]\[33\].

• Is the capacity of the regulator limited by its capacity as a communication channel?\[39\]\[40\].

### **Summary Checklist for the Investigator**

1\. **Don't look at the "thing";** look at the list of variables you care about\[41\].

2\. **Don't assume structure;** deduce it from the "protocol" of behaviors\[11\]\[12\].

3\. **Search for constraints;** organization _is_ the presence of constraints (patterns)\[19\]\[20\].

4\. **Calculate the variety;** survival depends on the regulator having enough variety to block environmental variety\[33\]\[42\].

---
> [!info]- References
> [1] Ashby 1991 - Facets of Systems Science.pdf
> [2] Ashby Mechanisms.pdf
> [3] Ashby Mechanisms.pdf
> [4] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [5] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [6] Klir - Ashby Foreword.pdf
> [7] Ashby Mechanisms.pdf
> [8] Ashby Mechanisms.pdf
> [9] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [10] Ashby Mechanisms.pdf
> [11] Ashby 1991 - Facets of Systems Science.pdf
> [12] Ashby Mechanisms.pdf
> [13] Ashby 1991 - Facets of Systems Science.pdf
> [14] Ashby Mechanisms.pdf
> [15] Ashby Mechanisms.pdf
> [16] Ashby’s Cybernetic Framework_ System, Parameter, and Environment.pdf
> [17] Ashby 1991 - Facets of Systems Science.pdf
> [18] Ashby Mechanisms.pdf
> [19] Ashby Mechanisms.pdf
> [20] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [21] Ashby Mechanisms.pdf
> [22] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [23] Ashby Mechanisms.pdf
> [24] Ashby Mechanisms.pdf
> [25] Ashby 1991 - Requisite Variety and Its Implications for the Control of Complex Systems.pdf
> [26] Ashby Req Var.pdf
> [27] Ashby Mechanisms.pdf
> [28] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [29] Ashby 1991 - Requisite Variety and Its Implications for the Control of Complex Systems.pdf
> [30] geoghegan-pangaro-ashby - design for a self-regenerating organization.pdf
> [31] Ashby - Requisite Variety and its implications for the Control of Complex Systems.pdf
> [33] the great ashby - casti.pdf
> [34] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [37] Ashby - Requisite Variety and its implications for the Control of Complex Systems.pdf
> [38] Ashby Req Var.pdf
> [39] Ashby Mechanisms.pdf
> [40] Ashby-Mechanisms_of_intelligence_ocr.pdf
> [41] Klir - Ashby Foreword.pdf
> [42] Ashby - Requisite Variety and its implications for the Control of Complex Systems.pdf


FILE: 'Russ Ackoff.md'
---
exported: '2026-02-01T16:27:08.256Z'
source: NotebookLM
type: chat
title: Russ Ackoff on 💬How To Guides
tags:
  - How-To
  - Methodology
aliases:
  - Interactive Planning
author: Russ Ackoff
---
Based on the comprehensive works of Russell L. Ackoff and his colleagues, here is a guide to conducting an Interactive Planning investigation.

### **Overview: The Philosophy of Interactive Planning**

Interactive planning differs from traditional planning because it does not attempt to forecast the future and prepare for it (preactive) or return to a past state (reactive). Instead, it is designed to **control the future** by designing a desirable future and inventing ways to bring it about\[1\]\[2\].

The process is built on three operating principles:

1\. **The Participative Principle:** The process is the most important product. Planning should not be done _for_ others; stakeholders must do it themselves to understand the system and develop\[3\]\[4\].

2\. **The Principle of Continuity:** Planning is not a one-time event but a continuous cycle of learning and adaptation\[5\]\[6\].

3\. **The Holistic Principle:** You must plan for all parts of the system simultaneously and interdependently, rather than piecemeal\[7\]\[8\].

\--------------------------------------------------------------------------------

### **Phase 1: Formulating the Mess**

The goal of this phase is to determine the future the organization is currently in—the future that _will_ occur if the organization does not change its behaviors\[9\]\[10\]. This creates the imperative for change.

**Steps:**

1\. **Systems Analysis:** Create a detailed description of how the organization currently operates (flow charts of materials, information, and money)\[11\]\[12\].

2\. **Obstruction Analysis:** Identify internal conflicts, discrepancies between what is preached and practiced, and external constraints that block development\[13\]\[14\].

3\. **Reference Projections:** Extrapolate current trends into the future, assuming no changes in plans or policies\[15\]\[16\].

4\. **Reference Scenario:** Synthesize these into a narrative describing the eventual breakdown or "crisis" of the system\[17\]\[18\].

**Questions to Ask:**

• **Defining the System:** "What business are we really in?" (Define this broadly, not just by products)\[19\].

• **Operational Analysis:** "How do materials, money, orders, and information actually flow through the system?" (Look for discrepancies between the formal chart and reality)\[11\]\[20\].

• **Obstructions:** "What policies or practices are currently in force?" "Are there discrepancies between what we say we do and what we actually do?"\[13\]\[21\].

• **The Projections:** "If we do not change our current behavior, and the environment changes only as expected, where will we be in 5 or 10 years?"\[22\]\[23\].

• **The Crisis:** "How will the organization eventually destroy itself or fail to meet its objectives if current trends continue?"\[10\]\[24\].

\--------------------------------------------------------------------------------

### **Phase 2: Ends Planning (Idealized Design)**

This is the core of the methodology. You determine what you _want_ the organization to be, rather than just removing what you don't want\[25\]\[26\].

**Steps:**

1\. **Mission Statement:** Select a unifying purpose\[27\].

2\. **Idealized Design:** Design the system you would have _right now_ if you could have whatever you wanted, subject to two constraints: it must be technologically feasible (no magic) and operationally viable (it must be able to survive)\[28\]\[29\].

3\. **Gap Analysis:** Compare the Idealized Design with the Reference Scenario to identify the gaps to be filled\[30\]\[31\].

**Questions to Ask:**

• **The Central Question:** "If the existing system were destroyed last night, and you could replace it with any system you wanted right now, what would it be?"\[32\]\[33\].

• **Desired Properties:** "What properties should the ideal system have regarding its products, markets, organization, and social responsibilities?"\[34\]\[35\].

• **The Mission:** "What is the unique function of this organization?" "How does it serve its stakeholders?"\[36\]\[37\].

• **Gap Identification:** "What are the specific differences between the future we are heading toward (The Mess) and the future we desire (The Design)?"\[30\]\[31\].

\--------------------------------------------------------------------------------

### **Phase 3: Means Planning**

In this phase, you select the ways to close the gaps between the current reality and the ideal\[38\].

**Steps:**

1\. **Formulating Alternatives:** Invent or discover ways to approximate the ideal. This involves differentiating between acts, courses of action, practices, projects, programs, and policies\[39\]\[40\].

2\. **Problem Dissolution:** Aim to "dissolve" problems (redesign the system so the problem can no longer exist) rather than just "solving" or "resolving" them\[41\]\[42\].

3\. **Evaluation:** Select the best means based on performance measures\[38\].

**Questions to Ask:**

• **Closing Gaps:** "What should be added, eliminated, or changed to approximate the idealized design?"\[40\].

• **Dissolving Problems:** "Can we redesign the environment or the system so that this problem no longer arises, rather than just suppressing the symptoms?"\[41\]\[43\].

• **Incentives:** "Are current incentives producing unintended behavior? How can we align incentives with our new objectives?"\[44\]\[45\].

• **Creativity:** "What self-imposed constraints are limiting our options, and what happens if we remove them?"\[46\].

\--------------------------------------------------------------------------------

### **Phase 4: Resource Planning**

You must determine what is required to implement the chosen means and how to obtain it. This goes beyond just money\[47\].

**Steps:**

1\. **Requirement Analysis:** Estimate needs for five types of resources: inputs (materials/energy), facilities/equipment, personnel, money, and information\[48\]\[49\].

2\. **Availability Analysis:** Determine what will be available under current trends\[50\].

3\. **Filling Gaps:** Plan to generate or acquire the difference\[51\].

**Questions to Ask:**

• **Inputs:** "How much of each resource (personnel, money, materials) is required, when, and where?"\[50\]\[52\].

• **Availability:** "How much will be available at the required time and place if we do nothing new?"\[52\].

• **Shortages/Excess:** "How should we treat shortages (acquire/generate) or excesses (dispose/reallocate)?"\[52\].

• **Personnel:** "How many people of what types are needed?" "How can we increase productivity rather than just headcount?"\[53\]\[54\].

\--------------------------------------------------------------------------------

### **Phase 5: Implementation and Control**

This phase ensures the plan is acted upon and allows for learning\[55\].

**Steps:**

1\. **Implementation Design:** Assign specific responsibilities and schedules\[56\]\[57\].

2\. **Control Design:** Monitor the assumptions and expectations. If expectations are not met, diagnose the cause and correct it\[58\]\[59\].

**Questions to Ask:**

• **Assignment:** "Who is responsible for doing what, and by when?"\[56\]\[57\].

• **Monitoring:** "What are the critical assumptions and expected performance outcomes for each decision?"\[56\]\[59\].

• **Diagnostics:** "If actual performance deviates from expectations, was the error in the implementation, the decision itself, or the information used?"\[60\].

• **Learning:** "How can we design the implementation as an experiment to learn rapidly?"\[61\]\[62\].

\--------------------------------------------------------------------------------

### **Organization of the Effort**

To carry this out effectively, the process should be structured using **Planning Boards**:

• **Structure:** Every manager heads a board consisting of themselves, their immediate superior, and their immediate subordinates\[63\]\[64\].

• **Function:** These boards allow for coordination (at the same level) and integration (between levels), ensuring that plans at different levels do not conflict\[7\]\[65\].

• **Stakeholders:** Include external stakeholders (customers, suppliers) where possible to broaden the perspective\[66\]\[67\].

---
> [!info]- References
> [1] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [2] [Book] Ackoff - A Guide to Controlling Your Corporations Future.pdf
> [3] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [4] [Book] Ackoff - A Guide to Controlling Your Corporations Future.pdf
> [5] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [6] [Book] Ackoff - A Guide to Controlling Your Corporations Future.pdf
> [7] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [8] [Book] Ackoff - A Guide to Controlling Your Corporations Future.pdf
> [9] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [10] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [11] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [12] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [13] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [14] [Book] Ackoff - A Guide to Controlling Your Corporations Future.pdf
> [15] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [16] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [17] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [18] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [19] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [20] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [21] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [22] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [23] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [24] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [25] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [26] [Book] Ackoff - A Guide to Controlling Your Corporations Future.pdf
> [27] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [28] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [29] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [30] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [31] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [32] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [33] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [34] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [35] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [36] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [37] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [38] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [39] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [40] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [41] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [42] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [43] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [44] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [45] [Book] Ackoff,Rovin - 2005 - Beating the system - Berrett-Koehler.pdf
> [46] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [47] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [48] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [49] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [50] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [51] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [52] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [53] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [54] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [55] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [56] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [57] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [58] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [59] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [60] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [61] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [62] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [63] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [64] [Book] Ackoff - A Guide to Controlling Your Corporations Future.pdf
> [65] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [66] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [67] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf


FILE: 'Stafford Beer.md'
---
exported: '2026-02-01T15:56:20.738Z'
source: NotebookLM
type: chat
title: Stafford Beer on 💬How To Guides
tags:
  - How-To
  - Methodology
  - Stafford-Beer
aliases:
  - VSM
author: Stafford Beer
---
Based on the sources provided, particularly Stafford Beer’s _Diagnosing the System for Organizations_, here is a guide for conducting a Viable System Model (VSM) investigation.

A VSM investigation is essentially a diagnostic process. Its goal is not to draw a chart of who reports to whom, but to map the _functions_ necessary for viability and determine if the system has the requisite variety (capacity) to handle the complexity of its environment\[1\],\[2\].

### Phase 1: System Identification and Boundaries

Before analyzing specific subsystems, you must define what you are looking at. The VSM is recursive, meaning systems are nested within systems (like Russian dolls)\[3\],\[4\].

**The Steps:**

1\. **Define the System-in-Focus:** Determine precisely what organization or unit you are modeling\[5\].

2\. **Determine the Recursion Level:** Identify the larger system your System-in-Focus is part of, and the viable systems contained within it\[4\].

3\. **Cut the Context:** Once identified, ruthlessly exclude the wider system and the internal details of the subsystems to focus strictly on the level you are diagnosing\[6\].

**Key Questions to Ask:**

• **What is the System-in-Focus?** Can it maintain a separate existence (is it viable)?\[7\].

• **What is the Purpose?** Remember that "the purpose of a system is what it does," not necessarily what it says it does\[8\].

• **What are the Operational Elements (System One)?** Which specific units _produce_ the organization (e.g., manufacturing plants, not the accounting department)?\[9\].

\--------------------------------------------------------------------------------

### Phase 2: Diagnosis of System One (Operations)

System One consists of the operational units that actually do the work and produce value. They must be viable systems in their own right\[10\].

**The Focus:**Analyze how these units handle the massive complexity (variety) of the environment.

**Key Questions to Ask:**

• **Autonomy:** Do the operational units have enough autonomy to absorb the variety of their local environment, or are they constrained by central management?\[11\].

• **Environment:** Does each operational unit have its own defined environment?\[12\].

• **Variety Engineering:** How do these units attenuate (filter) the incoming variety from the environment (e.g., ignoring irrelevant data)? How do they amplify their own variety back into the environment (e.g., advertising)?\[13\],\[14\].

• **Constraints:** What "legal and corporate requirements" constrain these units?\[15\].

\--------------------------------------------------------------------------------

### Phase 3: Diagnosis of System Two (Anti-Oscillation)

System One units are naturally competitive (for resources, market share, etc.) and can fall into unstable oscillation (e.g., fighting for shared equipment). System Two exists solely to dampen these oscillations\[16\].

**The Focus:**Look for the scheduling, conflict resolution, and standardization functions.

**Key Questions to Ask:**

• **Conflict Resolution:** What prevents the operational units from getting in each other's way? (e.g., a timetable in a school)\[17\].

• **Damping:** Is there a mechanism to stabilize the system when it starts to oscillate, or does the senior management have to intervene constantly?\[18\].

• **Misidentification:** Are we confusing "corporate policy" (System Five) or "control" (System Three) with simple anti-oscillatory routines (System Two)?\[16\].

\--------------------------------------------------------------------------------

### Phase 4: Diagnosis of System Three (Internal Control and Synergy)

System Three represents the "Inside and Now." It is responsible for the immediate, day-to-day management of the internal environment and ensuring the System One units work together (synergy)\[19\].

**The Focus:**The "Resource Bargain" and the "Audit" channel.

**Key Questions to Ask:**

• **Resource Bargain:** How are resources negotiated between central management and the operational units? Is this a dialogue or a dictate?\[15\].

• **Accountability:** How are the units held accountable? Do the reports sent up filter out too much reality?\[20\].

• _(Star):_\* Is there a "sporadic" audit channel that allows management to look directly into operations to verify information (e.g., quality checks, internal audits)?\[21\],\[22\].

• **Synergy:** Does System Three actually provide synergy, or does it just act as an autocratic overlord?\[23\].

\--------------------------------------------------------------------------------

### Phase 5: Diagnosis of System Four (Adaptation and Intelligence)

System Four represents the "Outside and Then." It is responsible for looking at the future, the external environment, and adapting the organization\[24\].

**The Focus:**Adaptation, future planning, and the "Three-Four Homeostat" (the balance between running the business now and changing it for the future).

**Key Questions to Ask:**

• **Future Focus:** Who is responsible for the "outside and then"? Is there a mechanism for capturing external threats and opportunities?\[24\].

• **The Model:** Does System Four contain a model of the total system? It cannot regulate the organization if it does not model it\[25\].

• **The 3-4 Balance:** Is there a healthy tension and interaction between System Three (current stability) and System Four (future change)? If one dominates, the organization either ossifies or goes bankrupt trying to change\[26\],\[27\].

\--------------------------------------------------------------------------------

### Phase 6: Diagnosis of System Five (Policy and Identity)

System Five is responsible for the "closure" of the system—defining what the system is and maintaining its identity. It arbitrates the battle between System Three (stability) and System Four (change)\[28\].

**The Focus:**Identity, ethos, and ultimate authority.

**Key Questions to Ask:**

• **Identity:** Who defines the identity of the system?\[29\].

• **Arbitration:** Does System Five monitor the debate between System Three and System Four? It must intervene if they cannot agree\[28\].

• **Variety:** Does System Five actually represent the whole system, or is it just the "boss" acting as a System One manager?\[30\].

\--------------------------------------------------------------------------------

### Phase 7: Algedonics (Alerts)

A vital part of the investigation is checking for "algedonic" (pain/pleasure) signals. These are signals that bypass the standard filters to wake up the system in an emergency\[31\],\[32\].

**Key Questions to Ask:**

• **Wake-Up Call:** If a catastrophe occurs in System One (e.g., a factory fire), does the signal go straight to System Five, or does it get filtered out by middle management?\[31\].

• **Survival:** Are there mechanisms to detect instability _before_ it becomes a disaster?\[33\].

### Summary Checklist for the Investigator

1\. **Do not use the organization chart.** It usually obscures the true machinery of viability\[34\],\[35\].

2\. **Look for "Variety Engineering."** Viability depends on matching the variety of the controller to the variety of the controlled (Ashby's Law). Where is variety being blocked? Where is it being amplified?\[36\].

3\. **Check for Missing Systems.** Often, System Two (stability) and System Four (future planning) are vestigial or missing entirely\[37\],\[38\].

4\. **Verify the Channels.** Are the communication channels (the arrows in the diagrams) actually working, or are they blocked?\[2\].

---
> [!info]- References
> [1] Adams 2007 - Stafford Beer Contribution to Management Science.pdf
> [2] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [3] Beer - On the Nature of Models - Let us now praise famous men and women too.pdf
> [4] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [5] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [6] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [7] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [8] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [9] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [10] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [11] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [12] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [13] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [14] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [15] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [16] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [17] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [18] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [19] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [20] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [21] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [22] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [23] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [24] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [25] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [26] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [27] [Book] Beer - 1994 - Beyond dispute - Wiley.pdf
> [28] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [29] [Book] Beer - 1994 - Beyond dispute - Wiley.pdf
> [30] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [31] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [32] [Book] Davies - The Unaccountability Machine Why Big Systems Make Terrible Decisions - and How The World Lost its Mind.pdf
> [33] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [34] [Book] Beer - 1981 - Brain of the firm - J. Wiley.pdf
> [35] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [36] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [37] [Book] Beer - 1981 - Brain of the firm - J. Wiley.pdf
> [38] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf


FILE: 'TOC.md'
---
tags:
  - How-To
  - Methodology
  - NoMethodology
  - TOC
title: TOC on 💬How To Guides
author: TOC
---
> [!question] Can you provide a how to guide for a *chaordic investigation* including the questions to ask?
> 

```dataview
LIST
WHERE file.folder = this.file.folder
AND file.name != this.file.name
SORT file.name ASC
```





FILE: 'TOG.md'
---
exported: '2026-02-02T06:04:53.920Z'
source: NotebookLM
type: chat
title: TOG on 💬How To Guides
tags:
  - How-To
  - NoMethodology
  - TOG
author: TOG
---
Based on the "Hull Themes" and the ongoing discussions within the group, a "chaordic" investigation (one that navigates the space between order and chaos, or "entropy") rejects rigid methodologies in favor of a principle-driven, risk-based framework.

The group advocates for an approach that navigates the **"White Space"** (uncertainty/entropy) between **Green** (proven value) and **Red** (proven failure/constraints)\[1\],\[2\].

Here is a guide to conducting this type of investigation, structured by the group’s proposed framework of **Purpose, Framing, Scaling, and Conditions**\[3\],\[4\].

### **Phase 1: Orientation ("Name the Enemy")**

Before applying any tool, you must diagnose the reality of the situation. The goal is to avoid "functionalist" handle-turning (blindly applying a method like VSM or Cynefin) and instead establish the context\[5\],\[6\].

**Key Principles:**

• **Avoid the Illusion of Stasis:** Do not assume the system is stable or that the goal is to return to "Business As Usual" (BAU). The environment is in flux\[7\],\[8\].

• **Diagnosis before Analysis:** Like a medic asking, "Is the pain in your mind or your foot?", you must locate the problem before analyzing it\[9\].

• **Identify the "Water":** Acknowledge the pervasive constraints (e.g., physical infrastructure, geography) that "fish" (practitioners) often ignore because they live in it\[10\].

**Questions to Ask:**

• _Are we trying to solve a problem based on how things "should" be (wishful thinking), or how they actually are?_\[11\].

• _Is the methodology we are choosing determining how we think, or are we choosing the tool based on the context?_\[12\].

• _What are the hard constraints (the "Red" zone) that no amount of adaptive management can overcome (e.g., Victorian railway tunnels)?_\[13\],\[14\].

\--------------------------------------------------------------------------------

### **Phase 2: The Framework (Purpose, Framing, Scaling, Conditions)**

Instead of a linear process, establish these four pillars to structure your investigation\[3\],\[15\].

**1\. Purpose (or Outcomes)**

Define the intent. This involves **"Right-to-Left" (R>L)** thinking: starting from a future concept or constraint and working backward, rather than just evolving what currently exists (L>R)\[1\],\[16\].

• **Question:**_Are we trying to make "stuck things move" (Evolutionary/L>R), or are we designing a "different type of wing" based on new physics (Conceptual/R>L)?_\[16\],\[17\].

**2\. Framing and Scaling**

Complexity is an "observer phenomenon"; boundaries are drawn by you, not nature\[18\],\[19\]. You must decide the "level of recursion" (scale) at which you are intervening.

• **Question:**_Where are we drawing the boundary of opportunity versus the boundary of the firm?_\[20\].

• **Question:**_At what level of recursion are we operating? (e.g., Are we fixing the engine, or the transport policy?)_\[21\].

**3\. Conditions**

This replaces the standard "environment" scan. It acknowledges the "muddle" or entropy that enables or constrains action\[22\].

• **Question:**_What is the "White Space" (entropy) where we lack knowledge or settled evidence?_\[1\],\[2\].

• **Question:**_What are the specific "Constitutive Rules" of this environment (e.g., "X counts as Y in context C")?_\[23\].

\--------------------------------------------------------------------------------

### **Phase 3: The "Italian Flag" Risk Assessment**

This is the core investigative engine. Instead of a binary "Good/Bad," use a ternary model to assess evidence and capability\[1\],\[24\].

• **Green (Settled Positive):** Evidence of things that work and add value.

• **Red (Settled Negative/Constraint):** Evidence of things that fail, are counter-purposeful, or are hard physical constraints.

• **White (Uncertainty/Entropy):** The gap in knowledge. The goal of the investigation is to "do work" to close the white gap—moving items from White to Green (understanding) or White to Red (rejection)\[2\],\[25\].

**The Investigation Procedure:**

1\. **Map the Landscape:** Assign current capabilities and propositions to Red, Green, or White.

2\. **Test for "Constitutive Rules":** Do not just check if a process was followed; check if the process _created value_\[23\].

3\. **Navigate Counterfactuals:** Systems thinking requires understanding "what did _not_ happen" as much as explaining what did. You must navigate the world of counterfactuals to understand risk\[26\],\[27\].

**Questions to Ask:**

• _What do we know is "Good" (Green) and valid in this specific context?_\[23\].

• _What do we know is "Bad" (Red) or unsustainable?_\[28\].

• _What is currently in the "White" (Uncertainty)? Are we being honest about our ignorance here?_\[29\].

• _Does this intervention create actual value, or just compliance with a methodology?_\[30\].

\--------------------------------------------------------------------------------

### **Phase 4: Intervention (Strategic Nudge)**

The investigation should lead to action. The group prefers **Action Theory** and **Nudge Theory** over grand redesigns ("boiling the ocean")\[31\],\[32\].

**Key Principles:**

• **Minimal Change, Maximum Impact:** Look for the "strategic nudge" that shifts the system from Red/White toward Green\[33\].

• **Requisite Variety:** Ensure you have the variety (capabilities) to match the complexity of the problem, but only by "knowing what to ignore"\[12\],\[34\].

**Questions to Ask:**

• _What is the smallest change we can make that will have the intended impact?_\[32\].

• _Have we identified the "critical set" of process steps required to execute correctly?_\[19\].

• _Are we outsourcing understanding? (Danger: You cannot outsource the responsibility of ownership)._\[21\].

### **Summary Checklist for the Investigator**

| Stage | Action | Key Question |
| --- | --- | --- |
| 1. Orientation | Reject "Silver Bullets" & Stasis. | Are we creating a fantasy of stability or engaging with reality?[8],[30] |
| 2. Direction | Apply R>L Thinking. | Are we evolving the past (L>R) or designing from the future (R>L)?[16] |
| 3. Framing | Define Scope & Scale. | Where have we drawn the observer-dependent boundary?[19] |
| 4. Assessment | Apply Italian Flag (R/G/W). | What is the "White Space" of uncertainty we need to close?[2] |
| 5. Action | Strategic Nudge. | Does this intervention satisfy a constitutive rule (create value)?[23] |

---
> [!info]- References
> [1] Hull Themes.pdf
> [2] The Other Group.pdf
> [3] The Other Group.pdf
> [4] The Other Group.pdf
> [5] Hull Themes.pdf
> [6] The Other Group.pdf
> [7] The Other Group - Whatsapp.pdf
> [8] The Other Group - Whatsapp.pdf
> [9] Hull Themes.pdf
> [10] The Other Group.pdf
> [11] The Other Group.pdf
> [12] Hull Themes.pdf
> [13] The Other Group.pdf
> [14] The Other Group.pdf
> [15] The Other Group.pdf
> [16] Hull Themes.pdf
> [17] Hull Themes.pdf
> [18] Hull Themes.pdf
> [19] The Other Group - Whatsapp.pdf
> [20] Hull Themes.pdf
> [21] Hull Themes.pdf
> [22] Hull Themes.pdf
> [23] The Other Group.pdf
> [24] The Other Group.pdf
> [25] The Other Group.pdf
> [26] The Other Group - Whatsapp.pdf
> [27] The Other Group.pdf
> [28] The Other Group.pdf
> [29] Hull Themes.pdf
> [30] The Other Group.pdf
> [31] Hull Themes.pdf
> [32] The Other Group.pdf
> [33] The Other Group.pdf
> [34] The Other Group.pdf


FILE: 'Theory of Constraints.md'
---
exported: '2026-02-02T06:04:38.913Z'
source: NotebookLM
type: chat
title: Theory of Constraints on 💬How To Guides
tags:
  - How-To
  - NoMethodology
  - Theory-of-Constraints
author: Theory of Constraints
---
Based on the provided sources, the specific term "chaordic investigation" does not appear. However, H. William Dettmer’s work focuses heavily on navigating complex, fluid, and uncertain environments (chaos) by applying rigorous logical structures (order) to find leverage points.

The sources describe a **"Scientific Systems Analysis"** approach\[1\] and **"Strategic Navigation"** utilizing the **OODA Loop** (Observe, Orient, Decide, Act) to manage this complexity\[2\],\[3\].

Below is a "How-To" guide for conducting a systems investigation derived from these principles, designed to bring order to a chaotic system.

### **Guide to Systems Investigation (The "Chaordic" Approach)**

This investigation follows the **Constraint Management Model**, which synthesizes the OODA loop with the Theory of Constraints\[3\].

**Phase 1: Observation (Gathering the Chaos)**

Before structuring the problem, you must gather the raw data, perceptions, and facts without filtering them.

**Step 1: Define the System and Goal**You cannot investigate a system without defining its boundaries and its aim.

• **Action:** Determine the span of control (what you can change) and sphere of influence (what you can persuade others to change)\[4\].

• **Action:** Construct an **Intermediate Objectives (IO) Map**. This establishes the standard of performance—the "what should be" against which "what is" will be measured\[5\].

**Step 2: Collect "Tribal Knowledge" (The Crawford Slip Method)**To capture the full complexity of the situation, gather inputs from many knowledgeable people simultaneously to avoid groupthink and capture the "noise" of the system\[6\].

• **Action:** Use the **Crawford Slip Method**. Ask specific target questions and have participants write answers on slips of paper (one idea per slip) to gather mass data quickly\[7\],\[8\].

• **Action:** Use **METT-TC** (Mission, Enemy, Terrain, Troops, Time, Civil considerations) as a framework to ensure you aren't missing environmental factors\[9\],\[10\].

**Phase 2: Orientation (Creating Order)**

This phase synthesizes the gathered observations into a coherent picture of reality using the **Current Reality Tree (CRT)**\[3\].

**Step 3: Identify Mismatches (Undesirable Effects)**

• **Action:** Compare the current reality (data gathered) against the IO Map (the goal).

• **Action:** List the gaps. These are your **Undesirable Effects (UDEs)**. They are the visible symptoms of the chaos\[11\],\[12\].

**Step 4: Map Cause and Effect**

• **Action:** Connect the UDEs to their deeper causes using "If... Then..." logic.

• **Action:** Build downward from the symptoms until you reach the root causes. Use the **Categories of Legitimate Reservation (CLR)** to test the validity of every connection\[13\].

• **Action:** Look for **Negative Reinforcing Loops**, where a UDE actually reinforces the cause that produced it, creating a self-perpetuating cycle of decline\[14\].

**Step 5: Identify the Archimedes Point (Critical Root Cause)**

• **Action:** Identify the **Critical Root Cause (CRC)**. This is the lowest-level cause within your sphere of influence that, if changed, eliminates the majority of the UDEs\[15\],\[16\]. This transforms the "chaos" into a single point of focus.

\--------------------------------------------------------------------------------

### **Questions to Ask During the Investigation**

To conduct this investigation effectively, you must ask specific questions at each stage. These are extracted directly from the logical tools provided in the sources.

**1\. Defining the System (The IO Map Questions)**

• "Who is the ultimate decision maker in this system?"\[17\]

• "What is the system's goal?"\[18\]

• "What are the critical success factors (CSFs) we must have in place to achieve that goal?"\[19\]

• "If a particular CSF was absent, could the goal still be achieved?" (Validity check)\[20\]

**2\. Identifying the Problem (The UDE Questions)**

• "Why are we not able to achieve the goal/CSFs?"\[21\]

• "What are the indications that the company is not achieving the objectives?"\[22\]

• "Does this effect really exist, or is it someone's negative fantasy?"\[23\]

• "So what?" (Used to verify if an effect is truly negative)\[24\]

**3\. Structuring Reality (The CRT Questions)**

• "Why does this undesirable effect exist?"\[21\]

• "What is the direct and unavoidable cause of this effect?"\[13\]

• "Is that the only cause? Could something else cause or contribute to the same effect?"\[13\]

• "Does the cause lie within our span of control or sphere of influence?"\[25\]

**4\. Validating Logic (The CLR Questions)**

• **Clarity:** "Do I understand the meaning of this statement?"\[26\]

• **Causality:** "Does the cause _really_ result in the effect?"\[27\]

• **Cause Insufficiency:** "Can the cause result in the effect on its own, or is a dependent factor missing?"\[28\]

• **Additional Cause:** "If I eliminate the stated cause, is there any other circumstance under which the same degree of effect would occur?"\[29\]

• **Tautology:** "Is the effect offered as a rationale for the existence of the cause?" (Circular logic)\[30\]

**5\. Strategic Environment (METT-TC Questions)**

• **Enemy/Competition:** "What are the key capabilities and skills of our major competitors?"\[10\]

• **Terrain/Market:** "What are the key characteristics of the market or potential clients (likes, dislikes, expectations)?"\[10\]

• **Troops/Support:** "What advantageous capabilities do we have (strengths, skills, technologies)?"\[10\]

• **Civil Considerations:** "What key environmental, political, or social factors bear on our success?"\[10\]

---
> [!info]- References
> [1] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [2] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [3] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [4] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [5] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [6] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [7] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [8] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [9] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [10] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [11] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [12] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [13] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [14] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [15] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [16] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [17] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [18] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [19] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [20] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [21] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [22] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [23] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [24] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [25] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [26] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [27] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [28] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [29] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [30] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf


FILE: 'Tim Allen.md'
---
exported: '2026-02-01T16:30:12.960Z'
source: NotebookLM
type: chat
title: Tim Allen on 💬How To Guides
tags:
  - How-To
  - Methodology
aliases:
  - Hierarchy Theory
author: Tim Allen
---
Based on the provided sources, an investigation into complex biological or social systems should not begin with a search for objective "truth" or rigid data collection, but rather with a self-conscious analysis of the **observer**, the **narrative**, and the **level of analysis**.

The following guide outlines a step-by-step protocol for conducting such an investigation, integrating Hierarchy Theory, Complexity Theory, and Soft Systems Methodology (SSM).

### **Phase 1: Establishing the Observer and the Narrative**

Before measuring anything, you must establish the context of the inquiry. Complexity is not a material property of the world; it is a property of the question being asked\[1\]\[2\].

**Step 1: Acknowledge the Observer's Role**Recognize that you are not detecting a pre-existing "thing" in nature. You are carving a "figure" out of the "ground" based on your specific interests and biological/cultural filters\[3\]\[4\].

• **The Pre-Analytic Step:** You must perform a "compression" of infinite reality down to a general area of discourse (a narrative) before you can compress it further into a formal model\[5\]\[6\].

**Step 2: Define the "Primitive Narrative"**Start with a story. Narratives are more robust than models because they can contain contradictions (e.g., a person can be both a "freedom fighter" and a "terrorist" in a narrative, but not in a formal model)\[7\]\[8\].

• **Goal:** Establish "commensurate experience" among stakeholders rather than finding objective truth\[9\]\[10\].

### **Phase 2: Entification (Defining the System)**

Once the perspective is set, you must define the entities ("holons") and the scale.

**Step 3: Define Grain and Extent**Scale is defined by two measurements:

• **Grain:** The smallest distinction you can make (resolution). Anything smaller is filtered out as noise\[11\]\[12\].

• **Extent:** The total spread of the observation in time and space. Anything larger is part of the invisible background context\[12\]\[13\].

• **Note:** Changing the grain or extent changes the phenomenon. For example, at a fine grain (daily), phytoplankton and zooplankton may be negatively correlated (predation), but at a coarse grain (10 days), they are positively correlated (nutrient cycling)\[14\].

**Step 3: Distinguish Levels of Observation vs. Organization**

• **Level of Observation:** Defined by scale (size/rate). Higher levels are physically larger or slower\[15\]\[16\].

• **Level of Organization:** Defined by definition/type (e.g., organism, population, ecosystem). These are not necessarily size-ordered (e.g., a population of mites is smaller than a single elephant organism)\[16\]\[17\].

### **Phase 3: Hierarchical Structuring**

Analyze the relationships between the entity, its parts, and its context.

**Step 4: Identify Constraint and Freedom**

• **The System (Holon):** The entity at the focal level\[18\].

• **The Lower Level (Mechanism):** The faster, smaller parts. They provide the _potential_ for behavior (the "how") but do not determine the outcome\[19\]\[20\].

• **The Upper Level (Context/Constraint):** The slower, larger environment. It provides the _boundary conditions_ and _significance_ (the "why")\[19\]\[21\].

• **Rule:** Higher levels constrain lower levels not by active intervention, but by being slow and unresponsive to high-frequency fluctuations\[22\].

**Step 5: Determine Rate-Dependence vs. Independence**

• **Rate-Dependent:** Is the system driven by physical laws and fluxes (thermodynamics)? This applies to metabolic processes and high-gain resource use\[23\]\[24\].

• **Rate-Independent:** Is the system driven by rules, codes (DNA, language, laws), or plans? These act as constraints and do not have a rate\[24\]\[25\].

### **Phase 4: Energy and Evolution Analysis**

Determine how the system maintains itself against thermodynamic decay.

**Step 6: Assess Gain (High vs. Low)**

• **High Gain:** Does the system consume high-quality, ready-made resources (e.g., an engine burning gas)? If so, it is predicted by flux, is likely inefficient, and is vulnerable to resource depletion\[26\]\[27\].

• **Low Gain:** Does the system process large amounts of low-quality resources (e.g., subsistence farming)? If so, it is predicted by efficiency/organization and is likely more persistent\[26\]\[28\].

**Step 7: Check for Complexity Costs (Tainter’s Curve)**

• Is the system adding infrastructure/complexity to solve problems?

• Are the returns on this investment diminishing? If complexity costs are rising while benefits plateau, the system is vulnerable to collapse\[29\]\[30\].

**Step 8: Map the Adaptive Cycle (Panarchy)**

• Is the system in a rapid growth phase (**r**)?

• Is it in a conservation/rigid phase (**K**) where it is efficient but brittle?

• Is it facing "creative destruction" (**Ω**) where capital is released?\[31\]\[32\].

\--------------------------------------------------------------------------------

### **Investigator's Checklist: Questions to Ask**

**A. The Observer & Context**

1\. **Who is the observer?** What are their biases, and what specific question are they asking?\[33\]\[34\]

2\. **What is the narrative?** What is the story being told, and does it need to accommodate contradictions that formal models cannot handle?\[7\]\[35\]

3\. **What is the** **Umwelt****?** How does the organism/system perceive its own environment? (e.g., What is "signal" to the organism vs. what is "noise"?)\[36\]\[37\]

**B. Scale & Definition**4\. **What is the Grain?** What is the finest unit of time or space you are measuring?\[11\]5\. **What is the Extent?** What are the total time and space boundaries of your study?\[13\]6\. **Are you studying a specific** **thing** **(Level of Observation) or a** **type** **of thing (Level of Organization)?** (e.g., Are you studying _this_ forest, or the concept of _ecosystems_?)\[38\].

**C. Hierarchy & Constraint**7\. **What is the focal level?** (The level of the phenomenon).8\. **What is the level below?** (The mechanism/parts). Do the parts behave fast enough to be treated as an average or equilibrium by the whole?\[39\].9\. **What is the level above?** (The context). Does it behave slowly enough to be treated as a constant constraint?\[21\].10\. **Is the system nested or non-nested?** Is the upper level physically composed of the lower levels (nested, like a body), or is it a control hierarchy (non-nested, like a food chain)?\[40\]\[41\].

**D. Energy & Sustainability**11\. **Is the system High Gain or Low Gain?** Does it rely on a steep energy gradient (burning high-quality fuel) or a shallow one (refining low-quality inputs)?\[42\].12\. **Who is doing the concentrating?** Is the resource pre-concentrated by nature (high gain subsidy), or must the system work to concentrate it (low gain effort)?\[43\].13\. **Is the system facing diminishing returns?** Is the cost of maintaining current complexity exceeding the benefits of problem-solving?\[29\].

**E. Soft Systems (CATWOE)**For management or policy investigations, apply Checkland’s CATWOE to define the "Root Definition"\[44\]:14\. **C (Clients):** Who benefits or suffers from the system?15\. **A (Actors):** Who performs the activities?16\. **T (Transformation):** What input is transformed into what output?17\. **W (Worldview/Weltanschauung):** What viewpoint makes this system meaningful?18\. **O (Owners):** Who has the power to stop the system?19\. **E (Environment):** What constraints does the system take as given?

---
> [!info]- References
> [1] Allen 2017 - Mapping degrees of complexity, complicatedness, and emergent complexity.pdf
> [2] [Book] Allen - Hierarchy Theory.pdf
> [3] [Book] Allen - Hierarchy Theory.pdf
> [4] [Book] Allen - Toward a Unified Ecology.pdf
> [5] [Book] Allen - Toward a Unified Ecology.pdf
> [6] [Book] Allen - Toward a Unified Ecology.pdf
> [7] Allen 2014 - Holons creaons genon environs in hoerarchy theory where we have gone.pdf
> [8] [Book] Allen - Toward a Unified Ecology.pdf
> [9] Allen - Narratives and transdisciplines for a post-industrial world.pdf
> [10] [Book] Allen - Toward a Unified Ecology.pdf
> [11] [Book] Allen - Hierarchy Theory.pdf
> [12] [Book] Allen - Toward a Unified Ecology.pdf
> [13] [Book] Allen - Hierarchy Theory.pdf
> [14] [Book] Allen - Toward a Unified Ecology.pdf
> [15] Allen The Landscape Levels id Dead.pdf
> [16] [Book] Allen - Toward a Unified Ecology.pdf
> [17] Allen The Landscape Levels id Dead.pdf
> [18] Wu 2013 - Hierarchy theory-An overview.pdf
> [19] [Book] Allen - Hierarchy Theory.pdf
> [20] [Book] Allen - Toward a Unified Ecology.pdf
> [21] [Book] Allen - Hierarchy Theory.pdf
> [22] [Book] Allen - Hierarchy Theory.pdf
> [23] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [24] Integrating_economic_gain_in_biosocial_s.pdf
> [25] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [26] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [27] Allen - Resource Transitions and Energy Gain Contexts of Organisation.pdf
> [28] Integrating_economic_gain_in_biosocial_s.pdf
> [29] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [30] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [31] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [32] [Book] Allen - Toward a Unified Ecology.pdf
> [33] Allen 2017 - Mapping degrees of complexity, complicatedness, and emergent complexity.pdf
> [34] [Book] Allen - Hierarchy Theory.pdf
> [35] Allen - The loss of narrative - paradigms models mechanisms and analogy.pdf
> [36] Allen - Studying innovation ecosystem using ecology theory.pdf
> [37] [Book] Allen - Toward a Unified Ecology.pdf
> [38] Allen The Landscape Levels id Dead.pdf
> [39] Wu 2013 - Hierarchy theory-An overview.pdf
> [40] Wu 2013 - Hierarchy theory-An overview.pdf
> [41] [Book] Allen - Toward a Unified Ecology.pdf
> [42] Tainter Allen 2015 Energy gain and the evolution of organization.pdf
> [43] Tainter Allen 2015 Energy gain and the evolution of organization.pdf
> [44] [Book] Allen - Toward a Unified Ecology.pdf


FILE: 'Triz.md'
---
exported: '2026-02-02T06:05:11.436Z'
source: NotebookLM
type: chat
title: Triz on 💬How To Guides
tags:
  - How-To
  - NoMethodology
  - Triz
author: Triz
---
Based on the provided sources, a "chaordic investigation" in this context refers to the mathematical and psychological modeling of the creative process, specifically using **Search Substance-Field (Su-Field) analysis** and **Chaos Theory** (strange attractors). This approach, detailed primarily by Alexandr Bushuev, synthesizes the logic of Triz (specifically ARIZ) with the non-linear dynamics of creative thinking.

The investigation moves from a static contradiction (Order) through a phase of oscillating search and instability (Chaos) to the birth of a new solution (New Order).

Here is a how-to guide for conducting a chaordic investigation, translating the mathematical models into an actionable process.

\--------------------------------------------------------------------------------

### **How-To Guide: Conducting a Chaordic Investigation**

This guide models the "Search Su-Field," which simulates the creative thinking process where a solution (the "X-element") is born from the struggle between opposing system properties\[1\]\[2\].

**Phase 1: The Embryonic Stage (Defining the Static Contradiction)**

**Goal:** Define the "parents" of the problem—the opposing properties that are locked in a struggle (homeostasis).

• **Step 1: Identify the Contradictory Properties.**Identify the two parameters of the system that are in conflict (e.g., maneuverability vs. comfort, or speed vs. safety). In the model, these are variables x and y\[3\].

    ◦ _The Concept:_ There is a mutual struggle and interchange of energy/information between these properties. They sustain each other but prevent the system from evolving\[4\].
• **Questions to Ask:**

    1. What is the **Property** X (e.g., the "Father") that we are trying to improve?\[5\]    2. What is the **Property** Y (e.g., the "Mother") that deteriorates when X is improved?\[5\]    3. How do these two properties currently exist in "homeostasis" (balance)? Why can't one exist without limiting the other?\[4\]

**Phase 2: Breaking Symmetry (The Destabilization)**

**Goal:** Move from a static problem to a dynamic search by prioritizing one side of the conflict. This breaks the symmetry of the problem, a necessary step for self-organization and evolution\[5\]\[6\].

• **Step 2: Choose the Dominant Property (The "Father").**Select the side of the conflict that provides the _main useful function_ of the system. This aligns with **Step 1.4 of ARIZ** (Algorithm for Inventive Problem Solving)\[5\].

    ◦ _The Concept:_ You are artificially resolving one side of the conflict to force the system into a search state. The "Father" (resolved property) generates an "own motion" (independence), while the "Mother" (unresolved property) enters a state of "pregnancy" (search)\[7\].
• **Questions to Ask:**

    1. Which property ensures the system’s primary function is performed? (Treat this as the "Father" element).    2. If we strictly satisfy the "Father" property, what specifically happens to the "Mother" property?    3. How can we model the "Mother" property as losing its ability to reproduce the old problem?\[8\]

**Phase 3: The Search Oscillation (The Chaotic Phase)**

**Goal:** Simulate the subconscious search for the "X-element" (the solution). This is modeled by **Chaotic Attractors** (Rőssler or Lorenz attractors)\[9\]\[10\].

• **Step 3: Initiate Search Oscillations.**Instead of a direct logical path, allow the "Mother" element to oscillate or "hunt" for a new connection. This simulates the psychological process of generating random associations in the subconscious\[4\]\[11\].

    ◦ _The Concept:_ The "Mother" property interacts with an unknown information field (z). This interaction is chaotic and unstable. This is where the "Baby" (the X-element/solution) begins to form in the subconscious\[12\].
• **Questions to Ask:**

    1. What are the **random search oscillations**? (What different physical effects or resources can we "collide" with the unresolved property?)\[4\].    2. How does the system behave if we allow local instability? (e.g., What happens if we rapidly alternate between the two contradictory states?)\[13\].    3. Is there a "homoclinic orbit"? (Is there a recurring idea that seems unstable or "crazy" but keeps appearing in the search?)\[14\].

**Phase 4: The Birth of the X-Element (The New Order)**

**Goal:** Move the X-element from the subconscious (embryonic) to the conscious level (solution).

• **Step 4: Establish the New Homeostasis.**Identify the "Baby" (X-element) that creates a new stable relationship with the "Mother" property while allowing the "Father" property to remain resolved\[7\]\[8\].

    ◦ _The Concept:_ The X-element (Coordinate z) must enter a feedback loop. In a **Lorenz Attractor** model, the X-element "helps" the original useful function (Father) rather than just fighting the harmful function\[15\].
• **Questions to Ask:**

    1. What is the **X-element** (z) that has appeared from the search? (This is often a resource like a field, substance, or information)\[16\].    2. Does this X-element eliminate the harmful side of the conflict (The "Mother's" negative effect)?\[17\].    3. Does the X-element enter into a new, stable cycle (homeostasis) with the system components?\[18\].
\--------------------------------------------------------------------------------

### **Summary Checklist for Chaordic Investigation**

Use this checklist to ensure you are following the mathematical-physical model of creative thought:

1\. **Define opposing coordinates:** Did you map the technical contradiction to variables x and y?\[3\]

2\. **Break Symmetry:** Did you prioritize the "Father" (Main Useful Function) to destabilize the system?\[5\]

3\. **Identify the Attractor:** Are you looking for a static solution, or are you looking for a dynamic process (oscillation)? (e.g., Does the solution require the system to change states rapidly or exist in a "screw chaos"?)\[14\].

4\. **Check for "Global Compression":** Are you applying high pressure (severe constraints) to the problem? Chaos emerges from "Global compression under local instability."\[13\].

### **Glossary of Chaordic Investigation Terms**

• **Su-Field (Substance-Field):** A model of the problem consisting of substances and the fields that interact with them. In this context, it models the interaction of thoughts and system properties\[1\].

• **Homeostasis:** The mutual struggle and balance between opposing properties (e.g., x and y) that keeps a problem unsolved\[4\].

• **Father (**F**):** The system property providing the main useful function. In the investigation, this is the side of the conflict we choose to satisfy first\[5\].

• **Mother (**M**):** The conflicting property that deteriorates. It becomes the active "searcher" for the solution\[5\]\[8\].

• **Baby (**B**):** The X-element or final solution. It is born in the subconscious through the chaotic interaction of the "Mother" property and the information field\[7\].

• **Rőssler/Lorenz Attractors:** Mathematical models of chaotic systems used to simulate the non-linear "hunting" or oscillation of the creative mind during problem-solving\[9\]\[10\].

---
> [!info]- References
> [1] The Search Substance Field.pdf
> [2] The Search Substance Field.pdf
> [3] The Search Substance Field.pdf
> [4] The Search Substance Field.pdf
> [5] The Search Substance Field.pdf
> [6] The Search Substance Field.pdf
> [7] The Search Substance Field.pdf
> [8] The Search Substance Field.pdf
> [9] The Search Substance Field.pdf
> [10] The Search Substance Field.pdf
> [11] The Search Substance Field.pdf
> [12] The Search Substance Field.pdf
> [13] The Search Substance Field.pdf
> [14] The Search Substance Field.pdf
> [15] The Search Substance Field.pdf
> [16] The Search Substance Field.pdf
> [17] The Search Substance Field.pdf
> [18] The Search Substance Field.pdf


FILE: 'Warren Weaver.md'
---
exported: '2026-02-02T06:05:25.096Z'
source: NotebookLM
type: chat
title: Warren Weaver on 💬How To Guides
tags:
  - How-To
  - NoMethodology
  - Warren-Weaver
author: Warren Weaver
---
Based on the provided sources, a "chaordic" investigation—one that navigates the intersection of chaos and order within complex systems—requires shifting from linear, analytical problem-solving to a cyclical, systemic design approach. This approach acknowledges that systems are open, observers are biased, and stability is dynamic rather than static.

Here is a guide to conducting such an investigation, organized by the phases of Systemic Design and Complexity Science.

### Phase 1: Establish the Observer and the Frame

Before investigating the system, you must investigate your own position. You cannot observe a system without influencing it or being influenced by your own categories of thought.

• **Define the Observer:** Recognize that "attributes" or "qualities" of a system are often relationships between the thing observed and the observer\[1\]. You must decide on the "grain" (resolution) and "scope" (boundaries) of your observation\[2\].

• **Establish the Team Identity:** Determine who is investigating. Insights into "who we are" are often best gained by reflecting on "who we are not" and where you draw the boundaries between yourselves and "the other"\[3\].

• **Set the Rules of Discourse:** Chaotic investigations require rigorous communication rules to prevent fragmentation. This includes listening without immediate judgment and treating all perspectives as valid data points\[4\].

**Key Questions to Ask:**

• _Why do I see what I see?_ (The first question of the Systems Triumvirate)\[5\].

• _What are the sources of difference between the observed system and the desired system?_\[6\].

• _Where are the boundaries of my system? What can I control? What can I influence?_\[7\].

• _What specific "identifying variables" are we using to define the system, and are they agreed upon?_ (e.g., When does a village become a city?)\[8\].

### Phase 2: Inquiring and Scanning (The Search for Information)

In this phase, you gather data. However, unlike simple problems where you filter out noise, in a chaordic investigation, "noise" may be unrecognized information or concealed openness.

• **Scan the Environment:** Look beyond the immediate problem. Use "Inquiring" to reach outside the team's knowledge base through ethnography, literature, and non-traditional sources like art or myths\[9\].

• **Identify the "Missing":** Apply "Boulding’s Backward Basis": look for what _isn't_ there. If a system usually produces X and X is absent, that is a critical data point\[10\],\[11\].

• **Seek "Statistical Complexity":** Do not look for perfect order (crystals) or perfect randomness (gas). Look for the "edge of chaos"—structures that are hard to predict but not random. Statistical complexity measures the amount of information needed to predict the future of the system based on its past\[12\],\[13\].

**Key Questions to Ask:**

• _What are the flows of energy, matter, and information that maintain the organization?_\[7\].

• _What are the competing versions of ‘reality’ observed in the system and where do they originate?_\[6\].

• _What is "missing" that should be here?_ (e.g., Why are there no personal items in this office? Why is the delivery date never mentioned?)\[10\].

• _Is the behavior we see generated by the system's internal structure or by "concealed openness" (external inputs we haven't identified)?_\[14\].

### Phase 3: Mapping and Formulating (Finding the Logic)

Here, you attempt to define the logic or "grammar" of the system. You are looking for the underlying structure that generates the observed behavior.

• **Map the System:** Group actors and phenomena based on shared motivations or behaviors. Look for "assemblages" of shared interests\[15\].

• **Identify Attractors and Regimes:** Use qualitative tools to identify stable patterns (attractors) or dynamic regimes. If the system behaves differently at different times, it may be shifting between multiple stable states\[16\],\[17\].

• **Distinguish "State-Determined" from "Open" Behavior:** Determine if the system's future is determined solely by its current state (closed) or if it is reacting to invisible inputs (open)\[14\].

• **Deconstruct Symbols:** Recognize that words and symbols gain meaning through difference (e.g., "cat" is meaningful because it is not "dog"). Analyze the "trace" of these meanings to understand cultural logic\[18\].

**Key Questions to Ask:**

• _Why do things stay the same?_ (The second question of the Systems Triumvirate—investigating stability and resilience)\[5\],\[19\].

• _What stabilizing dynamics maintain the current patterns of behavior?_\[20\].

• _Where are the positive feedback loops that are capable of destabilizing current patterns?_\[20\].

• _Is the "order" we see actually "order of the second degree" (laws about laws)?_\[21\].

### Phase 4: Generating and Probing (Action as Investigation)

In complex systems, you often cannot understand the system until you interact with it. Action is a form of inquiry.

• **Design Probes:** Develop actions designed specifically to learn, not just to solve. These "probing actions" provoke the system to reveal its organization and intent\[22\].

• **Tell the Story (Narrative):** Construct a narrative to explain _why_ the system behaves as it does. This narrative gives meaning to the data and bounds the "plot" of the system\[23\],\[24\].

• **Iterate:** Use the "OODA Loop" (Observe, Orient, Decide, Act) not just for speed, but to exploit ambiguity and update your internal models of the environment\[25\].

**Key Questions to Ask:**

• _Why do things change?_ (The third question of the Systems Triumvirate)\[5\].

• _What probing actions could provoke the system to respond and reveal information about its organization?_\[22\].

• _How can we build adaptability into our design to cope with unforeseen obstacles?_\[26\].

• _What indirect changes to the environment will help achieve our goals?_ (Designing the context rather than the object)\[6\].

### Phase 5: Reflecting (Meta-Inquiry)

Finally, a chaordic investigation requires constant checking of your own cognitive processes.

• **Challenge Boundaries:** Question the limits you placed on the problem. Are they too restrictive or too broad?\[27\].

• **Check for "Methodism":** Are you unthinkingly applying a sequence of actions you learned previously, rather than addressing the specific, individual configuration of the current situation?\[28\].

• **Apply "The Count-to-Three Principle":** If you cannot think of three ways your tool or model could be abused or misled, you do not understand it\[29\].

**Key Questions to Ask:**

• _How can I learn how to learn faster?_\[26\].

• _What indicators would reveal that the logic of our design has been violated?_\[6\].

• _What metaphors shape our understanding of the problem situation?_\[20\].

• _How much of my observation is "through the eyes of others"?_\[30\].

---
> [!info]- References
> [1] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [2] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [3] [Book] Ryan - Art of Design Student Text.pdf
> [4] [Book] Ryan - Art of Design Student Text.pdf
> [5] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [6] [Book] Ryan - Art of Design Student Text.pdf
> [7] [Book] Ryan - Art of Design Student Text.pdf
> [8] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [9] Ryan - A Framework for Systemic Design.pdf
> [10] [Book] Weinberg - The Secrets of Consulting A Guide to Giving and Getting Advice Successfully.pdf
> [11] [Book] Weinberg - The Secrets of Consulting A Guide to Giving and Getting Advice Successfully.pdf
> [12] A SYNTHESIS AND A PRACTICAL APPROACH TO COMPLEX SYSTEMS - brodhu.pdf
> [13] Ryan an information theoretic primer on complexity self organization and emergence.pdf
> [14] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [15] [Book] Ryan - Art of Design Student Text.pdf
> [16] A SYNTHESIS AND A PRACTICAL APPROACH TO COMPLEX SYSTEMS - brodhu.pdf
> [17] A SYNTHESIS AND A PRACTICAL APPROACH TO COMPLEX SYSTEMS - brodhu.pdf
> [18] Rahman - Myth of objectivity and the origin of symbols.pdf
> [19] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [20] [Book] Ryan - Art of Design Student Text.pdf
> [21] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [22] [Book] Ryan - Art of Design Student Text.pdf
> [23] [Book] Ryan - Art of Design Student Text.pdf
> [24] [Book] Ryan - Art of Design Student Text.pdf
> [25] Ryan 2011 - Military applications of Complex Systems.pdf
> [26] [Book] Ryan - Art of Design Student Text.pdf
> [27] [Book] Ryan - Art of Design Student Text.pdf
> [28] [Book] Ryan - Art of Design Student Text.pdf
> [29] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [30] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf


FILE: 'index.md'
---
aliases:
  - Summary
  - How To Guides with Questions
tags:
  - How-To
  - Summary
title: 💬How To Guides
author: index
linter-yaml-title-alias: Summary
---
This prompt is designed to deliver the material in practical form, the essential checklist required to run a study. It significantly extends the value of the rambling philosophical approach to recast the material in a structured ready to use imperative form

> [!question] Prompt
> Can you provide a how to guide for an *methodology* investigation including the questions to ask.

# Summary

These sources collectively outline diverse **methodologies for investigating complex, "chaordic" systems** by shifting from linear problem-solving to systemic inquiry. Leaders like **Alan Kay** and **Donella Meadows** emphasize that understanding begins by questioning the underlying **context** and identifying **leverage points** within feedback loops. Techniques such as **cognitive mapping** and **stakeholder analysis** are proposed to surface hidden **assumptions** and varied mental models. The texts argue that systems are **structure-determined**, meaning observers must listen to the system's inherent "beat" rather than imposing external control. Ultimately, the investigation process is framed as a **non-linear conversation** designed to trigger structural shifts and navigate uncertainty. This comprehensive guide serves as a toolkit for diagnosing **dysfunctional communication**, assessing **fragility**, and co-designing interventions.

